/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedElementDuplicateHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginal;

    public NamedElementDuplicateHandler(EditorActionHandler original) {
        super(true);
        this.myOriginal = original;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            NamedElementDuplicateHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            NamedElementDuplicateHandler.$$$reportNull$$$0(1);
        }
        return this.myOriginal.isEnabled(editor, caret, dataContext);
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Project project = editor.getProject();
        if (project != null && !editor.getSelectionModel().hasSelection()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 != null) {
                VisualPosition caretPosition = editor.getCaretModel().getVisualPosition();
                Pair<LogicalPosition, LogicalPosition> lines = EditorUtil.calcSurroundingRange(editor, caretPosition, caretPosition);
                TextRange toDuplicate = new TextRange(editor.logicalPositionToOffset((LogicalPosition)lines.first), editor.logicalPositionToOffset((LogicalPosition)lines.second));
                PsiElement name = NamedElementDuplicateHandler.findNameIdentifier(editor, file2, toDuplicate);
                if (name != null && !name.getTextRange().containsOffset(editor.getCaretModel().getOffset())) {
                    editor.getCaretModel().moveToOffset(name.getTextOffset());
                }
            }
        }
        this.myOriginal.execute(editor, caret, dataContext);
    }

    public EditorActionHandler getOriginal() {
        return this.myOriginal;
    }

    @Nullable
    private static PsiElement findNameIdentifier(Editor editor, PsiFile file2, TextRange toDuplicate) {
        TextRange range2;
        int nonWs = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)toDuplicate.getStartOffset(), (String)"\n\t ");
        PsiElement named = null;
        for (PsiElement psi = file2.findElementAt(nonWs); psi != null && (range2 = psi.getTextRange()) != null && !(psi instanceof PsiFile) && toDuplicate.contains(psi.getTextRange()); psi = psi.getParent()) {
            if (!(psi instanceof PsiNameIdentifierOwner)) continue;
            named = ((PsiNameIdentifierOwner)psi).getNameIdentifier();
        }
        return named;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caret";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/actions/NamedElementDuplicateHandler";
        objectArray[2] = "isEnabledForCaret";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

