/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ProjectNotificationAware;
import com.intellij.openapi.externalSystem.autoimport.ProjectRefreshAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.ui.DefaultExternalSystemIconProvider;
import com.intellij.openapi.externalSystem.ui.ExternalSystemIconProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.NaturalComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\u000e\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0010\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectRefreshAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getNotificationDescription", "", "systemIds", "", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getNotificationIcon", "Ljavax/swing/Icon;", "getNotificationText", "update", "naturalJoin", "", "intellij.platform.externalSystem.impl"})
public final class ProjectRefreshAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ProjectNotificationAware projectNotificationAware = ProjectNotificationAware.Companion.getInstance(project2);
        Set<ProjectSystemId> systemIds = projectNotificationAware.getSystemIds();
        if (ExternalSystemUtil.confirmLoadingUntrustedProject(project2, (Collection<ProjectSystemId>)systemIds)) {
            ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance(project2);
            projectTracker.scheduleProjectRefresh();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        ProjectNotificationAware notificationAware = ProjectNotificationAware.Companion.getInstance(project2);
        Set<ProjectSystemId> systemIds = notificationAware.getSystemIds();
        Collection collection = systemIds;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setText(this.getNotificationText(systemIds));
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            presentation3.setDescription(this.getNotificationDescription(systemIds));
            Presentation presentation4 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
            presentation4.setIcon(this.getNotificationIcon(systemIds));
        }
        Presentation presentation5 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
        presentation5.setEnabled(notificationAware.isNotificationVisible());
    }

    private final String getNotificationText(Set<ProjectSystemId> systemIds) {
        String systemsPresentation2 = CollectionsKt.joinToString$default((Iterable)systemIds, null, null, null, (int)0, null, (Function1)getNotificationText.systemsPresentation.1.INSTANCE, (int)31, null);
        String string = ExternalSystemBundle.message((String)"external.system.reload.notification.action.reload.text", (Object[])new Object[]{systemsPresentation2});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExternalSystemBundle.mes\u2026xt\", systemsPresentation)");
        return string;
    }

    private final String naturalJoin(List<String> $this$naturalJoin) {
        if ($this$naturalJoin.size() == 0) {
            return "";
        }
        if ($this$naturalJoin.size() == 1) {
            return (String)CollectionsKt.first($this$naturalJoin);
        }
        String leading = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast($this$naturalJoin, (int)1), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        String string = ExternalSystemBundle.message((String)"external.system.reload.notification.action.reload.and.conjunction", (Object[])new Object[]{leading, CollectionsKt.last($this$naturalJoin)});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExternalSystemBundle.mes\u2026nction\", leading, last())");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getNotificationDescription(Set<ProjectSystemId> systemIds) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = systemIds;
        ProjectRefreshAction projectRefreshAction = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProjectSystemId projectSystemId = (ProjectSystemId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getReadableName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        Iterable iterable2 = collection;
        Comparator comparator2 = NaturalComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"NaturalComparator.INSTANCE");
        String systemsPresentation2 = projectRefreshAction.naturalJoin(CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2));
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String productName = applicationNamesInfo.getFullProductName();
        String string = ExternalSystemBundle.message((String)"external.system.reload.notification.action.reload.description", (Object[])new Object[]{systemsPresentation2, productName});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExternalSystemBundle.mes\u2026resentation, productName)");
        return string;
    }

    private final Icon getNotificationIcon(Set<ProjectSystemId> systemIds) {
        ExternalSystemIconProvider externalSystemIconProvider;
        switch (systemIds.size()) {
            case 1: {
                externalSystemIconProvider = ExternalSystemIconProvider.Companion.getExtension((ProjectSystemId)CollectionsKt.first((Iterable)systemIds));
                break;
            }
            default: {
                externalSystemIconProvider = (ExternalSystemIconProvider)DefaultExternalSystemIconProvider.INSTANCE;
            }
        }
        ExternalSystemIconProvider iconManager = externalSystemIconProvider;
        return iconManager.getReloadIcon();
    }

    public ProjectRefreshAction() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String productName = applicationNamesInfo.getFullProductName();
        Presentation presentation2 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
        presentation2.setIcon(DefaultExternalSystemIconProvider.INSTANCE.getReloadIcon());
        Presentation presentation3 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"templatePresentation");
        presentation3.setText(ExternalSystemBundle.message((String)"external.system.reload.notification.action.reload.text.empty", (Object[])new Object[0]));
        Presentation presentation4 = this.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"templatePresentation");
        presentation4.setDescription(ExternalSystemBundle.message((String)"external.system.reload.notification.action.reload.description.empty", (Object[])new Object[]{productName}));
    }
}

