/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.ui.ExternalToolWindowManager;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewAdapter;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectExternalSystemNodeDialog
extends DialogWrapper {
    @NotNull
    private final SimpleTree myTree;
    @Nullable
    private final Predicate<SimpleNode> mySelector;
    @Nullable
    protected Boolean groupTasks;
    @Nullable
    protected Boolean useTasksNode;

    public SelectExternalSystemNodeDialog(@NotNull ProjectSystemId systemId2, @NotNull Project project, @NotNull String title, Class<? extends ExternalSystemNode> nodeClass, @Nullable Predicate<SimpleNode> selector) {
        if (systemId2 == null) {
            SelectExternalSystemNodeDialog.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SelectExternalSystemNodeDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            SelectExternalSystemNodeDialog.$$$reportNull$$$0(2);
        }
        this(systemId2, project, title, new Class[]{nodeClass}, selector);
    }

    public SelectExternalSystemNodeDialog(@NotNull ProjectSystemId systemId2, @NotNull Project project, @NotNull @NlsContexts.DialogTitle String title, final Class<? extends ExternalSystemNode>[] nodeClasses, @Nullable Predicate<SimpleNode> selector) {
        ToolWindow toolWindow;
        if (systemId2 == null) {
            SelectExternalSystemNodeDialog.$$$reportNull$$$0(3);
        }
        if (project == null) {
            SelectExternalSystemNodeDialog.$$$reportNull$$$0(4);
        }
        if (title == null) {
            SelectExternalSystemNodeDialog.$$$reportNull$$$0(5);
        }
        super(project, false);
        this.mySelector = selector;
        this.setTitle(title);
        this.myTree = new SimpleTree();
        this.myTree.getSelectionModel().setSelectionMode(1);
        ExternalProjectsView projectsView = ExternalProjectsManagerImpl.getInstance(project).getExternalProjectsView(systemId2);
        if (projectsView == null && (toolWindow = ExternalToolWindowManager.getToolWindow(project, systemId2)) instanceof ToolWindowEx) {
            projectsView = new ExternalProjectsViewImpl(project, (ToolWindowEx)toolWindow, systemId2);
            Disposer.register((Disposable)this.getDisposable(), (Disposable)((ExternalProjectsViewImpl)projectsView));
        }
        if (projectsView != null) {
            final ExternalProjectsStructure treeStructure = new ExternalProjectsStructure(project, (Tree)this.myTree){

                @Override
                protected Class<? extends ExternalSystemNode>[] getVisibleNodesClasses() {
                    return nodeClasses;
                }

                @Override
                @NotNull
                public Object getRootElement() {
                    Object rootElement = super.getRootElement();
                    Object object = SelectExternalSystemNodeDialog.this.customizeProjectsTreeRoot(rootElement);
                    if (object == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return object;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/ui/SelectExternalSystemNodeDialog$1", "getRootElement"));
                }
            };
            Disposer.register((Disposable)this.myDisposable, (Disposable)treeStructure);
            treeStructure.init(new ExternalProjectsViewAdapter(projectsView){

                @Override
                @NotNull
                public ExternalProjectsStructure getStructure() {
                    ExternalProjectsStructure externalProjectsStructure = treeStructure;
                    if (externalProjectsStructure == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return externalProjectsStructure;
                }

                @Override
                public void updateUpTo(ExternalSystemNode node) {
                    treeStructure.updateUpTo(node);
                }

                @Override
                public boolean getGroupTasks() {
                    return SelectExternalSystemNodeDialog.this.groupTasks != null ? SelectExternalSystemNodeDialog.this.groupTasks.booleanValue() : super.getGroupTasks();
                }

                @Override
                public boolean useTasksNode() {
                    return SelectExternalSystemNodeDialog.this.useTasksNode != null ? SelectExternalSystemNodeDialog.this.useTasksNode.booleanValue() : super.useTasksNode();
                }

                @Override
                public void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
                    if (node == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    SelectExternalSystemNodeDialog.this.handleDoubleClickOrEnter(node, actionId, inputEvent);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/SelectExternalSystemNodeDialog$2";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getStructure";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/SelectExternalSystemNodeDialog$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "handleDoubleClickOrEnter";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            Collection projectsData = ProjectDataManager.getInstance().getExternalProjectsData(project, systemId2);
            List dataNodes = ContainerUtil.mapNotNull((Collection)projectsData, info -> info.getExternalProjectStructure());
            treeStructure.updateProjects(dataNodes);
            TreeUtil.expandAll((JTree)this.myTree);
            if (this.mySelector != null) {
                TreeUtil.promiseSelect((JTree)this.myTree, path -> {
                    SimpleNode node = (SimpleNode)TreeUtil.getLastUserObject(SimpleNode.class, (TreePath)path);
                    return node != null && this.mySelector.test(node) ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
                });
            }
        }
        this.init();
    }

    protected Object customizeProjectsTreeRoot(Object rootElement) {
        return rootElement;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
        if (node == null) {
            SelectExternalSystemNodeDialog.$$$reportNull$$$0(6);
        }
    }

    protected SimpleNode getSelectedNode() {
        return this.myTree.getNodeFor(this.myTree.getSelectionPath());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        pane2.setPreferredSize((Dimension)JBUI.size((int)320, (int)400));
        return pane2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/SelectExternalSystemNodeDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDoubleClickOrEnter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

