/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileNode {
    private final VirtualFile myFile;
    private final AtomicReference<Icon> myIcon;
    private final AtomicReference<String> myName;
    private final AtomicReference<String> myComment;
    private final AtomicBoolean myValid;
    private final AtomicBoolean myHidden;
    private final AtomicBoolean mySpecial;
    private final AtomicBoolean mySymlink;
    private final AtomicBoolean myWritable;

    FileNode(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileNode.$$$reportNull$$$0(0);
        }
        this.myIcon = new AtomicReference();
        this.myName = new AtomicReference();
        this.myComment = new AtomicReference();
        this.myValid = new AtomicBoolean();
        this.myHidden = new AtomicBoolean();
        this.mySpecial = new AtomicBoolean();
        this.mySymlink = new AtomicBoolean();
        this.myWritable = new AtomicBoolean();
        this.myFile = file2;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public Icon getIcon() {
        return this.myIcon.get();
    }

    boolean updateIcon(Icon icon2) {
        return !Objects.equals(icon2, this.myIcon.getAndSet(icon2));
    }

    @NlsSafe
    public String getName() {
        return this.myName.get();
    }

    boolean updateName(String name) {
        return !Objects.equals(name, this.myName.getAndSet(name));
    }

    @NlsSafe
    public String getComment() {
        return this.myComment.get();
    }

    boolean updateComment(String comment) {
        return !Objects.equals(comment, this.myComment.getAndSet(comment));
    }

    public boolean isValid() {
        return this.myValid.get();
    }

    boolean updateValid(boolean valid) {
        return valid != this.myValid.getAndSet(valid);
    }

    public boolean isHidden() {
        return this.myHidden.get();
    }

    boolean updateHidden(boolean hidden) {
        return hidden != this.myHidden.getAndSet(hidden);
    }

    public boolean isSpecial() {
        return this.mySpecial.get();
    }

    boolean updateSpecial(boolean special) {
        return special != this.mySpecial.getAndSet(special);
    }

    public boolean isSymlink() {
        return this.mySymlink.get();
    }

    boolean updateSymlink(boolean symlink) {
        return symlink != this.mySymlink.getAndSet(symlink);
    }

    public boolean isWritable() {
        return this.myWritable.get();
    }

    boolean updateWritable(boolean writable) {
        return writable != this.myWritable.getAndSet(writable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileChooser/tree/FileNode", "<init>"));
    }
}

