/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class RemovedMappingTracker {
    private final Map<FileNameMatcher, RemovedMapping> myRemovedMappings = new HashMap<FileNameMatcher, RemovedMapping>();
    @NonNls
    private static final String ELEMENT_REMOVED_MAPPING = "removed_mapping";
    @NonNls
    private static final String ATTRIBUTE_APPROVED = "approved";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";

    RemovedMappingTracker() {
    }

    void clear() {
        this.myRemovedMappings.clear();
    }

    void add(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName, boolean approved) {
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(0);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(1);
        }
        this.myRemovedMappings.put(matcher, new RemovedMapping(matcher, fileTypeName, approved));
    }

    void load(@NotNull Element e) {
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(2);
        }
        for (RemovedMapping mapping2 : RemovedMappingTracker.readRemovedMappings(e)) {
            this.myRemovedMappings.put(mapping2.myFileNameMatcher, mapping2);
        }
    }

    @NotNull
    static List<RemovedMapping> readRemovedMappings(@NotNull Element e) {
        List children2;
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(3);
        }
        if ((children2 = e.getChildren(ELEMENT_REMOVED_MAPPING)).isEmpty()) {
            List<RemovedMapping> list2 = Collections.emptyList();
            if (list2 == null) {
                RemovedMappingTracker.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        for (Element mapping2 : children2) {
            String ext = mapping2.getAttributeValue("ext");
            ExtensionFileNameMatcher matcher = ext == null ? FileTypeManager.parseFromString((String)mapping2.getAttributeValue("pattern")) : new ExtensionFileNameMatcher(ext);
            boolean approved = Boolean.parseBoolean(mapping2.getAttributeValue(ATTRIBUTE_APPROVED));
            String fileTypeName = mapping2.getAttributeValue(ATTRIBUTE_TYPE);
            if (fileTypeName == null) continue;
            RemovedMapping removedMapping = new RemovedMapping((FileNameMatcher)matcher, fileTypeName, approved);
            result2.add(removedMapping);
        }
        ArrayList<RemovedMapping> arrayList = result2;
        if (arrayList == null) {
            RemovedMappingTracker.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    void save(@NotNull Element element2) {
        if (element2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(6);
        }
        ArrayList<RemovedMapping> removedMappings = new ArrayList<RemovedMapping>(this.myRemovedMappings.values());
        removedMappings.sort(Comparator.comparing(mapping2 -> mapping2.getFileNameMatcher().getPresentableString()).thenComparing(RemovedMapping::getFileTypeName));
        for (RemovedMapping mapping3 : removedMappings) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(mapping3.myFileTypeName, mapping3.myFileNameMatcher, true, mapping3.myApproved);
            if (content2 == null) continue;
            element2.addContent(content2);
        }
    }

    void saveRemovedMappingsForFileType(@NotNull Element map2, @NotNull String fileTypeName, @NotNull Collection<? extends FileNameMatcher> associations, boolean specifyTypeName) {
        if (map2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(7);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(8);
        }
        if (associations == null) {
            RemovedMappingTracker.$$$reportNull$$$0(9);
        }
        for (FileNameMatcher fileNameMatcher : associations) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(fileTypeName, fileNameMatcher, specifyTypeName, this.isApproved(fileNameMatcher));
            if (content2 == null) continue;
            map2.addContent(content2);
        }
    }

    boolean hasRemovedMapping(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(10);
        }
        return this.myRemovedMappings.containsKey(matcher);
    }

    private boolean isApproved(@NotNull FileNameMatcher matcher) {
        RemovedMapping mapping2;
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(11);
        }
        return (mapping2 = this.myRemovedMappings.get(matcher)) != null && mapping2.isApproved();
    }

    @NotNull
    List<RemovedMapping> getRemovedMappings() {
        return new ArrayList<RemovedMapping>(this.myRemovedMappings.values());
    }

    @NotNull
    List<FileNameMatcher> getMappingsForFileType(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(12);
        }
        List<FileNameMatcher> list2 = this.myRemovedMappings.values().stream().filter(mapping2 -> mapping2.myFileTypeName.equals(fileTypeName)).map(mapping2 -> mapping2.myFileNameMatcher).collect(Collectors.toList());
        if (list2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(13);
        }
        return list2;
    }

    void removeIf(@NotNull BiPredicate<? super FileNameMatcher, ? super String> predicate) {
        if (predicate == null) {
            RemovedMappingTracker.$$$reportNull$$$0(14);
        }
        this.myRemovedMappings.entrySet().removeIf((? super E next) -> predicate.test(((RemovedMapping)next.getValue()).myFileNameMatcher, ((RemovedMapping)next.getValue()).myFileTypeName));
    }

    @NotNull
    List<RemovedMapping> deleteUnapprovedMappings() {
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        Iterator<Map.Entry<FileNameMatcher, RemovedMapping>> it = this.myRemovedMappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<FileNameMatcher, RemovedMapping> next = it.next();
            if (next.getValue().isApproved()) continue;
            result2.add(next.getValue());
            it.remove();
        }
        ArrayList<RemovedMapping> arrayList = result2;
        if (arrayList == null) {
            RemovedMappingTracker.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static Element writeRemovedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher, boolean specifyTypeName, boolean approved) {
        Element mapping2;
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(16);
        }
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(17);
        }
        if (!AbstractFileType.writePattern(matcher, mapping2 = new Element(ELEMENT_REMOVED_MAPPING))) {
            return null;
        }
        if (approved) {
            mapping2.setAttribute(ATTRIBUTE_APPROVED, "true");
        }
        if (specifyTypeName) {
            mapping2.setAttribute(ATTRIBUTE_TYPE, fileTypeName);
        }
        return mapping2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associations";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readRemovedMappings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsForFileType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteUnapprovedMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readRemovedMappings";
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveRemovedMappingsForFileType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasRemovedMapping";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isApproved";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsForFileType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeIf";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeRemovedMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RemovedMapping {
        private final FileNameMatcher myFileNameMatcher;
        private final String myFileTypeName;
        private final boolean myApproved;

        private RemovedMapping(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName, boolean approved) {
            if (matcher == null) {
                RemovedMapping.$$$reportNull$$$0(0);
            }
            if (fileTypeName == null) {
                RemovedMapping.$$$reportNull$$$0(1);
            }
            this.myFileNameMatcher = matcher;
            this.myFileTypeName = fileTypeName;
            this.myApproved = approved;
        }

        @NotNull
        FileNameMatcher getFileNameMatcher() {
            FileNameMatcher fileNameMatcher = this.myFileNameMatcher;
            if (fileNameMatcher == null) {
                RemovedMapping.$$$reportNull$$$0(2);
            }
            return fileNameMatcher;
        }

        @NotNull
        String getFileTypeName() {
            String string = this.myFileTypeName;
            if (string == null) {
                RemovedMapping.$$$reportNull$$$0(3);
            }
            return string;
        }

        boolean isApproved() {
            return this.myApproved;
        }

        public String toString() {
            return "Removed mapping '" + this.myFileNameMatcher + "' -> " + this.myFileTypeName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypeName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker$RemovedMapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker$RemovedMapping";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileNameMatcher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileTypeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

