/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.componentsList.layout;

import com.intellij.openapi.roots.ui.componentsList.layout.Orientation;
import com.intellij.openapi.roots.ui.componentsList.layout.OrientedDimensionSum;
import com.intellij.openapi.roots.ui.componentsList.layout.SizeProperty;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;

public abstract class ComponentOperation {
    public abstract void applyTo(Component var1);

    public static class InlineLayout
    extends ComponentOperation {
        private final Point myPosition;
        private final int myParentExtent;
        private final int myDefaultExtent;
        private final SizeProperty mySizeProperty;
        private final Orientation myOrientation;

        public InlineLayout(Container parent, int defaultExtent, SizeProperty sizeProperty, Orientation orientation) {
            Insets insets = parent.getInsets();
            this.myOrientation = orientation;
            this.mySizeProperty = sizeProperty;
            this.myDefaultExtent = defaultExtent;
            this.myParentExtent = this.myOrientation.getContrary().getInnerExtent(parent);
            this.myPosition = new Point(insets.left, insets.top);
        }

        @Override
        public void applyTo(Component component2) {
            component2.setSize(this.myParentExtent, this.myDefaultExtent);
            Dimension preferredSize = this.mySizeProperty.getSize(component2);
            int height = this.getHeight(preferredSize);
            int width = this.getWidth(preferredSize);
            component2.setBounds(this.myPosition.x, this.myPosition.y, width, height);
            this.myOrientation.advance(this.myPosition, width, height);
        }

        private int getHeight(Dimension preferredSize) {
            if (this.myOrientation.isVertical()) {
                return preferredSize != null ? preferredSize.height : this.myDefaultExtent;
            }
            return this.myParentExtent;
        }

        private int getWidth(Dimension preferredSize) {
            if (!this.myOrientation.isVertical()) {
                return preferredSize != null ? preferredSize.width : this.myDefaultExtent;
            }
            return this.myParentExtent;
        }
    }

    public static class SizeCalculator
    extends ComponentOperation {
        private final int myDefaultExtent;
        private final SizeProperty mySizeProperty;
        private final OrientedDimensionSum myDimensionSum;

        public SizeCalculator(int defaultExtent, SizeProperty sizeProperty, Orientation orientation) {
            this.myDefaultExtent = defaultExtent;
            this.mySizeProperty = sizeProperty;
            this.myDimensionSum = new OrientedDimensionSum(orientation);
        }

        protected SizeCalculator(SizeProperty sizeProperty) {
            this(0, sizeProperty, Orientation.VERTICAL);
        }

        @Override
        public void applyTo(Component component2) {
            Dimension size = this.mySizeProperty.getSize(component2);
            if (size != null) {
                this.myDimensionSum.add(size);
            } else {
                this.myDimensionSum.grow(this.myDefaultExtent);
            }
        }

        public OrientedDimensionSum getSum() {
            return this.myDimensionSum;
        }
    }
}

