/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.BlockI;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.LineTracker;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 I2\u00020\u0001:\bHIJKLMNOB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0018H\u0007J\b\u0010\"\u001a\u00020 H\u0017J\u001a\u0010#\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%H\u0087\b\u00f8\u0001\u0000J\"\u0010#\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020 0%H\u0087\b\u00f8\u0001\u0000J\u000e\u0010(\u001a\u00020 2\u0006\u0010&\u001a\u00020'J\u000e\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020'J$\u0010+\u001a\u00020,2\u0006\u0010&\u001a\u00020'2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0.H\u0007J\u0006\u0010/\u001a\u00020\u001aJ$\u00100\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0.H\u0007JM\u00100\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001a0.2'\u00101\u001a#\u0012\u0004\u0012\u00020\n\u0012\u0013\u0012\u001103\u00a2\u0006\f\b4\u0012\b\b5\u0012\u0004\b\b(6\u0012\u0004\u0012\u00020 02H\u0007J\u001f\u00107\u001a\u0002H8\"\u0004\b\u0000\u001082\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H80%\u00a2\u0006\u0002\u00109J\u001a\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020\u001a2\b\b\u0002\u0010<\u001a\u00020\u001aH\u0007J\u0018\u0010=\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010>\u001a\u00020\u0003H\u0007J$\u0010?\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020*2\u0006\u0010A\u001a\u00020*2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\tJ\u0016\u0010?\u001a\u00020\u001a2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\tH\u0007J\u0010\u0010D\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0007J\u0018\u0010D\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010E\u001a\u00020*H\u0002J\b\u0010F\u001a\u00020 H\u0007J\u0010\u0010F\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0002J\u001f\u0010G\u001a\u0002H8\"\u0004\b\u0000\u001082\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H80%\u00a2\u0006\u0002\u00109R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006P"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "Lcom/intellij/openapi/Disposable;", "document1", "Lcom/intellij/openapi/editor/Document;", "document2", "LOCK", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;)V", "blocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getBlocks", "()Ljava/util/List;", "<set-?>", "getDocument1", "()Lcom/intellij/openapi/editor/Document;", "getDocument2", "documentListener1", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$MyDocumentListener;", "documentListener2", "freezeHelper", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeHelper;", "handlers", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "isDisposed", "", "isLockHeldByCurrentThread", "()Z", "tracker", "Lcom/intellij/openapi/vcs/ex/LineTracker;", "addHandler", "", "newHandler", "dispose", "doFrozen", "task", "Lkotlin/Function0;", "side", "Lcom/intellij/diff/util/Side;", "freeze", "getContent", "", "getContentWithPartiallyAppliedBlocks", "", "condition", "Lkotlin/Function1;", "isFrozen", "partiallyApplyBlocks", "consumer", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "shift", "readLock", "T", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "refreshDirty", "fastRefresh", "forceInFrozen", "replaceDocument", "newDocument", "setFrozenState", "content1", "content2", "lineRanges", "Lcom/intellij/diff/util/Range;", "unfreeze", "oldText", "updateFrozenContentIfNeeded", "writeLock", "Block", "Companion", "FreezeData", "FreezeHelper", "Handler", "Lock", "MyApplicationListener", "MyDocumentListener", "intellij.platform.diff.impl"})
public final class DocumentTracker
implements Disposable {
    private final List<Handler> handlers;
    @NotNull
    private Document document1;
    @NotNull
    private Document document2;
    private final LineTracker tracker;
    private final FreezeHelper freezeHelper;
    private boolean isDisposed;
    private final MyDocumentListener documentListener1;
    private final MyDocumentListener documentListener2;
    private final Lock LOCK;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public final Document getDocument1() {
        return this.document1;
    }

    @NotNull
    public final Document getDocument2() {
        return this.document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            this.tracker.destroy();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @RequiresEdt
    public final void addHandler(@NotNull Handler newHandler) {
        Intrinsics.checkNotNullParameter((Object)newHandler, (String)"newHandler");
        this.handlers.add(newHandler);
    }

    @NotNull
    public final List<Block> getBlocks() {
        return this.tracker.getBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T readLock(@NotNull Function0<? extends T> task2) {
        Object object;
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            object = task2.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T writeLock(@NotNull Function0<? extends T> task2) {
        Object object;
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            object = task2.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public final boolean isLockHeldByCurrentThread() {
        return this.LOCK.isHeldByCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFrozen() {
        Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            boolean bl4 = this.freezeHelper.isFrozen();
            return bl4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void freeze(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            this.freezeHelper.freeze(side);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void unfreeze(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            this.freezeHelper.unfreeze(side);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void doFrozen(@NotNull Function0<Unit> task2) {
        void this_$iv;
        int $i$f$doFrozen = 0;
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        DocumentTracker documentTracker = this;
        Side side$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv.freeze(side$iv);
        try {
            void this_$iv2;
            boolean bl = false;
            DocumentTracker documentTracker2 = this;
            Side side$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv2.freeze(side$iv2);
            try {
                boolean bl2 = false;
                task2.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this_$iv2.unfreeze(side$iv2);
                InlineMarker.finallyEnd((int)1);
            }
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this_$iv.unfreeze(side$iv);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void doFrozen(@NotNull Side side, @NotNull Function0<Unit> task2) {
        int $i$f$doFrozen = 0;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        this.freeze(side);
        try {
            task2.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.unfreeze(side);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CharSequence getContent(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            CharSequence frozenContent = this.freezeHelper.getFrozenContent(side);
            if (frozenContent != null) {
                CharSequence charSequence = frozenContent;
                return charSequence;
            }
            CharSequence charSequence = RangesBuilder.get(side, this.document1, this.document2).getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"side[document1, document2].immutableCharSequence");
            CharSequence charSequence2 = charSequence;
            return charSequence2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void replaceDocument(@NotNull Side side, @NotNull Document newDocument) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)newDocument, (String)"newDocument");
        boolean bl = !this.LOCK.isHeldByCurrentThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DocumentTracker this_$iv = this;
        boolean $i$f$doFrozen = false;
        DocumentTracker documentTracker = this_$iv;
        Side side$iv$iv = Side.LEFT;
        boolean $i$f$doFrozen2 = false;
        this_$iv$iv.freeze(side$iv$iv);
        try {
            void this_$iv$iv2;
            boolean bl5 = false;
            DocumentTracker documentTracker2 = this_$iv;
            Side side$iv$iv2 = Side.RIGHT;
            boolean $i$f$doFrozen3 = false;
            this_$iv$iv2.freeze(side$iv$iv2);
            try {
                boolean bl6 = false;
                boolean bl7 = false;
                if (side.isLeft()) {
                    this.documentListener1.switchDocument(newDocument);
                    this.document1 = newDocument;
                } else {
                    this.documentListener2.switchDocument(newDocument);
                    this.document2 = newDocument;
                }
            }
            finally {
                this_$iv$iv2.unfreeze(side$iv$iv2);
            }
        }
        finally {
            this_$iv$iv.unfreeze(side$iv$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void refreshDirty(boolean fastRefresh, boolean forceInFrozen) {
        if (this.isDisposed) {
            return;
        }
        if (!forceInFrozen && this.freezeHelper.isFrozen()) {
            return;
        }
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            if (this.tracker.isDirty()) {
                Collection collection = this.getBlocks();
                boolean bl4 = false;
                if (!collection.isEmpty() && StringUtil.equals((CharSequence)this.document1.getImmutableCharSequence(), (CharSequence)this.document2.getImmutableCharSequence())) {
                    this.tracker.setRanges(CollectionsKt.emptyList(), false);
                    return;
                }
            }
            CharSequence charSequence = this.document1.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document1.immutableCharSequence");
            CharSequence charSequence2 = this.document2.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"document2.immutableCharSequence");
            this.tracker.refreshDirty(charSequence, charSequence2, RangesBuilder.getLineOffsets(this.document1), RangesBuilder.getLineOffsets(this.document2), fastRefresh);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void refreshDirty$default(DocumentTracker documentTracker, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        documentTracker.refreshDirty(bl, bl2);
    }

    private final void unfreeze(Side side, CharSequence oldText) {
        boolean bl = this.LOCK.isHeldByCurrentThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.isDisposed) {
            return;
        }
        Document newText = RangesBuilder.get(side, this.document1, this.document2);
        CharSequence charSequence = newText.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newText.immutableCharSequence");
        FairDiffIterable iterable = RangesBuilder.compareLines(oldText, charSequence, RangesBuilder.getLineOffsets(oldText), RangesBuilder.getLineOffsets(newText));
        if (iterable.changes().hasNext()) {
            this.tracker.rangesChanged(side, iterable);
        }
    }

    @RequiresEdt
    public final void updateFrozenContentIfNeeded() {
        this.updateFrozenContentIfNeeded(Side.LEFT);
        this.updateFrozenContentIfNeeded(Side.RIGHT);
        this.refreshDirty(false, true);
    }

    private final void updateFrozenContentIfNeeded(Side side) {
        boolean bl = this.LOCK.isHeldByCurrentThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!this.freezeHelper.isFrozen(side)) {
            return;
        }
        CharSequence charSequence = this.freezeHelper.getFrozenContent(side);
        Intrinsics.checkNotNull((Object)charSequence);
        this.unfreeze(side, charSequence);
        CharSequence charSequence2 = RangesBuilder.get(side, this.document1, this.document2).getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"side[document1, document2].immutableCharSequence");
        this.freezeHelper.setFrozenContent(side, charSequence2);
    }

    @RequiresEdt
    public final void partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super Block, Boolean> condition) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        this.partiallyApplyBlocks(side, condition, (Function2<? super Block, ? super Integer, Unit>)((Function2)partiallyApplyBlocks.1.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super Block, Boolean> condition, @NotNull Function2<? super Block, ? super Integer, Unit> consumer2) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        if (this.isDisposed) {
            return;
        }
        Side side2 = side.other();
        Intrinsics.checkNotNullExpressionValue((Object)side2, (String)"side.other()");
        Side otherSide = side2;
        Document document = RangesBuilder.get(side, this.document1, this.document2);
        Document otherDocument = RangesBuilder.get(otherSide, this.document1, this.document2);
        DocumentTracker this_$iv = this;
        boolean $i$f$doFrozen = false;
        this_$iv.freeze(side);
        try {
            List<Block> list2;
            boolean bl = false;
            Lock this_$iv2 = this.LOCK;
            boolean $i$f$write = false;
            java.util.concurrent.locks.Lock lock = this_$iv2.getMyLock();
            boolean bl2 = false;
            boolean bl3 = false;
            lock.lock();
            try {
                boolean bl4 = false;
                this.updateFrozenContentIfNeeded();
                list2 = this.tracker.partiallyApplyBlocks(side, condition);
            }
            finally {
                lock.unlock();
            }
            List<Block> appliedBlocks = list2;
            int shift = 0;
            for (Block block : appliedBlocks) {
                DiffUtil.applyModification(document, RangesBuilder.start(block.getRange(), side) + shift, RangesBuilder.end(block.getRange(), side) + shift, otherDocument, RangesBuilder.start(block.getRange(), otherSide), RangesBuilder.end(block.getRange(), otherSide));
                consumer2.invoke((Object)block, (Object)shift);
                shift += DocumentTrackerKt.access$getRangeDelta(block.getRange(), side);
            }
            Lock this_$iv3 = this.LOCK;
            boolean $i$f$write2 = false;
            java.util.concurrent.locks.Lock lock2 = this_$iv3.getMyLock();
            boolean bl5 = false;
            boolean bl6 = false;
            lock2.lock();
            try {
                boolean bl7 = false;
                CharSequence charSequence = document.getImmutableCharSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.immutableCharSequence");
                this.freezeHelper.setFrozenContent(side, charSequence);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }
        finally {
            this_$iv.unfreeze(side);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public final String getContentWithPartiallyAppliedBlocks(@NotNull Side side, @NotNull Function1<? super Block, Boolean> condition) {
        void $this$mapTo$iv$iv;
        List list2;
        Object predicate$iv;
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Side side2 = side.other();
        Intrinsics.checkNotNullExpressionValue((Object)side2, (String)"side.other()");
        Side otherSide = side2;
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            boolean bl3 = false;
            this.updateFrozenContentIfNeeded();
            Iterable iterable = this.tracker.getBlocks();
            predicate$iv = condition;
            boolean $i$f$filter = false;
            void var14_20 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        finally {
            lock.unlock();
        }
        List affectedBlocks = list2;
        CharSequence content2 = this.getContent(side);
        CharSequence otherContent = this.getContent(otherSide);
        LineOffsets lineOffsets = RangesBuilder.getLineOffsets(content2);
        LineOffsets otherLineOffsets = RangesBuilder.getLineOffsets(otherContent);
        Iterable $this$map$iv = affectedBlocks;
        boolean $i$f$map = false;
        predicate$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Block block = (Block)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            Range range2 = new Range(RangesBuilder.start(it.getRange(), side), RangesBuilder.end(it.getRange(), side), RangesBuilder.start(it.getRange(), otherSide), RangesBuilder.end(it.getRange(), otherSide));
            collection.add(range2);
        }
        List ranges = (List)destination$iv$iv;
        String string = DiffUtil.applyModification(content2, lineOffsets, otherContent, otherLineOffsets, ranges);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiffUtil.applyModificati\u2026otherLineOffsets, ranges)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setFrozenState(@NotNull CharSequence content1, @NotNull CharSequence content2, @NotNull List<? extends Range> lineRanges) {
        Intrinsics.checkNotNullParameter((Object)content1, (String)"content1");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content2");
        Intrinsics.checkNotNullParameter(lineRanges, (String)"lineRanges");
        boolean bl = this.freezeHelper.isFrozen(Side.LEFT) && this.freezeHelper.isFrozen(Side.RIGHT);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.isDisposed) {
            return false;
        }
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl5 = false;
        boolean bl6 = false;
        lock.lock();
        try {
            boolean bl7 = false;
            if (!ComparisonUtil.isValidRanges(content1, content2, RangesBuilder.getLineOffsets(content1), RangesBuilder.getLineOffsets(content2), lineRanges)) {
                boolean bl8 = false;
                return bl8;
            }
            this.freezeHelper.setFrozenContent(Side.LEFT, content1);
            this.freezeHelper.setFrozenContent(Side.RIGHT, content2);
            this.tracker.setRanges(lineRanges, true);
            boolean bl9 = true;
            return bl9;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final boolean setFrozenState(@NotNull List<? extends Range> lineRanges) {
        Intrinsics.checkNotNullParameter(lineRanges, (String)"lineRanges");
        if (this.isDisposed) {
            return false;
        }
        boolean bl = this.freezeHelper.isFrozen(Side.LEFT) && this.freezeHelper.isFrozen(Side.RIGHT);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Lock this_$iv = this.LOCK;
        boolean $i$f$write = false;
        java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
        boolean bl5 = false;
        boolean bl6 = false;
        lock.lock();
        try {
            boolean bl7 = false;
            CharSequence content1 = this.getContent(Side.LEFT);
            CharSequence content2 = this.getContent(Side.RIGHT);
            if (!ComparisonUtil.isValidRanges(content1, content2, RangesBuilder.getLineOffsets(content1), RangesBuilder.getLineOffsets(content2), lineRanges)) {
                boolean bl8 = false;
                return bl8;
            }
            this.tracker.setRanges(lineRanges, true);
            boolean bl9 = true;
            return bl9;
        }
        finally {
            lock.unlock();
        }
    }

    public DocumentTracker(@NotNull Document document1, @NotNull Document document2, @NotNull Lock LOCK) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)document1, (String)"document1");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document2");
        Intrinsics.checkNotNullParameter((Object)LOCK, (String)"LOCK");
        this.LOCK = LOCK;
        boolean bl = false;
        this.handlers = new ArrayList();
        this.document1 = document1;
        this.document2 = document2;
        this.freezeHelper = new FreezeHelper();
        this.documentListener1 = new MyDocumentListener(Side.LEFT, document1);
        this.documentListener2 = new MyDocumentListener(Side.RIGHT, document2);
        bl = Intrinsics.areEqual((Object)document1, (Object)document2) ^ true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (document1.getImmutableCharSequence() == document2.getImmutableCharSequence()) {
            list2 = CollectionsKt.emptyList();
        } else {
            CharSequence charSequence = document1.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document1.immutableCharSequence");
            CharSequence charSequence2 = document2.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"document2.immutableCharSequence");
            Iterable<Range> iterable = RangesBuilder.compareLines(charSequence, charSequence2, RangesBuilder.getLineOffsets(document1), RangesBuilder.getLineOffsets(document2)).iterateChanges();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"compareLines(document1.i\u2026Offsets).iterateChanges()");
            list2 = CollectionsKt.toList(iterable);
        }
        List changes = list2;
        this.tracker = new LineTracker(this.handlers, changes);
        Application application = ApplicationManager.getApplication();
        application.addApplicationListener((ApplicationListener)new MyApplicationListener(), (Disposable)this);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DocumentTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(DocumentTracker::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$setDisposed$p(DocumentTracker $this, boolean bl) {
        $this.isDisposed = bl;
    }

    public static final /* synthetic */ Document access$getDocument1$p(DocumentTracker $this) {
        return $this.document1;
    }

    public static final /* synthetic */ void access$setDocument1$p(DocumentTracker $this, Document document) {
        $this.document1 = document;
    }

    public static final /* synthetic */ Document access$getDocument2$p(DocumentTracker $this) {
        return $this.document2;
    }

    public static final /* synthetic */ void access$setDocument2$p(DocumentTracker $this, Document document) {
        $this.document2 = document;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;)V", "afterWriteActionFinished", "", "action", "", "intellij.platform.diff.impl"})
    private final class MyApplicationListener
    implements ApplicationListener {
        public void afterWriteActionFinished(@NotNull Object action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            DocumentTracker.refreshDirty$default(DocumentTracker.this, true, false, 2, null);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J:\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "side", "Lcom/intellij/diff/util/Side;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;Lcom/intellij/diff/util/Side;Lcom/intellij/openapi/editor/Document;)V", "line1", "", "line2", "getSide", "()Lcom/intellij/diff/util/Side;", "beforeDocumentChange", "", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "bulkUpdateFinished", "bulkUpdateStarting", "documentChanged", "getAffectedRange", "Lkotlin/Triple;", "oldLine2", "newLine2", "isNewlineAfter", "", "isNewlineBefore", "switchDocument", "newDocument", "intellij.platform.diff.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        private int line1;
        private int line2;
        @NotNull
        private final Side side;
        private Document document;

        public final void switchDocument(@NotNull Document newDocument) {
            Intrinsics.checkNotNullParameter((Object)newDocument, (String)"newDocument");
            this.document.removeDocumentListener((DocumentListener)this);
            if (this.document.isInBulkUpdate()) {
                DocumentTracker.this.unfreeze(this.side);
            }
            this.document = newDocument;
            newDocument.addDocumentListener((DocumentListener)this, (Disposable)DocumentTracker.this);
            if (newDocument.isInBulkUpdate()) {
                DocumentTracker.this.freeze(this.side);
            }
        }

        public void beforeDocumentChange(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (DocumentTracker.this.isDisposed || DocumentTracker.this.freezeHelper.isFrozen(this.side)) {
                return;
            }
            this.line1 = this.document.getLineNumber(e.getOffset());
            this.line2 = e.getOldLength() == 0 ? this.line1 + 1 : this.document.getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void documentChanged(@NotNull DocumentEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (DocumentTracker.this.isDisposed || DocumentTracker.this.freezeHelper.isFrozen(this.side)) {
                return;
            }
            int newLine2 = 0;
            newLine2 = e.getNewLength() == 0 ? this.line1 + 1 : this.document.getLineNumber(e.getOffset() + e.getNewLength()) + 1;
            Triple<Integer, Integer, Integer> triple = this.getAffectedRange(this.line1, this.line2, newLine2, e);
            int n = ((Number)triple.component1()).intValue();
            int n2 = ((Number)triple.component2()).intValue();
            int beforeLength = ((Number)triple.component3()).intValue();
            Lock this_$iv = DocumentTracker.this.LOCK;
            boolean $i$f$write = false;
            java.util.concurrent.locks.Lock lock = this_$iv.getMyLock();
            boolean bl = false;
            boolean bl2 = false;
            lock.lock();
            try {
                void afterLength;
                void startLine;
                boolean bl3 = false;
                DocumentTracker.this.tracker.rangeChanged(this.side, (int)startLine, beforeLength, (int)afterLength);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        public void bulkUpdateStarting(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            DocumentTracker.this.freeze(this.side);
        }

        public void bulkUpdateFinished(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            DocumentTracker.this.unfreeze(this.side);
        }

        private final Triple<Integer, Integer, Integer> getAffectedRange(int line1, int oldLine2, int newLine2, DocumentEvent e) {
            int afterLength = newLine2 - line1;
            int beforeLength = oldLine2 - line1;
            if (e.getOldLength() == 0 && e.getNewLength() != 0) {
                if (StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && this.isNewlineBefore(e)) {
                    return new Triple((Object)line1, (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
                if (StringUtil.startsWithChar((CharSequence)e.getNewFragment(), (char)'\n') && this.isNewlineAfter(e)) {
                    return new Triple((Object)(line1 + 1), (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
            }
            if (e.getOldLength() != 0 && e.getNewLength() == 0) {
                if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && this.isNewlineBefore(e)) {
                    return new Triple((Object)line1, (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
                if (StringUtil.startsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && this.isNewlineAfter(e)) {
                    return new Triple((Object)(line1 + 1), (Object)(afterLength - 1), (Object)(beforeLength - 1));
                }
            }
            return new Triple((Object)line1, (Object)afterLength, (Object)beforeLength);
        }

        private final boolean isNewlineBefore(DocumentEvent e) {
            if (e.getOffset() == 0) {
                return true;
            }
            Document document = e.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"e.document");
            return document.getImmutableCharSequence().charAt(e.getOffset() - 1) == '\n';
        }

        private final boolean isNewlineAfter(DocumentEvent e) {
            int n = e.getOffset() + e.getNewLength();
            Document document = e.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"e.document");
            if (n == document.getImmutableCharSequence().length()) {
                return true;
            }
            Document document2 = e.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"e.document");
            return document2.getImmutableCharSequence().charAt(e.getOffset() + e.getNewLength()) == '\n';
        }

        @NotNull
        public final Side getSide() {
            return this.side;
        }

        public MyDocumentListener(@NotNull Side side, Document document) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            this.side = side;
            this.document = document;
            this.document.addDocumentListener((DocumentListener)this, (Disposable)DocumentTracker.this);
            if (this.document.isInBulkUpdate()) {
                DocumentTracker.this.freeze(this.side);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002J\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeHelper;", "", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker;)V", "data1", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeData;", "data2", "freeze", "", "side", "Lcom/intellij/diff/util/Side;", "getData", "getFrozenContent", "", "isFrozen", "", "onFreeze", "onUnfreeze", "setData", "data", "setFrozenContent", "newContent", "unfreeze", "intellij.platform.diff.impl"})
    private final class FreezeHelper {
        private FreezeData data1;
        private FreezeData data2;

        public final boolean isFrozen(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return this.getData(side) != null;
        }

        public final boolean isFrozen() {
            return this.isFrozen(Side.LEFT) || this.isFrozen(Side.RIGHT);
        }

        public final void freeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            boolean wasFrozen = this.isFrozen();
            FreezeData data2 = this.getData(side);
            if (data2 == null) {
                data2 = new FreezeData(RangesBuilder.get(side, DocumentTracker.this.getDocument1(), DocumentTracker.this.getDocument2()));
                this.setData(side, data2);
                FreezeData freezeData = data2;
                int n = freezeData.getCounter();
                freezeData.setCounter(n + 1);
                if (wasFrozen) {
                    this.onFreeze();
                }
                this.onFreeze(side);
            } else {
                FreezeData freezeData = data2;
                int n = freezeData.getCounter();
                freezeData.setCounter(n + 1);
            }
        }

        public final void unfreeze(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            FreezeData data2 = this.getData(side);
            if (data2 == null || data2.getCounter() == 0) {
                FreezeData freezeData = this.data1;
                FreezeData freezeData2 = this.data2;
                LOG.error("DocumentTracker is not freezed: " + side + ", " + (freezeData != null ? freezeData.getCounter() : -1) + ", " + (freezeData2 != null ? freezeData2.getCounter() : -1));
                return;
            }
            FreezeData freezeData = data2;
            int n = freezeData.getCounter();
            freezeData.setCounter(n + -1);
            if (data2.getCounter() == 0) {
                DocumentTracker.this.unfreeze(side, data2.getTextBeforeFreeze());
                this.setData(side, null);
                DocumentTracker.refreshDirty$default(DocumentTracker.this, false, false, 2, null);
                this.onUnfreeze(side);
                if (!this.isFrozen()) {
                    this.onUnfreeze();
                }
            }
        }

        private final FreezeData getData(Side side) {
            return RangesBuilder.get(side, this.data1, this.data2);
        }

        private final void setData(Side side, FreezeData data2) {
            if (side.isLeft()) {
                this.data1 = data2;
            } else {
                this.data2 = data2;
            }
        }

        @Nullable
        public final CharSequence getFrozenContent(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            FreezeData freezeData = this.getData(side);
            return freezeData != null ? freezeData.getTextBeforeFreeze() : null;
        }

        public final void setFrozenContent(@NotNull Side side, @NotNull CharSequence newContent) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
            FreezeData freezeData = this.getData(side);
            Intrinsics.checkNotNull((Object)freezeData);
            this.setData(side, new FreezeData(freezeData, newContent));
        }

        private final void onFreeze(Side side) {
            Iterable $this$forEach$iv = DocumentTracker.this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Handler it = (Handler)element$iv;
                boolean bl = false;
                it.onFreeze(side);
            }
        }

        private final void onUnfreeze(Side side) {
            Iterable $this$forEach$iv = DocumentTracker.this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Handler it = (Handler)element$iv;
                boolean bl = false;
                it.onUnfreeze(side);
            }
        }

        private final void onFreeze() {
            Iterable $this$forEach$iv = DocumentTracker.this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Handler it = (Handler)element$iv;
                boolean bl = false;
                it.onFreeze();
            }
        }

        private final void onUnfreeze() {
            Iterable $this$forEach$iv = DocumentTracker.this.handlers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Handler it = (Handler)element$iv;
                boolean bl = false;
                it.onUnfreeze();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeData;", "", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/editor/Document;)V", "data", "textBeforeFreeze", "", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$FreezeData;Ljava/lang/CharSequence;)V", "counter", "", "(Ljava/lang/CharSequence;I)V", "getCounter", "()I", "setCounter", "(I)V", "getTextBeforeFreeze", "()Ljava/lang/CharSequence;", "intellij.platform.diff.impl"})
    private static final class FreezeData {
        @NotNull
        private final CharSequence textBeforeFreeze;
        private int counter;

        @NotNull
        public final CharSequence getTextBeforeFreeze() {
            return this.textBeforeFreeze;
        }

        public final int getCounter() {
            return this.counter;
        }

        public final void setCounter(int n) {
            this.counter = n;
        }

        public FreezeData(@NotNull CharSequence textBeforeFreeze, int counter) {
            Intrinsics.checkNotNullParameter((Object)textBeforeFreeze, (String)"textBeforeFreeze");
            this.textBeforeFreeze = textBeforeFreeze;
            this.counter = counter;
        }

        public FreezeData(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            CharSequence charSequence = document.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.immutableCharSequence");
            this(charSequence, 0);
        }

        public FreezeData(@NotNull FreezeData data2, @NotNull CharSequence textBeforeFreeze) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)textBeforeFreeze, (String)"textBeforeFreeze");
            this(textBeforeFreeze, data2.counter);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "", "()V", "isHeldByCurrentThread", "", "()Z", "myLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getMyLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "read", "T", "task", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "write", "intellij.platform.diff.impl"})
    @ApiStatus.Internal
    public static final class Lock {
        @NotNull
        private final ReentrantLock myLock = new ReentrantLock();

        @NotNull
        public final ReentrantLock getMyLock() {
            return this.myLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T read(@NotNull Function0<? extends T> task2) {
            Object object;
            int $i$f$read = 0;
            Intrinsics.checkNotNullParameter(task2, (String)"task");
            java.util.concurrent.locks.Lock lock = this.getMyLock();
            boolean bl = false;
            boolean bl2 = false;
            lock.lock();
            try {
                object = task2.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                lock.unlock();
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T write(@NotNull Function0<? extends T> task2) {
            Object object;
            int $i$f$write = 0;
            Intrinsics.checkNotNullParameter(task2, (String)"task");
            java.util.concurrent.locks.Lock lock = this.getMyLock();
            boolean bl = false;
            boolean bl2 = false;
            lock.lock();
            try {
                object = task2.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                lock.unlock();
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }

        public final boolean isHeldByCurrentThread() {
            return this.myLock.isHeldByCurrentThread();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u001e\u0010\u0013\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "", "afterBulkRangeChange", "", "isDirty", "", "mergeRanges", "block1", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "block2", "merged", "onFreeze", "side", "Lcom/intellij/diff/util/Side;", "onRangeRefreshed", "before", "after", "", "onRangeShifted", "onRangesChanged", "onUnfreeze", "intellij.platform.diff.impl"})
    public static interface Handler {
        public void onRangeRefreshed(@NotNull Block var1, @NotNull List<Block> var2);

        public void onRangesChanged(@NotNull List<Block> var1, @NotNull Block var2);

        public void onRangeShifted(@NotNull Block var1, @NotNull Block var2);

        public boolean mergeRanges(@NotNull Block var1, @NotNull Block var2, @NotNull Block var3);

        public void afterBulkRangeChange(boolean var1);

        public void onFreeze(@NotNull Side var1);

        public void onUnfreeze(@NotNull Side var1);

        public void onFreeze();

        public void onUnfreeze();

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void onRangeRefreshed(@NotNull Handler $this, @NotNull Block before, @NotNull List<Block> after2) {
                Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                Intrinsics.checkNotNullParameter(after2, (String)"after");
            }

            public static void onRangesChanged(@NotNull Handler $this, @NotNull List<Block> before, @NotNull Block after2) {
                Intrinsics.checkNotNullParameter(before, (String)"before");
                Intrinsics.checkNotNullParameter((Object)after2, (String)"after");
            }

            public static void onRangeShifted(@NotNull Handler $this, @NotNull Block before, @NotNull Block after2) {
                Intrinsics.checkNotNullParameter((Object)before, (String)"before");
                Intrinsics.checkNotNullParameter((Object)after2, (String)"after");
            }

            public static boolean mergeRanges(@NotNull Handler $this, @NotNull Block block1, @NotNull Block block2, @NotNull Block merged) {
                Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
                Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
                Intrinsics.checkNotNullParameter((Object)merged, (String)"merged");
                return true;
            }

            public static void afterBulkRangeChange(@NotNull Handler $this, boolean isDirty) {
            }

            public static void onFreeze(@NotNull Handler $this, @NotNull Side side) {
                Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            }

            public static void onUnfreeze(@NotNull Handler $this, @NotNull Side side) {
                Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            }

            public static void onFreeze(@NotNull Handler $this) {
            }

            public static void onUnfreeze(@NotNull Handler $this) {
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011R\u0014\u0010\u0019\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u0014\u0010\u001b\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "Lcom/intellij/openapi/vcs/ex/BlockI;", "range", "Lcom/intellij/diff/util/Range;", "isDirty", "", "isTooBig", "(Lcom/intellij/diff/util/Range;ZZ)V", "data", "", "getData", "()Ljava/lang/Object;", "setData", "(Ljava/lang/Object;)V", "end", "", "getEnd", "()I", "isDirty$intellij_platform_diff_impl", "()Z", "isTooBig$intellij_platform_diff_impl", "getRange", "()Lcom/intellij/diff/util/Range;", "start", "getStart", "vcsEnd", "getVcsEnd", "vcsStart", "getVcsStart", "intellij.platform.diff.impl"})
    public static final class Block
    implements BlockI {
        @Nullable
        private Object data;
        @NotNull
        private final Range range;
        private final boolean isDirty;
        private final boolean isTooBig;

        @Nullable
        public final Object getData() {
            return this.data;
        }

        public final void setData(@Nullable Object object) {
            this.data = object;
        }

        @Override
        public int getStart() {
            return this.range.start2;
        }

        @Override
        public int getEnd() {
            return this.range.end2;
        }

        @Override
        public int getVcsStart() {
            return this.range.start1;
        }

        @Override
        public int getVcsEnd() {
            return this.range.end1;
        }

        @NotNull
        public final Range getRange() {
            return this.range;
        }

        public final boolean isDirty$intellij_platform_diff_impl() {
            return this.isDirty;
        }

        public final boolean isTooBig$intellij_platform_diff_impl() {
            return this.isTooBig;
        }

        public Block(@NotNull Range range2, boolean isDirty, boolean isTooBig) {
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            this.range = range2;
            this.isDirty = isDirty;
            this.isTooBig = isTooBig;
        }

        @Override
        public boolean isEmpty() {
            return BlockI.DefaultImpls.isEmpty(this);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/ex/DocumentTracker$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

