/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class ReadOnlyStatusDialog
extends OptionsDialog {
    private static final SimpleTextAttributes BOLD_ATTRIBUTES = new SimpleTextAttributes(1, JBColor.foreground());
    private static final SimpleTextAttributes SELECTED_BOLD_ATTRIBUTES = new SimpleTextAttributes(1, (Color)new JBColor(() -> UIUtil.getListSelectionForeground((boolean)true)));
    private JPanel myTopPanel;
    private JList<VirtualFile> myFileList;
    private JRadioButton myUsingFileSystemRadioButton;
    private JRadioButton myUsingVcsRadioButton;
    private JComboBox<String> myChangelist;
    private List<? extends FileInfo> myFiles;

    public ReadOnlyStatusDialog(Project project, @NotNull List<? extends FileInfo> files2) {
        if (files2 == null) {
            ReadOnlyStatusDialog.$$$reportNull$$$0(0);
        }
        super(project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(IdeBundle.message((String)"dialog.title.clear.read.only.file.status", (Object[])objectArray));
        this.myFiles = files2;
        this.myFileList.setPreferredSize(ReadOnlyStatusDialog.getDialogPreferredSize());
        this.initFileList();
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReadOnlyStatusDialog.this.myChangelist.setEnabled(ReadOnlyStatusDialog.this.myUsingVcsRadioButton.isSelected());
            }
        };
        this.myUsingVcsRadioButton.addActionListener(listener2);
        this.myUsingFileSystemRadioButton.addActionListener(listener2);
        (this.myUsingVcsRadioButton.isEnabled() ? this.myUsingVcsRadioButton : this.myUsingFileSystemRadioButton).setSelected(true);
        this.myChangelist.setEnabled(this.myUsingVcsRadioButton.isSelected());
        this.myFileList.setCellRenderer((ListCellRenderer<VirtualFile>)((Object)new FileListRenderer()));
        this.init();
    }

    private void initFileList() {
        this.myFileList.setModel((ListModel<VirtualFile>)new AbstractListModel<VirtualFile>(){

            @Override
            public int getSize() {
                return ReadOnlyStatusDialog.this.myFiles.size();
            }

            @Override
            public VirtualFile getElementAt(int index) {
                return ReadOnlyStatusDialog.this.myFiles.get(index).getFile();
            }
        });
        boolean hasVcs = false;
        for (FileInfo fileInfo : this.myFiles) {
            if (!fileInfo.hasVersionControl()) continue;
            hasVcs = true;
            HandleType handleType = fileInfo.getSelectedHandleType();
            List<String> changelists = handleType.getChangelists();
            final String defaultChangelist = handleType.getDefaultChangelist();
            this.myChangelist.setModel((ComboBoxModel<String>)new CollectionComboBoxModel(changelists, (Object)defaultChangelist));
            this.myChangelist.setRenderer((ListCellRenderer<String>)new ColoredListCellRenderer<String>(){

                protected void customizeCellRenderer(@NotNull JList<? extends String> list2, @NlsSafe String value2, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (value2 == null) {
                        return;
                    }
                    String trimmed = StringUtil.first((String)value2, (int)50, (boolean)true);
                    if (value2.equals(defaultChangelist)) {
                        this.append(trimmed, selected2 ? SELECTED_BOLD_ATTRIBUTES : BOLD_ATTRIBUTES);
                    } else {
                        this.append(trimmed, selected2 ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/readOnlyHandler/ReadOnlyStatusDialog$3", "customizeCellRenderer"));
                }
            });
            break;
        }
        this.myUsingVcsRadioButton.setEnabled(hasVcs);
    }

    protected boolean isToBeShown() {
        ReadonlyStatusHandlerImpl.State state = ((ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject)).getState();
        return state.SHOW_DIALOG;
    }

    protected void setToBeShown(boolean value2, boolean onOk) {
        if (onOk) {
            ReadonlyStatusHandlerImpl.State state = ((ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject)).getState();
            state.SHOW_DIALOG = value2;
        }
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return false;
    }

    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    protected String getDimensionServiceKey() {
        return "vcs.readOnlyHandler.ReadOnlyStatusDialog";
    }

    protected void doOKAction() {
        for (FileInfo fileInfo : this.myFiles) {
            if (this.myUsingFileSystemRadioButton.isSelected()) {
                fileInfo.getHandleType().selectFirst();
                continue;
            }
            if (!fileInfo.hasVersionControl()) continue;
            fileInfo.getHandleType().select((Object)((HandleType)fileInfo.getHandleType().get(1)));
        }
        ArrayList<FileInfo> files2 = new ArrayList<FileInfo>(this.myFiles);
        String string = (String)this.myChangelist.getSelectedItem();
        ReadonlyStatusHandlerImpl.processFiles(files2, string);
        if (files2.isEmpty()) {
            super.doOKAction();
        } else {
            String list2 = StringUtil.join(files2, info -> info.getFile().getPresentableUrl(), (String)"<br>");
            String message = IdeBundle.message((String)"handle.ro.file.status.failed", (Object[])new Object[]{list2});
            Messages.showErrorDialog((Component)this.getRootPane(), (String)message, (String)IdeBundle.message((String)"dialog.title.clear.read.only.file.status", (Object[])new Object[0]));
            this.myFiles = files2;
            this.initFileList();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        JRootPane pane2 = this.getRootPane();
        return pane2 != null ? pane2.getDefaultButton() : null;
    }

    public static Dimension getDialogPreferredSize() {
        return new Dimension(500, 400);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/readOnlyHandler/ReadOnlyStatusDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JBList jBList;
        JPanel jPanel2;
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myFileList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUsingFileSystemRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/IdeBundle", ReadOnlyStatusDialog.class).getString("radio.button.using.file.system"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(175, 22), null));
        this.myUsingVcsRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/IdeBundle", ReadOnlyStatusDialog.class).getString("radio.button.using.version.control.integration"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(175, 22), null));
        JComboBox jComboBox = new JComboBox();
        this.myChangelist = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(11);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/IdeBundle", ReadOnlyStatusDialog.class).getString("label.change.list.for.unlocked.files"));
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, new Dimension(34, 14), null));
        jBLabel.setLabelFor(jComboBox);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

