/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.IconManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ui.EmptyIcon;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseFileEncodingAction
extends ComboBoxAction {
    private final VirtualFile myVirtualFile;
    public static final Charset NO_ENCODING = new Charset("NO_ENCODING", null){

        @Override
        public boolean contains(Charset cs) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return null;
        }

        @Override
        public CharsetEncoder newEncoder() {
            return null;
        }
    };

    protected ChooseFileEncodingAction(@Nullable VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public abstract void update(@NotNull AnActionEvent var1);

    private void fillCharsetActions(@NotNull DefaultActionGroup group2, final @Nullable VirtualFile virtualFile, @NotNull List<? extends Charset> charsets, final @NotNull Function<? super Charset, @NlsActions.ActionDescription String> descriptionSupplier) {
        if (group2 == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(0);
        }
        if (charsets == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(1);
        }
        if (descriptionSupplier == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(2);
        }
        for (final Charset charset : charsets) {
            CharsetAction action2 = new CharsetAction(charset.displayName(), null, EmptyIcon.ICON_16){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ChooseFileEncodingAction.this.chosen(virtualFile, charset);
                }

                public void update(@NotNull AnActionEvent e) {
                    Icon defer;
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.update(e);
                    String description = (String)descriptionSupplier.fun((Object)charset);
                    if (virtualFile == null || virtualFile.isDirectory()) {
                        defer = null;
                    } else {
                        VolatileNotNullLazyValue myText = VolatileNotNullLazyValue.createValue(() -> LoadTextUtil.loadText(virtualFile));
                        VolatileNotNullLazyValue myBytes = VolatileNotNullLazyValue.createValue(() -> {
                            try {
                                return virtualFile.contentsToByteArray();
                            }
                            catch (IOException e1) {
                                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
                            }
                        });
                        defer = IconManager.getInstance().createDeferredIcon(null, (Object)new Pair((Object)virtualFile, (Object)charset), arg_0 -> 1.lambda$update$2((NotNullLazyValue)myText, (NotNullLazyValue)myBytes, arg_0));
                    }
                    e.getPresentation().setIcon(defer);
                    e.getPresentation().setDescription(description);
                }

                private static /* synthetic */ Icon lambda$update$2(NotNullLazyValue myText, NotNullLazyValue myBytes, Pair pair) {
                    byte[] bytes;
                    VirtualFile myFile = (VirtualFile)pair.getFirst();
                    Charset charset2 = (Charset)pair.getSecond();
                    CharSequence text2 = (CharSequence)myText.getValue();
                    EncodingUtil.Magic8 safeToReload = EncodingUtil.isSafeToReloadIn(myFile, text2, bytes = (byte[])myBytes.getValue(), charset2);
                    EncodingUtil.Magic8 safeToConvert = safeToReload == EncodingUtil.Magic8.ABSOLUTELY ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.isSafeToConvertTo(myFile, text2, bytes, charset2);
                    return safeToReload == EncodingUtil.Magic8.ABSOLUTELY || safeToConvert == EncodingUtil.Magic8.ABSOLUTELY ? null : (safeToReload == EncodingUtil.Magic8.WELL_IF_YOU_INSIST || safeToConvert == EncodingUtil.Magic8.WELL_IF_YOU_INSIST ? AllIcons.General.Warning : AllIcons.General.Error);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            group2.add((AnAction)action2);
        }
    }

    protected abstract void chosen(@Nullable VirtualFile var1, @NotNull Charset var2);

    @NotNull
    protected DefaultActionGroup createCharsetsActionGroup(@Nullable @NlsActions.ActionText String clearItemText, @Nullable Charset alreadySelected, @NotNull Function<? super Charset, @NlsActions.ActionDescription String> descriptionSupplier) {
        if (descriptionSupplier == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        ArrayList favorites = new ArrayList(EncodingManager.getInstance().getFavorites());
        Collections.sort(favorites);
        Charset current2 = this.myVirtualFile == null ? null : this.myVirtualFile.getCharset();
        favorites.remove(current2);
        favorites.remove(alreadySelected);
        if (clearItemText != null) {
            String description = this.myVirtualFile == null ? IdeBundle.message((String)"action.clear.encoding.description", (Object[])new Object[0]) : IdeBundle.message((String)"action.clear.encoding.description.file", (Object[])new Object[]{this.myVirtualFile.getName()});
            group2.add((AnAction)new DumbAwareAction(clearItemText, description, null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ChooseFileEncodingAction.this.chosen(ChooseFileEncodingAction.this.myVirtualFile, NO_ENCODING);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction$3", "actionPerformed"));
                }
            });
        }
        if (favorites.isEmpty() && clearItemText == null) {
            this.fillCharsetActions(group2, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), descriptionSupplier);
        } else {
            this.fillCharsetActions(group2, this.myVirtualFile, favorites, descriptionSupplier);
            DefaultActionGroup more = DefaultActionGroup.createPopupGroup(() -> IdeBundle.message((String)"action.text.more", (Object[])new Object[0]));
            group2.add((AnAction)more);
            this.fillCharsetActions(more, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), descriptionSupplier);
        }
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsets";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionSupplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCharsetsActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCharsetActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCharsetsActionGroup";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class CharsetAction
    extends DumbAwareAction
    implements LightEditCompatible {
        CharsetAction(@NlsSafe String name, @NlsActions.ActionDescription String description, Icon icon2) {
            super(name, description, icon2);
        }
    }
}

