/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarWidgetsActionGroup
extends ActionGroup {
    public static final String GROUP_ID = "ViewStatusBarWidgetsGroup";

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        Project project;
        Project project2 = project = e != null ? e.getProject() : null;
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                StatusBarWidgetsActionGroup.$$$reportNull$$$0(0);
            }
            return AnAction.EMPTY_ARRAY;
        }
        StatusBarWidgetsManager manager2 = (StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class));
        ArrayList<Object> toggleActions = new ArrayList<Object>(ContainerUtil.map(manager2.getWidgetFactories(), x$0 -> new ToggleWidgetAction((StatusBarWidgetFactory)x$0)));
        toggleActions.add(Separator.getInstance());
        toggleActions.add((Object)new HideCurrentWidgetAction());
        AnAction[] anActionArray = toggleActions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            StatusBarWidgetsActionGroup.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsActionGroup", "getChildren"));
    }

    private static class HideCurrentWidgetAction
    extends DumbAwareAction {
        private HideCurrentWidgetAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            StatusBarWidgetFactory factory2;
            if (e == null) {
                HideCurrentWidgetAction.$$$reportNull$$$0(0);
            }
            if ((factory2 = HideCurrentWidgetAction.getFactory(e)) == null) {
                return;
            }
            ((StatusBarWidgetSettings)((Object)ApplicationManager.getApplication().getService(StatusBarWidgetSettings.class))).setEnabled(factory2, false);
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).updateWidget(factory2);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HideCurrentWidgetAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            StatusBarWidgetFactory factory2 = HideCurrentWidgetAction.getFactory(e);
            e.getPresentation().setEnabledAndVisible(factory2 != null && factory2.isConfigurable());
            if (factory2 != null) {
                e.getPresentation().setText(UIBundle.message((String)"status.bar.hide.widget.action.name", (Object[])new Object[]{factory2.getDisplayName()}));
            }
        }

        @Nullable
        private static StatusBarWidgetFactory getFactory(@NotNull AnActionEvent e) {
            if (e == null) {
                HideCurrentWidgetAction.$$$reportNull$$$0(2);
            }
            Project project = e.getProject();
            String hoveredWidgetId = (String)e.getData(IdeStatusBarImpl.HOVERED_WIDGET_ID);
            StatusBar statusBar = (StatusBar)e.getData(PlatformDataKeys.STATUS_BAR);
            if (project != null && hoveredWidgetId != null && statusBar != null) {
                return ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).findWidgetFactory(hoveredWidgetId);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsActionGroup$HideCurrentWidgetAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFactory";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ToggleWidgetAction
    extends DumbAwareToggleAction {
        private final StatusBarWidgetFactory myWidgetFactory;

        private ToggleWidgetAction(@NotNull StatusBarWidgetFactory widgetFactory) {
            if (widgetFactory == null) {
                ToggleWidgetAction.$$$reportNull$$$0(0);
            }
            super(widgetFactory.getDisplayName());
            this.myWidgetFactory = widgetFactory;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleWidgetAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            Project project = e.getProject();
            if (project == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (ActionPlaces.isMainMenuOrShortcut((String)e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(this.myWidgetFactory.isConfigurable() && this.myWidgetFactory.isAvailable(project));
                return;
            }
            StatusBar statusBar = (StatusBar)e.getData(PlatformDataKeys.STATUS_BAR);
            e.getPresentation().setEnabledAndVisible(statusBar != null && ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).canBeEnabledOnStatusBar(this.myWidgetFactory, statusBar));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleWidgetAction.$$$reportNull$$$0(2);
            }
            return ((StatusBarWidgetSettings)((Object)ApplicationManager.getApplication().getService(StatusBarWidgetSettings.class))).isEnabled(this.myWidgetFactory);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleWidgetAction.$$$reportNull$$$0(3);
            }
            ((StatusBarWidgetSettings)((Object)ApplicationManager.getApplication().getService(StatusBarWidgetSettings.class))).setEnabled(this.myWidgetFactory, state);
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).updateWidget(this.myWidgetFactory);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "widgetFactory";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsActionGroup$ToggleWidgetAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

