/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.search.WordRequestInfo;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final ExtensionPointName<ScopeOptimizer> USE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create((String)"com.intellij.useScopeOptimizer");
    private static final Logger LOG = Logger.getInstance(PsiSearchHelperImpl.class);
    private final PsiManagerEx myManager;
    private final DumbService myDumbService;

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(0);
        }
        SearchScope scope = element2.getUseScope();
        for (UseScopeEnlarger enlarger : (UseScopeEnlarger[])UseScopeEnlarger.EP_NAME.getExtensions()) {
            ProgressManager.checkCanceled();
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element2);
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        SearchScope scopeToRestrict = ScopeOptimizer.calculateOverallRestrictedUseScope((ScopeOptimizer[])((ScopeOptimizer[])USE_SCOPE_OPTIMIZER_EP_NAME.getExtensions()), (PsiElement)element2);
        if (scopeToRestrict != null) {
            scope = scope.intersectWith(scopeToRestrict);
        }
        SearchScope searchScope2 = scope;
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(1);
        }
        return searchScope2;
    }

    public PsiSearchHelperImpl(@NotNull Project project) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(2);
        }
        this.myManager = PsiManagerEx.getInstanceEx(project);
        this.myDumbService = DumbService.getInstance((Project)this.myManager.getProject());
    }

    @Deprecated
    public PsiSearchHelperImpl(@NotNull PsiManagerEx psiManager) {
        if (psiManager == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(3);
        }
        this.myManager = psiManager;
        this.myDumbService = DumbService.getInstance((Project)this.myManager.getProject());
    }

    public PsiElement @NotNull [] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope2) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(4);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(5);
        }
        List result2 = Collections.synchronizedList(new ArrayList());
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processCommentsContainingIdentifier(identifier, searchScope2, (Processor<? super PsiElement>)processor2);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope2, @NotNull Processor<? super PsiElement> processor2) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(7);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(9);
        }
        TextOccurenceProcessor occurrenceProcessor2 = (element2, offsetInElement) -> {
            if (CommentUtilCore.isCommentTextElement(element2) && element2.findReferenceAt(offsetInElement) == null) {
                return processor2.process((Object)element2);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor2, searchScope2, identifier, (short)2, true);
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, boolean caseSensitive) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(10);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(12);
        }
        return this.processElementsWithWord(processor2, searchScope2, text2, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope2));
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(13);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(15);
        }
        EnumSet<Options> options2 = PsiSearchHelperImpl.makeOptions(caseSensitive, processInjectedPsi);
        return this.processElementsWithWord(searchScope2, text2, searchContext, options2, null, new SearchSession(), processor2);
    }

    public boolean hasIdentifierInFile(@NotNull PsiFile file2, @NotNull String name) {
        if (file2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(16);
        }
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(17);
        }
        PsiUtilCore.ensureValid((PsiElement)file2);
        if (file2.getVirtualFile() == null || DumbService.isDumb((Project)file2.getProject())) {
            return StringUtil.contains((CharSequence)file2.getViewProvider().getContents(), (CharSequence)name);
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)file2);
        IdIndexEntry key = new IdIndexEntry(name, true);
        return !FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, (Object)key, fileScope).isEmpty();
    }

    @NotNull
    private static EnumSet<Options> makeOptions(boolean caseSensitive, boolean processInjectedPsi) {
        EnumSet<Options> options2 = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options2.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options2.add(Options.PROCESS_INJECTED_PSI);
        }
        EnumSet<Options> enumSet = options2;
        if (enumSet == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(18);
        }
        return enumSet;
    }

    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, boolean caseSensitively) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(19);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(21);
        }
        boolean result2 = this.processElementsWithWord(processor2, searchScope2, text2, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope2));
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)result2);
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(22);
        }
        return asyncFuture;
    }

    @Deprecated
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, @NotNull EnumSet<Options> options2, @Nullable String containerName) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(23);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(24);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(25);
        }
        if (options2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(26);
        }
        return this.processElementsWithWord(searchScope2, text2, searchContext, options2, containerName, new SearchSession(), processor2);
    }

    public boolean processElementsWithWord(@NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, @NotNull EnumSet<Options> options2, @Nullable String containerName, @NotNull SearchSession session2, @NotNull TextOccurenceProcessor processor2) {
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(27);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(28);
        }
        if (options2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(29);
        }
        if (session2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(30);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(31);
        }
        return this.bulkProcessElementsWithWord(searchScope2, text2, searchContext, options2, containerName, session2, (scope, offsetsInScope, searcher) -> LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, options2.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor2));
    }

    boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope2, @NotNull String text2, short searchContext, @NotNull EnumSet<Options> options2, @Nullable String containerName, @NotNull SearchSession session2, final @NotNull BulkOccurrenceProcessor processor2) {
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(32);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(33);
        }
        if (options2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(34);
        }
        if (session2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(35);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(36);
        }
        if (text2.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope2 instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text2, options2.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options2.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope((GlobalSearchScope)searchScope2, searcher, searchContext, options2.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, session2, progress2, processor2);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope2;
        PsiElement[] scopeElements = scope.getScope();
        final StringSearcher searcher = new StringSearcher(text2, options2.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options2.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical() || scopeElement instanceof PsiCompiledElement) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + scopeElement + " of class " + scopeElement.getClass() + " has null range");
                    return true;
                }
                return processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress2, localProcessor);
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress2 == null) {
            progress2 = new EmptyProgressIndicator();
        }
        progress2.setIndeterminate(false);
        ProgressIndicator progressIndicator = progress2;
        if (progressIndicator == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(37);
        }
        return progressIndicator;
    }

    public static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(38);
        }
        return !(scope instanceof LocalSearchScope) || !((LocalSearchScope)scope).isIgnoreInjectedPsi();
    }

    @NotNull
    static Processor<PsiElement> localProcessor(final @NotNull StringSearcher searcher, final @NotNull BulkOccurrenceProcessor processor2) {
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(39);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(40);
        }
        return new ReadActionProcessor<PsiElement>(){

            public boolean processInReadAction(PsiElement scopeElement) {
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                return scopeElement.isValid() && processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session2, @NotNull ProgressIndicator progress2, @NotNull BulkOccurrenceProcessor processor2) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(41);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(42);
        }
        if (session2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(43);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(44);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(45);
        }
        progress2.pushState();
        try {
            progress2.setText(IndexingBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
            Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(searcher, processor2);
            List<List<VirtualFile>> priorities = this.computePriorities(scope, searcher, searchContext, caseSensitively, containerName, session2);
            if (priorities.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            int totalSize = priorities.stream().mapToInt(l -> l.size()).sum();
            progress2.setText(IndexingBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{searcher.getPattern(), totalSize}));
            int alreadyProcessedFiles = 0;
            for (List<VirtualFile> files2 : priorities) {
                if (!this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress2, localProcessor)) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += files2.size();
            }
        }
        finally {
            progress2.popState();
        }
        return true;
    }

    @NotNull
    private List<List<VirtualFile>> computePriorities(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull SearchSession session2) {
        List directories;
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(46);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(47);
        }
        if (session2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(48);
        }
        String text2 = searcher.getPattern();
        THashSet allFiles = new THashSet();
        this.getFilesWithText(scope, searchContext, caseSensitively, text2, (Collection<? super VirtualFile>)allFiles);
        ArrayList<List<VirtualFile>> priorities = new ArrayList<List<VirtualFile>>();
        List targets2 = (List)ReadAction.compute(() -> ContainerUtil.filter((Collection)session2.getTargetVirtualFiles(), arg_0 -> ((GlobalSearchScope)scope).contains(arg_0)));
        if (!targets2.isEmpty()) {
            priorities.add(targets2);
            allFiles.removeAll(targets2);
            directories = ContainerUtil.mapNotNull((Collection)targets2, v -> v.getParent());
            DelegatingGlobalSearchScope directoryNearTargetScope = new DelegatingGlobalSearchScope(scope){

                public boolean contains(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return super.contains(file2) && directories.contains(file2.getParent());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/search/PsiSearchHelperImpl$3", "contains"));
                }
            };
            List directoryNearTargetFiles = (List)ReadAction.compute(() -> PsiSearchHelperImpl.lambda$computePriorities$6((Set)allFiles, (GlobalSearchScope)directoryNearTargetScope, targets2));
            if (!directoryNearTargetFiles.isEmpty()) {
                priorities.add(directoryNearTargetFiles);
                allFiles.removeAll(directoryNearTargetFiles);
            }
        } else {
            directories = Collections.emptyList();
        }
        if (containerName != null) {
            THashSet intersectionWithContainerFiles = new THashSet();
            this.getFilesWithText(scope, searchContext, caseSensitively, text2 + " " + containerName, (Collection<? super VirtualFile>)intersectionWithContainerFiles);
            intersectionWithContainerFiles.removeAll(targets2);
            intersectionWithContainerFiles.removeAll(directories);
            if (!intersectionWithContainerFiles.isEmpty()) {
                priorities.add(new ArrayList(intersectionWithContainerFiles));
                allFiles.removeAll((Collection<?>)intersectionWithContainerFiles);
            }
        }
        if (!allFiles.isEmpty()) {
            priorities.add(new ArrayList(allFiles));
        }
        ArrayList<List<VirtualFile>> arrayList = priorities;
        if (arrayList == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(49);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPsiFileRoots(@NotNull List<? extends VirtualFile> files2, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress2, @NotNull Processor<? super PsiFile> localProcessor) {
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(50);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(51);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(52);
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean stopped = new AtomicBoolean(false);
            ProgressIndicator originalIndicator = ProgressWrapper.unwrapAll(progress2);
            boolean bl = PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myManager.getProject(), files2, progress2, stopped, (Processor<? super VirtualFile>)((Processor)vfile -> {
                TooManyUsagesStatus.getFrom(originalIndicator).pauseProcessingIfTooManyUsages();
                try {
                    this.processVirtualFile((VirtualFile)vfile, stopped, localProcessor);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Error during processing of: " + vfile.getName(), e);
                    throw e;
                }
                if (progress2.isRunning()) {
                    double fraction = (double)counter.incrementAndGet() / (double)totalSize;
                    progress2.setFraction(fraction);
                }
                return !stopped.get();
            }));
            return bl;
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processFilesConcurrentlyDespiteWriteActions(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @NotNull ProgressIndicator progress2, @NotNull AtomicBoolean stopped, @NotNull Processor<? super VirtualFile> localProcessor) {
        ApplicationEx app;
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(53);
        }
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(54);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(55);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(56);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(57);
        }
        if (!(app = (ApplicationEx)ApplicationManager.getApplication()).isDispatchThread()) {
            CoreProgressManager.assertUnderProgress(progress2);
        }
        List<? extends VirtualFile> processedFiles = Collections.synchronizedList(new ArrayList(files2.size()));
        while (true) {
            ProgressManager.checkCanceled();
            final SensitiveProgressWrapper wrapper2 = new SensitiveProgressWrapper(progress2);
            ApplicationListener listener2 = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action2) {
                    if (action2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    wrapper2.cancel();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/search/PsiSearchHelperImpl$4", "beforeWriteActionStart"));
                }
            };
            processedFiles.clear();
            Disposable disposable2 = Disposer.newDisposable();
            app.addApplicationListener(listener2, disposable2);
            boolean processorCanceled = false;
            try {
                if (app.isWriteAccessAllowed() || app.isReadAccessAllowed() && app.isWriteActionPending()) {
                    boolean bl = processorCanceled = !ContainerUtil.process(files2, localProcessor);
                    if (processorCanceled) {
                        stopped.set(true);
                    }
                    processedFiles.addAll(files2);
                } else if (app.isWriteActionPending()) {
                } else {
                    AtomicBoolean someTaskFailed = new AtomicBoolean();
                    Processor processor2 = vfile -> {
                        ProgressManager.checkCanceled();
                        if (someTaskFailed.get()) {
                            return false;
                        }
                        try {
                            app.executeByImpatientReader(() -> {
                                if (localProcessor.process(vfile)) {
                                    processedFiles.add((VirtualFile)vfile);
                                } else {
                                    stopped.set(true);
                                }
                            });
                        }
                        catch (ProcessCanceledException e) {
                            someTaskFailed.set(true);
                            throw e;
                        }
                        return !stopped.get();
                    };
                    try {
                        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files2, wrapper2, processor2);
                        processorCanceled = stopped.get();
                    }
                    catch (ProcessCanceledException e) {
                        progress2.checkCanceled();
                    }
                }
            }
            finally {
                Disposer.dispose((Disposable)disposable2);
            }
            if (processorCanceled) {
                return false;
            }
            if (processedFiles.size() == files2.size()) break;
            DumbService.getInstance((Project)project).runReadActionInSmartMode(EmptyRunnable.getInstance());
            THashSet t = new THashSet(files2);
            List<? extends VirtualFile> list2 = processedFiles;
            synchronized (list2) {
                t.removeAll(processedFiles);
            }
            files2 = new ArrayList<VirtualFile>((Collection<? extends VirtualFile>)t);
        }
        return true;
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull AtomicBoolean stopped, @NotNull Processor<? super PsiFile> localProcessor) throws ApplicationUtil.CannotRunReadActionException {
        PsiFile file2;
        if (vfile == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(58);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(59);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(60);
        }
        if ((file2 = (PsiFile)ApplicationUtil.tryRunReadAction(() -> vfile.isValid() ? this.myManager.findFile(vfile) : null)) != null && !(file2 instanceof PsiBinaryFile)) {
            ApplicationUtil.tryRunReadAction(() -> {
                Project project = this.myManager.getProject();
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (!DumbUtil.getInstance((Project)project).mayUseIndices()) {
                    throw ApplicationUtil.CannotRunReadActionException.create();
                }
                List psiRoots = file2.getViewProvider().getAllFiles();
                THashSet processed2 = new THashSet(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    ProgressManager.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + file2 + " is null. All roots: " + psiRoots + "; ViewProvider: " + file2.getViewProvider() + "; Virtual file: " + file2.getViewProvider().getVirtualFile();
                    if (!processed2.add(psiRoot) || !psiRoot.isValid() || localProcessor.process((Object)psiRoot)) continue;
                    stopped.set(true);
                    break;
                }
            });
        }
    }

    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text2, @NotNull Collection<? super VirtualFile> result2) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(61);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(62);
        }
        if (result2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(63);
        }
        this.processCandidateFilesForText(scope, searchContext, caseSensitively, text2, (Processor<? super VirtualFile>)Processors.cancelableCollectProcessor(result2));
    }

    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, boolean useOnlyWordHashToSearch, @NotNull String text2, @NotNull Processor<? super VirtualFile> processor2) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(64);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(65);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(66);
        }
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, processor2, TextIndexQuery.fromWord(text2, caseSensitively, useOnlyWordHashToSearch, searchContext));
    }

    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text2, @NotNull Processor<? super VirtualFile> processor2) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(67);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(68);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(69);
        }
        return this.processCandidateFilesForText(scope, searchContext, caseSensitively, false, text2, processor2);
    }

    public PsiFile @NotNull [] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(70);
        }
        PsiFile[] psiFileArray = CacheManager.getInstance((Project)this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope((Project)this.myManager.getProject()), true);
        if (psiFileArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(71);
        }
        return psiFileArray;
    }

    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope searchScope2) {
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(72);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(73);
        }
        if (searchScope2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(74);
        }
        return this.processUsagesInNonJavaFiles(null, qName, processor2, searchScope2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(75);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(76);
        }
        if (initialScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(77);
        }
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        GlobalSearchScope theSearchScope = (GlobalSearchScope)ReadAction.compute(() -> {
            if (originalElement != null && this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                return initialScope.intersectWith(GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
            }
            return initialScope;
        });
        PsiFile[] files2 = (PsiFile[])this.myDumbService.runReadActionInSmartMode(() -> CacheManager.getInstance((Project)this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true));
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        progress2.pushState();
        Ref stopped = Ref.create((Object)Boolean.FALSE);
        try {
            progress2.setText(IndexingBundle.message((String)"psi.search.in.non.java.files.progress", (Object[])new Object[0]));
            SearchScope useScope = originalElement == null ? null : (SearchScope)this.myDumbService.runReadActionInSmartMode(() -> this.getUseScope(originalElement));
            int patternLength = qName.length();
            for (int i2 = 0; i2 < files2.length; ++i2) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = files2[i2];
                if (psiFile instanceof PsiBinaryFile) continue;
                CharSequence text2 = (CharSequence)ReadAction.compute(() -> psiFile.getViewProvider().getContents());
                LowLevelSearchUtil.processTextOccurrences(text2, 0, text2.length(), searcher, index -> {
                    boolean isReferenceOK = (Boolean)this.myDumbService.runReadActionInSmartMode(() -> {
                        PsiReference referenceAt = psiFile.findReferenceAt(index);
                        return referenceAt == null || useScope == null || !PsiSearchScopeUtil.isInScope((SearchScope)useScope.intersectWith((SearchScope)initialScope), (PsiElement)psiFile);
                    });
                    if (isReferenceOK && !processor2.process(psiFile, index, index + patternLength)) {
                        stopped.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (((Boolean)stopped.get()).booleanValue()) {
                    break;
                }
                progress2.setFraction((double)(i2 + 1) / (double)files2.length);
            }
        }
        finally {
            progress2.popState();
        }
        return (Boolean)stopped.get() == false;
    }

    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(78);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(79);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(80);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor2, word, (short)1, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(81);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(82);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(83);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor2, word, (short)16, scope, caseSensitively);
    }

    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(84);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(85);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(86);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor2, word, (short)2, scope, true);
    }

    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(87);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(88);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(89);
        }
        return CacheManager.getInstance((Project)this.myManager.getProject()).processFilesWithWord(processor2, word, (short)4, scope, true);
    }

    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        QueryRequestsRunResult result2;
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(90);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(91);
        }
        HashMap<SearchRequestCollector, Processor<? super PsiReference>> collectors = new HashMap<SearchRequestCollector, Processor<? super PsiReference>>();
        collectors.put(collector, processor2);
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        if (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress2, collectors) == QueryRequestsRunResult.STOPPED) {
            return false;
        }
        do {
            HashMap<TextIndexQuery, Collection<RequestWithProcessor>> globals = new HashMap<TextIndexQuery, Collection<RequestWithProcessor>>();
            ArrayList customs = new ArrayList();
            LinkedHashSet<RequestWithProcessor> locals = new LinkedHashSet<RequestWithProcessor>();
            THashMap localProcessors = new THashMap();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, globals, customs, (Map<RequestWithProcessor, Processor<? super PsiElement>>)localProcessors);
            if (!this.processGlobalRequestsOptimized(globals, progress2, (Map<RequestWithProcessor, Processor<? super PsiElement>>)localProcessors)) {
                return false;
            }
            for (RequestWithProcessor local : locals) {
                progress2.checkCanceled();
                if (this.processSingleRequest(local.request, local.refProcessor)) continue;
                return false;
            }
            for (Computable custom : customs) {
                progress2.checkCanceled();
                if (((Boolean)custom.compute()).booleanValue()) continue;
                return false;
            }
            result2 = PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress2, collectors);
            if (result2 != QueryRequestsRunResult.STOPPED) continue;
            return false;
        } while (result2 != QueryRequestsRunResult.UNCHANGED);
        return true;
    }

    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(92);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(93);
        }
        AsyncFuture asyncFuture = AsyncUtil.wrapBoolean((boolean)this.processRequests(collector, processor2));
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(94);
        }
        return asyncFuture;
    }

    @NotNull
    private static QueryRequestsRunResult appendCollectorsFromQueryRequests(@NotNull ProgressIndicator progress2, @NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors) {
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(95);
        }
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(96);
        }
        boolean changed2 = false;
        LinkedList<SearchRequestCollector> queue2 = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue2.isEmpty()) {
            progress2.checkCanceled();
            SearchRequestCollector each = (SearchRequestCollector)queue2.removeFirst();
            for (QuerySearchRequest request : each.takeQueryRequests()) {
                progress2.checkCanceled();
                if (!request.runQuery()) {
                    QueryRequestsRunResult queryRequestsRunResult = QueryRequestsRunResult.STOPPED;
                    if (queryRequestsRunResult == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(97);
                    }
                    return queryRequestsRunResult;
                }
                assert (!collectors.containsKey(request.collector) || collectors.get(request.collector) == request.processor);
                collectors.put(request.collector, (Processor<? super PsiReference>)request.processor);
                queue2.addLast(request.collector);
                changed2 = true;
            }
        }
        QueryRequestsRunResult queryRequestsRunResult = changed2 ? QueryRequestsRunResult.CHANGED : QueryRequestsRunResult.UNCHANGED;
        if (queryRequestsRunResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(98);
        }
        return queryRequestsRunResult;
    }

    private boolean processGlobalRequestsOptimized(@NotNull Map<TextIndexQuery, Collection<RequestWithProcessor>> singles, @NotNull ProgressIndicator progress2, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        Collection<RequestWithProcessor> requests2;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(99);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(100);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(101);
        }
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests2 = singles.values().iterator().next()).size() == 1) {
            RequestWithProcessor theOnly = requests2.iterator().next();
            return this.processSingleRequest(theOnly.request, theOnly.refProcessor);
        }
        return this.processGlobalRequests(singles, progress2, localProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends WordRequestInfo> boolean processGlobalRequests(@NotNull Map<TextIndexQuery, Collection<T>> singles, @NotNull ProgressIndicator progress2, @NotNull Map<T, Processor<? super PsiElement>> localProcessors) {
        boolean result2;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(102);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(103);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(104);
        }
        progress2.pushState();
        progress2.setText(IndexingBundle.message((String)"psi.scanning.files.progress", (Object[])new Object[0]));
        try {
            HashMap<VirtualFile, Collection<T>> targetFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> nearDirectoryFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> intersectionCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            HashMap<VirtualFile, Collection<T>> restCandidateFiles = new HashMap<VirtualFile, Collection<T>>();
            int totalSize = this.collectFiles(singles, targetFiles, nearDirectoryFiles, intersectionCandidateFiles, restCandidateFiles);
            if (totalSize == 0) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (WordRequestInfo singleRequest : localProcessors.keySet()) {
                ProgressManager.checkCanceled();
                allWords.add(singleRequest.getWord());
            }
            progress2.setText(IndexingBundle.message((String)"psi.search.for.word.progress", (Object[])new Object[]{PsiSearchHelperImpl.concat(allWords), totalSize}));
            int alreadyProcessedFiles = 0;
            if (!targetFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, targetFiles, progress2, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += targetFiles.size();
            }
            if (!nearDirectoryFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, nearDirectoryFiles, progress2, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += nearDirectoryFiles.size();
            }
            if (!intersectionCandidateFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, intersectionCandidateFiles, progress2, totalSize, alreadyProcessedFiles);
                if (!result2) {
                    boolean bl = false;
                    return bl;
                }
                alreadyProcessedFiles += intersectionCandidateFiles.size();
            }
            result2 = this.processCandidates(localProcessors, restCandidateFiles, progress2, totalSize, alreadyProcessedFiles);
        }
        finally {
            progress2.popState();
        }
        return result2;
    }

    private <T> boolean processCandidates(@NotNull Map<T, Processor<? super PsiElement>> localProcessors, @NotNull Map<VirtualFile, Collection<T>> candidateFiles, @NotNull ProgressIndicator progress2, int totalSize, int alreadyProcessedFiles) {
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(105);
        }
        if (candidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(106);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(107);
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(candidateFiles.keySet());
        return this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress2, (Processor<? super PsiFile>)((Processor)psiRoot -> {
            VirtualFile vfile = psiRoot.getVirtualFile();
            for (Object singleRequest : (Collection)candidateFiles.get(vfile)) {
                ProgressManager.checkCanceled();
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(psiRoot)) continue;
                return false;
            }
            return true;
        }));
    }

    @NotNull
    private static CharSequence concat(@NotNull Set<String> allWords) {
        if (allWords == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(108);
        }
        StringBuilder result2 = new StringBuilder(50);
        for (String string : allWords) {
            ProgressManager.checkCanceled();
            if (string.isEmpty()) continue;
            if (result2.length() > 50) {
                result2.append("...");
                break;
            }
            if (result2.length() != 0) {
                result2.append(", ");
            }
            result2.append(string);
        }
        StringBuilder stringBuilder = result2;
        if (stringBuilder == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(109);
        }
        return stringBuilder;
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<? super PsiReference> consumer2) {
        SearchScope searchScope2;
        if (singleRequest == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(110);
        }
        if (consumer2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(111);
        }
        final boolean ignoreInjectedPsi = (searchScope2 = singleRequest.searchScope) instanceof LocalSearchScope && ((LocalSearchScope)searchScope2).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        return new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope, int @NotNull [] offsetsInScope, @NotNull StringSearcher searcher) {
                if (scope == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (searcher == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (offsetsInScope == null) {
                    5.$$$reportNull$$$0(2);
                }
                ProgressManager.checkCanceled();
                if (wrapped instanceof RequestResultProcessor.BulkResultProcessor) {
                    return ((RequestResultProcessor.BulkResultProcessor)wrapped).processTextOccurrences(scope, offsetsInScope, consumer2);
                }
                return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element2, offsetInElement) -> {
                    if (ignoreInjectedPsi && element2 instanceof PsiLanguageInjectionHost) {
                        return true;
                    }
                    return wrapped.processTextOccurrence(element2, offsetInElement, consumer2);
                });
            }

            public String toString() {
                return consumer2.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scope";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "searcher";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "offsetsInScope";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$5";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private <T extends WordRequestInfo> int collectFiles(@NotNull Map<TextIndexQuery, Collection<T>> singles, @NotNull Map<VirtualFile, Collection<T>> targetFiles, @NotNull Map<VirtualFile, Collection<T>> nearDirectoryFiles, @NotNull Map<VirtualFile, Collection<T>> containerNameFiles, @NotNull Map<VirtualFile, Collection<T>> restFiles) {
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(112);
        }
        if (targetFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(113);
        }
        if (nearDirectoryFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(114);
        }
        if (containerNameFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(115);
        }
        if (restFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(116);
        }
        int totalSize = 0;
        for (Map.Entry<TextIndexQuery, Collection<T>> entry : singles.entrySet()) {
            ProgressManager.checkCanceled();
            TextIndexQuery key = entry.getKey();
            if (key.isEmpty()) continue;
            Collection processors = entry.getValue();
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(processors);
            Set thisTargetFiles = (Set)ReadAction.compute(() -> processors.stream().flatMap(p -> p.getSearchSession().getTargetVirtualFiles().stream()).filter(arg_0 -> ((GlobalSearchScope)commonScope).contains(arg_0)).collect(Collectors.toSet()));
            Set thisTargetDirectories = ContainerUtil.map2SetNotNull((Collection)thisTargetFiles, f -> f.getParent());
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, processors, key);
            ArrayList allFilesForKeys = new ArrayList();
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, (Processor<? super VirtualFile>)Processors.cancelableCollectProcessor(allFilesForKeys), key);
            ObjectIntHashMap file2Mask = new ObjectIntHashMap();
            IntRef maskRef = new IntRef();
            for (VirtualFile file3 : allFilesForKeys) {
                ProgressManager.checkCanceled();
                for (IdIndexEntry indexEntry : key.myIdIndexEntries) {
                    ProgressManager.checkCanceled();
                    maskRef.set(0);
                    this.myDumbService.runReadActionInSmartMode(() -> FileBasedIndex.getInstance().processValues(IdIndex.NAME, (Object)indexEntry, file3, (__, value2) -> {
                        maskRef.set(value2.intValue());
                        return true;
                    }, commonScope));
                    int oldMask = file2Mask.get((Object)file3, 255);
                    file2Mask.put((Object)file3, oldMask & maskRef.get());
                }
            }
            file2Mask.forEachEntry((file2, mask) -> {
                this.myDumbService.runReadActionInSmartMode(() -> {
                    Map result2 = thisTargetFiles.contains(file2) ? targetFiles : (thisTargetDirectories.contains(file2.getParent()) ? nearDirectoryFiles : (intersectionWithContainerNameFiles != null && intersectionWithContainerNameFiles.contains(file2) ? containerNameFiles : restFiles));
                    for (WordRequestInfo single : processors) {
                        ProgressManager.checkCanceled();
                        if ((mask & single.getSearchContext()) == 0 || !single.getSearchScope().contains(file2)) continue;
                        result2.computeIfAbsent(file2, ___ -> new SmartList()).add(single);
                    }
                });
                return true;
            });
            totalSize += allFilesForKeys.size();
        }
        return totalSize;
    }

    @Nullable(value="null means we did not find common container files")
    private @Nullable(value="null means we did not find common container files") Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<? extends WordRequestInfo> data2, @NotNull TextIndexQuery query2) {
        if (commonScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(117);
        }
        if (data2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(118);
        }
        if (query2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(119);
        }
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (WordRequestInfo wordRequestInfo : data2) {
            ProgressManager.checkCanceled();
            String containerName = wordRequestInfo.getContainerName();
            if (containerName == null) continue;
            if (commonName == null) {
                commonName = containerName;
                searchContext = wordRequestInfo.getSearchContext();
                caseSensitive = wordRequestInfo.isCaseSensitive();
                continue;
            }
            if (commonName.equals(containerName)) {
                searchContext = (short)(searchContext | wordRequestInfo.getSearchContext());
                caseSensitive &= wordRequestInfo.isCaseSensitive();
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        TextIndexQuery commonNameQuery = TextIndexQuery.fromWord(commonName, caseSensitive, searchContext);
        THashSet tHashSet = new THashSet();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)tHashSet);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, (Processor<? super VirtualFile>)processor2, query2, commonNameQuery);
        return tHashSet;
    }

    @NotNull
    private static Condition<Integer> matchContextCondition(short searchContext) {
        Condition condition = context -> (context & searchContext) != 0;
        if (condition == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(120);
        }
        return condition;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<? extends WordRequestInfo> requests2) {
        if (requests2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(121);
        }
        Set scopes = ContainerUtil.map2LinkedSet(requests2, r -> (GlobalSearchScope)r.getSearchScope());
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])scopes.toArray(GlobalSearchScope.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(122);
        }
        return globalSearchScope;
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull Map<TextIndexQuery, Collection<RequestWithProcessor>> globals, @NotNull List<? super Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(123);
        }
        if (locals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(124);
        }
        if (globals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(125);
        }
        if (customs == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(126);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(127);
        }
        for (Map.Entry<SearchRequestCollector, Processor<? super PsiReference>> entry : collectors.entrySet()) {
            ProgressManager.checkCanceled();
            Processor<? super PsiReference> processor2 = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest primitive : collector.takeSearchRequests()) {
                ProgressManager.checkCanceled();
                SearchScope scope = primitive.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, primitive, processor2);
                    continue;
                }
                TextIndexQuery key = TextIndexQuery.fromWord(primitive.word, primitive.caseSensitive, null);
                PsiSearchHelperImpl.registerRequest(globals.computeIfAbsent(key, __ -> new SmartList()), primitive, processor2);
            }
            for (Processor customAction : collector.takeCustomSearchActions()) {
                ProgressManager.checkCanceled();
                customs.add((Computable<Boolean>)((Computable)() -> customAction.process((Object)processor2)));
            }
        }
        for (Map.Entry<Object, Object> entry : globals.entrySet()) {
            ProgressManager.checkCanceled();
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                ProgressManager.checkCanceled();
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher searcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(searcher, adapted);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<? super PsiReference> processor2) {
        if (collection == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(128);
        }
        if (primitive == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(129);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(130);
        }
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor2);
        for (RequestWithProcessor existing : collection) {
            ProgressManager.checkCanceled();
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<? super PsiReference> consumer2) {
        if (single == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(131);
        }
        if (consumer2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(132);
        }
        EnumSet<Options> options2 = PsiSearchHelperImpl.makeOptions(single.caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope));
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options2, single.containerName, single.getSearchSession(), PsiSearchHelperImpl.adaptProcessor(single, consumer2));
    }

    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress2) {
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(133);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(134);
        }
        if (!((Boolean)ReadAction.compute(() -> scope.getUnloadedModulesBelongingToScope().isEmpty())).booleanValue()) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(135);
            }
            return searchCostResult;
        }
        final AtomicInteger filesCount = new AtomicInteger();
        final AtomicLong filesSizeToProcess = new AtomicLong();
        Processor<VirtualFile> processor2 = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            private final int maxFilesToProcess;
            private final int maxFilesSizeToProcess;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
                this.maxFilesToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", (int)10);
                this.maxFilesSizeToProcess = Registry.intValue((String)"ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", (int)524288);
            }

            public boolean process(VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (Comparing.equal((Object)file2, (Object)this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int currentFilesCount = filesCount.incrementAndGet();
                long accumulatedFileSizeToProcess = filesSizeToProcess.addAndGet(file2.isDirectory() ? 0L : file2.getLength());
                return currentFilesCount < this.maxFilesToProcess && accumulatedFileSizeToProcess < (long)this.maxFilesSizeToProcess;
            }
        };
        TextIndexQuery query2 = TextIndexQuery.fromWord(name, true, null);
        boolean cheap = PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, (Processor<? super VirtualFile>)processor2, query2);
        if (!cheap) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(136);
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = filesCount.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        if (searchCostResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(137);
        }
        return searchCostResult;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor2, TextIndexQuery ... textIndexQueries) {
        if (project == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(138);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(139);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(140);
        }
        if (textIndexQueries == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(141);
        }
        if (ContainerUtil.find((Object[])textIndexQueries, query2 -> !query2.isEmpty()) == null) {
            return true;
        }
        Computable query3 = () -> {
            List queries = ContainerUtil.flatMap(Arrays.asList(textIndexQueries), q -> q.toFileBasedIndexQueries());
            return FileBasedIndex.getInstance().processFilesContainingAllKeys((Collection)queries, scope, processor2);
        };
        if (FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
            if (ApplicationManager.getApplication().isReadAccessAllowed() && (!DumbService.isDumb((Project)project) || FileBasedIndex.getInstance().getCurrentDumbModeAccessType() != null)) {
                return (Boolean)query3.compute();
            }
            return (Boolean)ReadAction.compute(() -> (Boolean)FileBasedIndex.getInstance().ignoreDumbMode(DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE, () -> (Boolean)query3.compute()));
        }
        return (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(query3);
    }

    private static /* synthetic */ List lambda$computePriorities$6(Set allFiles, GlobalSearchScope directoryNearTargetScope, List targets2) throws RuntimeException {
        return ContainerUtil.filter((Collection)allFiles, f -> directoryNearTargetScope.contains(f) && !targets2.contains(f));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 22: 
            case 37: 
            case 49: 
            case 71: 
            case 94: 
            case 97: 
            case 98: 
            case 109: 
            case 120: 
            case 122: 
            case 135: 
            case 136: 
            case 137: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 22: 
            case 37: 
            case 49: 
            case 71: 
            case 94: 
            case 97: 
            case 98: 
            case 109: 
            case 120: 
            case 122: 
            case 135: 
            case 136: 
            case 137: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 22: 
            case 37: 
            case 49: 
            case 71: 
            case 94: 
            case 97: 
            case 98: 
            case 109: 
            case 120: 
            case 122: 
            case 135: 
            case 136: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 2: 
            case 53: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 20: 
            case 24: 
            case 27: 
            case 32: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 23: 
            case 31: 
            case 36: 
            case 40: 
            case 45: 
            case 66: 
            case 69: 
            case 73: 
            case 76: 
            case 80: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 93: 
            case 130: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 15: 
            case 21: 
            case 25: 
            case 28: 
            case 33: 
            case 62: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 30: 
            case 35: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 38: 
            case 41: 
            case 46: 
            case 61: 
            case 64: 
            case 67: 
            case 79: 
            case 82: 
            case 85: 
            case 88: 
            case 134: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 39: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 44: 
            case 51: 
            case 55: 
            case 95: 
            case 100: 
            case 103: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 52: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopped";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 70: 
            case 78: 
            case 81: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScope";
                break;
            }
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 96: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectors";
                break;
            }
            case 99: 
            case 102: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singles";
                break;
            }
            case 101: 
            case 104: 
            case 105: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessors";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFiles";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allWords";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleRequest";
                break;
            }
            case 111: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFiles";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nearDirectoryFiles";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerNameFiles";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restFiles";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonScope";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globals";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customs";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitive";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "single";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textIndexQueries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentsContainingIdentifier";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "makeOptions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "processElementsWithWordAsync";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIndicator";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "computePriorities";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithPlainTextWords";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "processRequestsAsync";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "matchContextCondition";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteScopes";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "isCheapEnoughToSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 22: 
            case 37: 
            case 49: 
            case 71: 
            case 94: 
            case 97: 
            case 98: 
            case 109: 
            case 120: 
            case 122: 
            case 135: 
            case 136: 
            case 137: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommentsContainingIdentifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processCommentsContainingIdentifier";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWord";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasIdentifierInFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWordAsync";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "bulkProcessElementsWithWord";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessInjectedPsi";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "localProcessor";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithTextInGlobalScope";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "computePriorities";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processPsiFileRoots";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processFilesConcurrentlyDespiteWriteActions";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFile";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithText";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processCandidateFilesForText";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithPlainTextWords";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInNonJavaFiles";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWord";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInText";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInComments";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInLiterals";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "processRequests";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "processRequestsAsync";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequestsOptimized";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequests";
                break;
            }
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "adaptProcessor";
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "intersectionWithContainerNameFiles";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "uniteScopes";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "distributePrimitives";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "registerRequest";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "processSingleRequest";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "isCheapEnoughToSearch";
                break;
            }
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 18: 
            case 22: 
            case 37: 
            case 49: 
            case 71: 
            case 94: 
            case 97: 
            case 98: 
            case 109: 
            case 120: 
            case 122: 
            case 135: 
            case 136: 
            case 137: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class TextIndexQuery {
        @NotNull
        private final Set<IdIndexEntry> myIdIndexEntries;
        @NotNull
        private final Set<Integer> myTrigrams;
        @Nullable
        private final Short myContext;
        private final boolean myUseOnlyWeakHashToSearch;

        private TextIndexQuery(@NotNull Set<IdIndexEntry> idIndexEntries, @NotNull Set<Integer> trigrams, @Nullable Short context, boolean useOnlyWeakHashToSearch) {
            if (idIndexEntries == null) {
                TextIndexQuery.$$$reportNull$$$0(0);
            }
            if (trigrams == null) {
                TextIndexQuery.$$$reportNull$$$0(1);
            }
            this.myIdIndexEntries = idIndexEntries;
            this.myTrigrams = trigrams;
            this.myContext = context;
            this.myUseOnlyWeakHashToSearch = useOnlyWeakHashToSearch;
        }

        public boolean isEmpty() {
            return this.myIdIndexEntries.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextIndexQuery query2 = (TextIndexQuery)o;
            return this.myIdIndexEntries.equals(query2.myIdIndexEntries) && this.myTrigrams.equals(query2.myTrigrams) && Objects.equals(this.myContext, query2.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myIdIndexEntries, this.myTrigrams, this.myContext);
        }

        @NotNull
        public List<FileBasedIndex.AllKeysQuery<?, ?>> toFileBasedIndexQueries() {
            Condition<Integer> contextCondition = this.myContext == null ? null : PsiSearchHelperImpl.matchContextCondition(this.myContext);
            FileBasedIndex.AllKeysQuery idIndexQuery = new FileBasedIndex.AllKeysQuery(IdIndex.NAME, this.myIdIndexEntries, contextCondition);
            if (this.myUseOnlyWeakHashToSearch || this.myTrigrams.isEmpty()) {
                List<FileBasedIndex.AllKeysQuery<?, ?>> list2 = Collections.singletonList(idIndexQuery);
                if (list2 == null) {
                    TextIndexQuery.$$$reportNull$$$0(2);
                }
                return list2;
            }
            FileBasedIndex.AllKeysQuery trigramIndexQuery = new FileBasedIndex.AllKeysQuery(TrigramIndex.INDEX_ID, this.myTrigrams, null);
            List<FileBasedIndex.AllKeysQuery<?, ?>> list3 = Arrays.asList(idIndexQuery, trigramIndexQuery);
            if (list3 == null) {
                TextIndexQuery.$$$reportNull$$$0(3);
            }
            return list3;
        }

        @NotNull
        private static TextIndexQuery fromWord(@NotNull String word, boolean caseSensitively, boolean useOnlyWeakHashToSearch, @Nullable Short context) {
            if (word == null) {
                TextIndexQuery.$$$reportNull$$$0(4);
            }
            return TextIndexQuery.fromWords(Collections.singleton(word), caseSensitively, useOnlyWeakHashToSearch, context);
        }

        @NotNull
        public static TextIndexQuery fromWord(@NotNull String word, boolean caseSensitively, @Nullable Short context) {
            if (word == null) {
                TextIndexQuery.$$$reportNull$$$0(5);
            }
            return TextIndexQuery.fromWord(word, caseSensitively, false, context);
        }

        @NotNull
        public static TextIndexQuery fromWords(@NotNull Collection<String> words, boolean caseSensitively, boolean useOnlyWeakHashToSearch, @Nullable Short context) {
            if (words == null) {
                TextIndexQuery.$$$reportNull$$$0(6);
            }
            Set keys2 = CollectionFactory.createSmallMemoryFootprintSet((Collection)ContainerUtil.flatMap(words, w -> TextIndexQuery.getWordEntries(w, caseSensitively)));
            IntOpenHashSet trigrams = new IntOpenHashSet();
            if (!useOnlyWeakHashToSearch) {
                for (String word : words) {
                    TrigramBuilder.processTrigrams((CharSequence)word, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor((Set)trigrams){
                        final /* synthetic */ Set val$trigrams;
                        {
                            this.val$trigrams = set2;
                        }

                        public boolean test(int value2) {
                            this.val$trigrams.add(value2);
                            return true;
                        }
                    });
                }
            }
            return new TextIndexQuery(keys2, (Set<Integer>)trigrams, context, useOnlyWeakHashToSearch);
        }

        @NotNull
        private static List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
            String trimmed;
            List<String> words;
            if (name == null) {
                TextIndexQuery.$$$reportNull$$$0(7);
            }
            if ((words = StringUtil.getWordsInStringLongestFirst((String)name)).isEmpty() && StringUtil.isNotEmpty((String)(trimmed = name.trim()))) {
                words = Collections.singletonList(trimmed);
            }
            if (words.isEmpty()) {
                List<IdIndexEntry> list2 = Collections.emptyList();
                if (list2 == null) {
                    TextIndexQuery.$$$reportNull$$$0(8);
                }
                return list2;
            }
            List list3 = ContainerUtil.map2List((Collection)words, word -> new IdIndexEntry((String)word, caseSensitively));
            if (list3 == null) {
                TextIndexQuery.$$$reportNull$$$0(9);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idIndexEntries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trigrams";
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$TextIndexQuery";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "words";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$TextIndexQuery";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toFileBasedIndexQueries";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWordEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWord";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fromWords";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getWordEntries";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum QueryRequestsRunResult {
        STOPPED,
        UNCHANGED,
        CHANGED;

    }

    private static final class RequestWithProcessor
    implements WordRequestInfo {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<? super PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request, @NotNull Processor<? super PsiReference> processor2) {
            if (request == null) {
                RequestWithProcessor.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                RequestWithProcessor.$$$reportNull$$$0(1);
            }
            this.request = request;
            this.refProcessor = processor2;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (another == null) {
                RequestWithProcessor.$$$reportNull$$$0(2);
            }
            if (this.request.equals((Object)another.request)) {
                Processor<? super PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> myProcessor.process(psiReference) && another.refProcessor.process(psiReference);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }

        @Override
        @NotNull
        public String getWord() {
            String string = this.request.word;
            if (string == null) {
                RequestWithProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public SearchScope getSearchScope() {
            SearchScope searchScope2 = this.request.searchScope;
            if (searchScope2 == null) {
                RequestWithProcessor.$$$reportNull$$$0(4);
            }
            return searchScope2;
        }

        @Override
        public short getSearchContext() {
            return this.request.searchContext;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.request.caseSensitive;
        }

        @Override
        @NotNull
        public SearchSession getSearchSession() {
            SearchSession searchSession = this.request.getSearchSession();
            if (searchSession == null) {
                RequestWithProcessor.$$$reportNull$$$0(5);
            }
            return searchSession;
        }

        @Override
        @Nullable
        public String getContainerName() {
            return this.request.containerName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWord";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }
}

