/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.psi.stubs.ByteArrayInterner;
import com.intellij.psi.stubs.FileLocalStringEnumerator;
import com.intellij.psi.stubs.IntEnumerator;
import com.intellij.psi.stubs.LazyStubData;
import com.intellij.psi.stubs.LazyStubList;
import com.intellij.psi.stubs.MostlyUShortIntList;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubList;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.RecentStringInterner;
import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StubSerializationHelper {
    private static final Logger LOG = Logger.getInstance(StubSerializationHelper.class);
    private final DataEnumeratorEx<String> myNameStorage;
    private final Int2ObjectMap<String> myIdToName;
    private final Object2IntMap<String> myNameToId;
    private final Object2ObjectMap<String, Supplier<ObjectStubSerializer<?, ? extends Stub>>> myNameToLazySerializer;
    private final ConcurrentIntObjectMap<ObjectStubSerializer<?, ? extends Stub>> myIdToSerializer;
    private final Map<ObjectStubSerializer<?, ? extends Stub>, Integer> mySerializerToId;
    private final boolean myUnmodifiable;
    private final RecentStringInterner myStringInterner;
    private static final ThreadLocal<ObjectStubSerializer<?, ? extends Stub>> ourRootStubSerializer = new ThreadLocal();

    void dropRegisteredSerializers() {
        this.myIdToName.clear();
        this.myNameToId.clear();
        this.myNameToLazySerializer.clear();
        this.myIdToSerializer.clear();
        this.mySerializerToId.clear();
    }

    StubSerializationHelper(@NotNull DataEnumeratorEx<String> nameStorage, boolean unmodifiable, @NotNull Disposable parentDisposable) {
        if (nameStorage == null) {
            StubSerializationHelper.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            StubSerializationHelper.$$$reportNull$$$0(1);
        }
        this.myIdToName = new Int2ObjectOpenHashMap();
        this.myNameToId = new Object2IntOpenHashMap();
        this.myNameToLazySerializer = new Object2ObjectOpenHashMap();
        this.myIdToSerializer = ContainerUtil.createConcurrentIntObjectMap();
        this.mySerializerToId = new ConcurrentHashMap();
        this.myNameStorage = nameStorage;
        this.myUnmodifiable = unmodifiable;
        this.myStringInterner = new RecentStringInterner(parentDisposable);
    }

    void assignId(@NotNull Supplier<ObjectStubSerializer<?, ? extends Stub>> serializer2, String name) throws IOException {
        int id2;
        Supplier old;
        if (serializer2 == null) {
            StubSerializationHelper.$$$reportNull$$$0(2);
        }
        if ((old = (Supplier)this.myNameToLazySerializer.put((Object)name, serializer2)) != null) {
            ObjectStubSerializer<?, Stub> computed;
            ObjectStubSerializer existing = (ObjectStubSerializer)old.get();
            if (existing != (computed = serializer2.get())) {
                throw new AssertionError((Object)("ID: " + name + " is not unique, but found in both " + existing.getClass().getName() + " and " + computed.getClass().getName()));
            }
            return;
        }
        if (this.myUnmodifiable) {
            id2 = this.myNameStorage.tryEnumerate((Object)name);
            if (id2 == 0) {
                LOG.debug("serialized " + name + " is ignored in unmodifiable stub serialization manager");
                return;
            }
        } else {
            id2 = this.myNameStorage.enumerate((Object)name);
        }
        this.myIdToName.put(id2, (Object)name);
        this.myNameToId.put((Object)name, id2);
    }

    void copyFrom(@Nullable StubSerializationHelper helper) throws IOException {
        if (helper == null) {
            return;
        }
        for (Object2ObjectMap.Entry entry : helper.myNameToLazySerializer.object2ObjectEntrySet()) {
            this.assignId((Supplier)entry.getValue(), (String)entry.getKey());
        }
    }

    @NotNull
    private ObjectStubSerializer<Stub, Stub> writeSerializerId(Stub stub, @NotNull DataOutput stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        ObjectStubSerializer serializer2;
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(3);
        }
        if ((serializer2 = StubSerializationUtil.getSerializer((Stub)stub)) == null) {
            throw new Error("No serializer was returned for " + stub);
        }
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)serializerLocalEnumerator.enumerate(this.getClassId((ObjectStubSerializer<Stub, Stub>)serializer2)));
        ObjectStubSerializer objectStubSerializer = serializer2;
        if (objectStubSerializer == null) {
            StubSerializationHelper.$$$reportNull$$$0(4);
        }
        return objectStubSerializer;
    }

    private void serializeSelf(Stub stub, @NotNull StubOutputStream stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(5);
        }
        if (((ObjectStubBase)stub).isDangling()) {
            stream.writeByte(0);
        }
        this.writeSerializerId(stub, (DataOutput)stream, serializerLocalEnumerator).serialize(stub, stream);
    }

    private void serializeChildren(@NotNull Stub parent, @NotNull StubOutputStream stream, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (parent == null) {
            StubSerializationHelper.$$$reportNull$$$0(6);
        }
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(7);
        }
        List children2 = parent.getChildrenStubs();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)children2.size());
        for (Stub child2 : children2) {
            this.serializeSelf(child2, stream, serializerLocalEnumerator);
            this.serializeChildren(child2, stream, serializerLocalEnumerator);
        }
    }

    void serialize(@NotNull Stub rootStub, @NotNull OutputStream stream) throws IOException {
        if (rootStub == null) {
            StubSerializationHelper.$$$reportNull$$$0(8);
        }
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(9);
        }
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(true);
        IntEnumerator serializerIdLocalEnumerator = new IntEnumerator();
        StubOutputStream stubOutputStream = new StubOutputStream((OutputStream)out, (AbstractStringEnumerator)storage);
        boolean doDefaultSerialization = true;
        if (rootStub instanceof PsiFileStubImpl) {
            PsiFileStub[] roots = ((PsiFileStubImpl)rootStub).getStubRoots();
            if (roots.length == 0) {
                Logger.getInstance(this.getClass()).error("Incorrect stub files count during serialization:" + rootStub + "," + rootStub.getStubType());
            } else {
                doDefaultSerialization = false;
                DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)roots.length);
                for (PsiFileStub root : roots) {
                    this.serializeRoot(stubOutputStream, (Stub)root, storage, serializerIdLocalEnumerator);
                }
            }
        }
        if (doDefaultSerialization) {
            DataInputOutputUtil.writeINT((DataOutput)stubOutputStream, (int)1);
            this.serializeRoot(stubOutputStream, rootStub, storage, serializerIdLocalEnumerator);
        }
        DataOutputStream resultStream = new DataOutputStream(stream);
        serializerIdLocalEnumerator.dump(resultStream);
        storage.write(resultStream);
        resultStream.write(out.getInternalBuffer(), 0, out.size());
    }

    private int getClassId(@NotNull ObjectStubSerializer<Stub, Stub> serializer2) {
        Integer idValue;
        if (serializer2 == null) {
            StubSerializationHelper.$$$reportNull$$$0(10);
        }
        if ((idValue = this.mySerializerToId.get(serializer2)) == null) {
            String name = serializer2.getExternalId();
            idValue = this.myNameToId.getInt((Object)name);
            assert (idValue > 0) : "No ID found for serializer " + LogUtil.objectAndClass(serializer2) + ", external id:" + name + (String)(serializer2 instanceof IElementType ? ", language:" + ((IElementType)serializer2).getLanguage() + ", " + serializer2 : "");
            this.mySerializerToId.put(serializer2, idValue);
        }
        return idValue;
    }

    @NotNull
    Stub deserialize(@NotNull InputStream stream) throws IOException, SerializerNotFoundException {
        PsiFileStub[] stubsArray;
        if (stream == null) {
            StubSerializationHelper.$$$reportNull$$$0(11);
        }
        FileLocalStringEnumerator storage = new FileLocalStringEnumerator(false);
        StubInputStream inputStream2 = new StubInputStream(stream, (AbstractStringEnumerator)storage);
        IntEnumerator serializerLocalEnumerator = IntEnumerator.read((DataInput)inputStream2);
        storage.read((DataInput)inputStream2, this::intern);
        int stubFilesCount = DataInputOutputUtil.readINT((DataInput)inputStream2);
        if (stubFilesCount <= 0) {
            Logger.getInstance(this.getClass()).error("Incorrect stub files count during deserialization:" + stubFilesCount);
        }
        Stub baseStub = this.deserializeRoot(inputStream2, storage, serializerLocalEnumerator);
        ArrayList<PsiFileStub> stubs = new ArrayList<PsiFileStub>(stubFilesCount);
        if (baseStub instanceof PsiFileStub) {
            stubs.add((PsiFileStub)baseStub);
        }
        for (int j = 1; j < stubFilesCount; ++j) {
            Stub deserialize = this.deserializeRoot(inputStream2, storage, serializerLocalEnumerator);
            if (deserialize instanceof PsiFileStub) {
                stubs.add((PsiFileStub)deserialize);
                continue;
            }
            Logger.getInstance(this.getClass()).error("Stub root must be PsiFileStub for files with several stub roots");
        }
        for (PsiFileStub stub : stubsArray = stubs.toArray(PsiFileStub.EMPTY_ARRAY)) {
            if (!(stub instanceof PsiFileStubImpl)) continue;
            ((PsiFileStubImpl)stub).setStubRoots(stubsArray);
        }
        Stub stub = baseStub;
        if (stub == null) {
            StubSerializationHelper.$$$reportNull$$$0(12);
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stub deserializeRoot(StubInputStream inputStream2, FileLocalStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        ObjectStubSerializer<?, Stub> serializer2 = this.getClassById(DataInputOutputUtil.readINT((DataInput)inputStream2), null, serializerLocalEnumerator);
        ourRootStubSerializer.set(serializer2);
        try {
            Stub stub = serializer2.deserialize(inputStream2, null);
            if (stub instanceof StubBase) {
                this.deserializeStubList((StubBase)stub, serializer2, inputStream2, storage, serializerLocalEnumerator);
            } else {
                this.deserializeChildren(inputStream2, stub, serializerLocalEnumerator);
            }
            Stub stub2 = stub;
            return stub2;
        }
        finally {
            ourRootStubSerializer.set(null);
        }
    }

    private void serializeRoot(StubOutputStream out, Stub root, AbstractStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException {
        this.serializeSelf(root, out, serializerLocalEnumerator);
        if (root instanceof StubBase) {
            StubList stubList = ((StubBase)root).myStubList;
            if (root != stubList.get(0)) {
                throw new IllegalArgumentException("Serialization is supported only for root stubs");
            }
            this.serializeStubList(stubList, (DataOutput)out, storage, serializerLocalEnumerator);
        } else {
            this.serializeChildren(root, out, serializerLocalEnumerator);
        }
    }

    private void deserializeStubList(StubBase<?> root, final ObjectStubSerializer<?, ? extends Stub> rootType, final StubInputStream inputStream2, FileLocalStringEnumerator storage, final IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        int stubCount = DataInputOutputUtil.readINT((DataInput)inputStream2);
        final LazyStubList stubList = new LazyStubList(stubCount, root, rootType);
        final MostlyUShortIntList parentsAndStarts = new MostlyUShortIntList(stubCount * 2);
        final BitSet allStarts = new BitSet();
        new Object(){
            int currentIndex = 1;

            private void deserializeStub(int parentIndex) throws IOException, SerializerNotFoundException {
                int index = this.currentIndex++;
                int serializerId = DataInputOutputUtil.readINT((DataInput)inputStream2);
                int start2 = DataInputOutputUtil.readINT((DataInput)inputStream2);
                allStarts.set(start2);
                this.addStub(parentIndex, index, start2, (IElementType)StubSerializationHelper.this.getClassById(serializerId, null, serializerLocalEnumerator));
                this.deserializeChildren(index);
            }

            private void addStub(int parentIndex, int index, int start2, IElementType type) {
                parentsAndStarts.add(parentIndex);
                parentsAndStarts.add(start2);
                stubList.addLazyStub(type, index, parentIndex);
            }

            private void deserializeChildren(int parentIndex) throws IOException, SerializerNotFoundException {
                int childrenCount = DataInputOutputUtil.readINT((DataInput)inputStream2);
                stubList.prepareForChildren(parentIndex, childrenCount);
                for (int i2 = 0; i2 < childrenCount; ++i2) {
                    this.deserializeStub(parentIndex);
                }
            }

            void deserializeRoot() throws IOException, SerializerNotFoundException {
                this.addStub(0, 0, 0, (IElementType)rootType);
                this.deserializeChildren(0);
            }
        }.deserializeRoot();
        byte[] serializedStubs = this.readByteArray(inputStream2);
        stubList.setStubData(new LazyStubData(storage, parentsAndStarts, serializedStubs, allStarts));
    }

    private void serializeStubList(StubList stubList, DataOutput out, AbstractStringEnumerator storage, IntEnumerator serializerLocalEnumerator) throws IOException {
        if (!stubList.isChildrenLayoutOptimal()) {
            throw new IllegalArgumentException("Manually assembled stubs should be normalized before serialization, consider wrapping them into StubTree");
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.size());
        DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(0));
        BufferExposingByteArrayOutputStream tempBuffer = new BufferExposingByteArrayOutputStream();
        ByteArrayInterner interner = new ByteArrayInterner();
        for (int i2 = 1; i2 < stubList.size(); ++i2) {
            StubBase stub = (StubBase)stubList.get(i2);
            ObjectStubSerializer<Stub, Stub> serializer2 = this.writeSerializerId((Stub)stub, out, serializerLocalEnumerator);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)interner.internBytes(StubSerializationHelper.serializeStub(serializer2, storage, stub, tempBuffer)));
            DataInputOutputUtil.writeINT((DataOutput)out, (int)stubList.getChildrenCount(stub.id));
        }
        StubSerializationHelper.writeByteArray(out, interner.joinedBuffer.getInternalBuffer(), interner.joinedBuffer.size());
    }

    private static byte[] serializeStub(ObjectStubSerializer<Stub, Stub> serializer2, AbstractStringEnumerator storage, StubBase<?> stub, BufferExposingByteArrayOutputStream tempBuffer) throws IOException {
        tempBuffer.reset();
        StubOutputStream stubOut = new StubOutputStream((OutputStream)tempBuffer, storage);
        serializer2.serialize(stub, stubOut);
        if (stub.isDangling()) {
            stubOut.writeByte(0);
        }
        return tempBuffer.size() == 0 ? ArrayUtilRt.EMPTY_BYTE_ARRAY : tempBuffer.toByteArray();
    }

    private byte[] readByteArray(StubInputStream inputStream2) throws IOException {
        int length = DataInputOutputUtil.readINT((DataInput)inputStream2);
        if (length == 0) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] array2 = new byte[length];
        int read = inputStream2.read(array2);
        if (read != array2.length) {
            Logger.getInstance(this.getClass()).error("Serialized array length mismatch");
        }
        return array2;
    }

    private static void writeByteArray(DataOutput out, byte[] array2, int len) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)out, (int)len);
        out.write(array2, 0, len);
    }

    @Nullable
    @Contract(value="null -> null")
    String intern(@Nullable String str) {
        return this.myStringInterner.get(str);
    }

    void reSerializeStub(@NotNull DataInputStream inStub, @NotNull DataOutputStream outStub, @NotNull StubSerializationHelper newSerializationHelper) throws IOException {
        if (inStub == null) {
            StubSerializationHelper.$$$reportNull$$$0(13);
        }
        if (outStub == null) {
            StubSerializationHelper.$$$reportNull$$$0(14);
        }
        if (newSerializationHelper == null) {
            StubSerializationHelper.$$$reportNull$$$0(15);
        }
        IntEnumerator currentSerializerEnumerator = IntEnumerator.read(inStub);
        currentSerializerEnumerator.dump(outStub, id2 -> {
            String name = (String)this.myIdToName.get(id2);
            return name == null ? 0 : newSerializationHelper.myNameToId.getInt((Object)name);
        });
        StreamUtil.copy((InputStream)inStub, (OutputStream)outStub);
    }

    private ObjectStubSerializer<?, Stub> getClassById(int localId, @Nullable Stub parentStub, IntEnumerator enumerator) throws SerializerNotFoundException {
        int id2 = enumerator.valueOf(localId);
        ObjectStubSerializer<?, ? extends Stub> serializer2 = (ObjectStubSerializer<?, ? extends Stub>)this.myIdToSerializer.get(id2);
        if (serializer2 == null) {
            serializer2 = this.instantiateSerializer(id2, parentStub);
            this.myIdToSerializer.put(id2, serializer2);
        }
        return serializer2;
    }

    @NotNull
    private ObjectStubSerializer<?, ? extends Stub> instantiateSerializer(int id2, @Nullable Stub parentStub) throws SerializerNotFoundException {
        ObjectStubSerializer serializer2;
        String name = (String)this.myIdToName.get(id2);
        Supplier lazy = name == null ? null : (Supplier)this.myNameToLazySerializer.get((Object)name);
        ObjectStubSerializer objectStubSerializer = serializer2 = lazy == null ? null : (ObjectStubSerializer)lazy.get();
        if (serializer2 == null) {
            throw this.reportMissingSerializer(id2, name, parentStub);
        }
        ObjectStubSerializer objectStubSerializer2 = serializer2;
        if (objectStubSerializer2 == null) {
            StubSerializationHelper.$$$reportNull$$$0(16);
        }
        return objectStubSerializer2;
    }

    private SerializerNotFoundException reportMissingSerializer(int id2, @Nullable String name, @Nullable Stub parentStub) {
        String externalId = null;
        try {
            externalId = (String)this.myNameStorage.valueOf(id2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ObjectStubSerializer<?, ? extends Stub> root = ourRootStubSerializer.get();
        return new SerializerNotFoundException((root != null ? StubSerializationUtil.brokenStubFormat(root) : "") + "No serializer is registered for stub ID: " + id2 + ", externalId: " + externalId + ", name: " + name + "; parent stub class: " + (String)(parentStub != null ? parentStub.getClass().getName() + ", parent stub type: " + parentStub.getStubType() : "null"));
    }

    private void deserializeChildren(StubInputStream stream, Stub parent, IntEnumerator serializerLocalEnumerator) throws IOException, SerializerNotFoundException {
        int childCount = DataInputOutputUtil.readINT((DataInput)stream);
        for (int i2 = 0; i2 < childCount; ++i2) {
            boolean dangling = false;
            int id2 = DataInputOutputUtil.readINT((DataInput)stream);
            if (id2 == 0) {
                dangling = true;
                id2 = DataInputOutputUtil.readINT((DataInput)stream);
            }
            Stub child2 = this.getClassById(id2, parent, serializerLocalEnumerator).deserialize(stream, parent);
            if (dangling) {
                ((ObjectStubBase)child2).markDangling();
            }
            this.deserializeChildren(stream, child2, serializerLocalEnumerator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStorage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubSerializationHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inStub";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outStub";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubSerializationHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "writeSerializerId";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assignId";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSerializerId";
                break;
            }
            case 4: 
            case 12: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeSelf";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serializeChildren";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getClassId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reSerializeStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

