/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.util.ArrayUtilRt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameSuggestionsField
extends JPanel {
    private final JComponent myComponent;
    private final EventListenerList myListenerList = new EventListenerList();
    private final MyComboBoxModel myComboBoxModel;
    private final Project myProject;
    private MyDocumentListener myDocumentListener;
    private MyComboBoxItemListener myComboBoxItemListener;
    private boolean myNonHumanChange = false;

    public NameSuggestionsField(Project project) {
        super(new BorderLayout());
        this.myProject = project;
        this.myComboBoxModel = new MyComboBoxModel();
        ComboBox comboBox2 = new ComboBox((ComboBoxModel)this.myComboBoxModel, -1);
        this.myComponent = comboBox2;
        this.add((Component)this.myComponent, "Center");
        this.setupComboBox(comboBox2, (FileType)StdFileTypes.JAVA);
    }

    public NameSuggestionsField(String[] nameSuggestions, Project project) {
        this(nameSuggestions, project, (FileType)StdFileTypes.JAVA);
    }

    public NameSuggestionsField(String[] nameSuggestions, Project project, FileType fileType) {
        super(new BorderLayout());
        this.myProject = project;
        if (nameSuggestions == null || nameSuggestions.length <= 1) {
            this.myComponent = this.createTextFieldForName(nameSuggestions, fileType);
        } else {
            ComboBox combobox = new ComboBox((Object[])nameSuggestions);
            combobox.setSelectedIndex(0);
            this.setupComboBox(combobox, fileType);
            this.myComponent = combobox;
        }
        this.add((Component)this.myComponent, "Center");
        this.myComboBoxModel = null;
    }

    public NameSuggestionsField(String[] suggestedNames, Project project, FileType fileType, @Nullable Editor editor) {
        this(suggestedNames, project, fileType);
        if (editor == null) {
            return;
        }
        Runnable selectionRunnable = () -> {
            int offset = editor.getCaretModel().getOffset();
            ArrayList ranges = new ArrayList();
            SelectWordUtil.addWordSelection(editor.getSettings().isCamelWords(), editor.getDocument().getCharsSequence(), offset, ranges);
            Editor myEditor = this.getEditor();
            if (myEditor == null) {
                return;
            }
            for (TextRange wordRange : ranges) {
                String word = editor.getDocument().getText(wordRange);
                if (!word.equals(this.getEnteredName())) continue;
                SelectionModel selectionModel = editor.getSelectionModel();
                myEditor.getSelectionModel().removeSelection();
                int wordRangeStartOffset = wordRange.getStartOffset();
                int myOffset = offset - wordRangeStartOffset;
                myEditor.getCaretModel().moveToOffset(myOffset);
                TextRange selected2 = new TextRange(Math.max(0, selectionModel.getSelectionStart() - wordRangeStartOffset), Math.max(0, selectionModel.getSelectionEnd() - wordRangeStartOffset));
                selected2 = selected2.intersection(new TextRange(0, myEditor.getDocument().getTextLength()));
                if (selectionModel.hasSelection() && selected2 != null && !selected2.isEmpty()) {
                    myEditor.getSelectionModel().setSelection(selected2.getStartOffset(), selected2.getEndOffset());
                    break;
                }
                if (!this.shouldSelectAll()) break;
                myEditor.getSelectionModel().setSelection(0, myEditor.getDocument().getTextLength());
                break;
            }
        };
        SwingUtilities.invokeLater(selectionRunnable);
    }

    protected boolean shouldSelectAll() {
        return true;
    }

    public void selectNameWithoutExtension() {
        SwingUtilities.invokeLater(() -> {
            Editor editor = this.getEditor();
            if (editor == null) {
                return;
            }
            int pos = editor.getDocument().getText().lastIndexOf(46);
            if (pos > 0) {
                editor.getSelectionModel().setSelection(0, pos);
                editor.getCaretModel().moveToOffset(pos);
            }
        });
    }

    public void select(int start2, int end) {
        SwingUtilities.invokeLater(() -> {
            Editor editor = this.getEditor();
            if (editor == null) {
                return;
            }
            editor.getSelectionModel().setSelection(start2, end);
            editor.getCaretModel().moveToOffset(end);
        });
    }

    public void setSuggestions(String[] suggestions) {
        if (this.myComboBoxModel == null) {
            return;
        }
        JComboBox comboBox2 = (JComboBox)this.myComponent;
        String oldSelectedItem = (String)comboBox2.getSelectedItem();
        String oldItemFromTextField = (String)comboBox2.getEditor().getItem();
        boolean shouldUpdateTextField = oldItemFromTextField.equals(oldSelectedItem) || oldItemFromTextField.trim().length() == 0;
        this.myComboBoxModel.setSuggestions(suggestions);
        if (suggestions.length > 0 && shouldUpdateTextField) {
            if (oldSelectedItem != null) {
                comboBox2.setSelectedItem(oldSelectedItem);
            } else {
                comboBox2.setSelectedIndex(0);
            }
        } else {
            comboBox2.getEditor().setItem(oldItemFromTextField);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getFocusableComponent() {
        if (this.myComponent instanceof JComboBox) {
            return (JComponent)((JComboBox)this.myComponent).getEditor().getEditorComponent();
        }
        return this.myComponent;
    }

    public String getEnteredName() {
        if (this.myComponent instanceof JComboBox) {
            return (String)((JComboBox)this.myComponent).getEditor().getItem();
        }
        return ((EditorTextField)((Object)this.myComponent)).getText();
    }

    public boolean hasSuggestions() {
        return this.myComponent instanceof JComboBox;
    }

    private JComponent createTextFieldForName(String[] nameSuggestions, FileType fileType) {
        String text2 = nameSuggestions != null && nameSuggestions.length > 0 && nameSuggestions[0] != null ? nameSuggestions[0] : "";
        EditorTextField field = new EditorTextField(text2, this.myProject, fileType);
        field.selectAll();
        return field;
    }

    private void setupComboBox(ComboBox combobox, FileType fileType) {
        StringComboboxEditor comboEditor = new StringComboboxEditor(this.myProject, fileType, combobox){

            @Override
            public void setItem(Object anObject) {
                NameSuggestionsField.this.myNonHumanChange = true;
                super.setItem(anObject);
            }
        };
        combobox.setEditor((ComboBoxEditor)comboEditor);
        combobox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboEditor));
        combobox.setEditable(true);
        combobox.setMaximumRowCount(8);
        comboEditor.selectAll();
    }

    public Editor getEditor() {
        if (this.myComponent instanceof EditorTextField) {
            return ((EditorTextField)((Object)this.myComponent)).getEditor();
        }
        return ((EditorTextField)((Object)((JComboBox)this.myComponent).getEditor().getEditorComponent())).getEditor();
    }

    public void addDataChangedListener(DataChanged listener2) {
        this.myListenerList.add(DataChanged.class, listener2);
        this.attachListeners();
    }

    public void removeDataChangedListener(DataChanged listener2) {
        this.myListenerList.remove(DataChanged.class, listener2);
        if (this.myListenerList.getListenerCount() == 0) {
            this.detachListeners();
        }
    }

    private void attachListeners() {
        if (this.myDocumentListener == null) {
            this.myDocumentListener = new MyDocumentListener();
            ((EditorTextField)((Object)this.getFocusableComponent())).addDocumentListener(this.myDocumentListener);
        }
        if (this.myComboBoxItemListener == null && this.myComponent instanceof JComboBox) {
            this.myComboBoxItemListener = new MyComboBoxItemListener();
            ((JComboBox)this.myComponent).addItemListener(this.myComboBoxItemListener);
        }
    }

    private void detachListeners() {
        if (this.myDocumentListener != null) {
            ((EditorTextField)((Object)this.getFocusableComponent())).removeDocumentListener(this.myDocumentListener);
            this.myDocumentListener = null;
        }
        if (this.myComboBoxItemListener != null) {
            ((JComboBox)this.myComponent).removeItemListener(this.myComboBoxItemListener);
            this.myComboBoxItemListener = null;
        }
    }

    private void fireDataChanged() {
        Object[] list2;
        for (Object aList : list2 = this.myListenerList.getListenerList()) {
            if (!(aList instanceof DataChanged)) continue;
            ((DataChanged)aList).dataChanged();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.myComponent instanceof JComboBox) {
            return ((JComboBox)this.myComponent).getEditor().getEditorComponent().requestFocusInWindow();
        }
        return this.myComponent.requestFocusInWindow();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myComponent.setEnabled(enabled);
    }

    @Override
    public void requestFocus() {
        this.getFocusableComponent().requestFocus();
    }

    private class MyComboBoxItemListener
    implements ItemListener {
        private MyComboBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            NameSuggestionsField.this.fireDataChanged();
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (!NameSuggestionsField.this.myNonHumanChange && NameSuggestionsField.this.myComponent instanceof JComboBox && ((JComboBox)NameSuggestionsField.this.myComponent).isPopupVisible()) {
                ((JComboBox)NameSuggestionsField.this.myComponent).hidePopup();
            }
            NameSuggestionsField.this.myNonHumanChange = false;
            NameSuggestionsField.this.fireDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/ui/NameSuggestionsField$MyDocumentListener", "documentChanged"));
        }
    }

    @FunctionalInterface
    public static interface DataChanged
    extends EventListener {
        public void dataChanged();
    }

    private static class MyComboBoxModel
    extends DefaultComboBoxModel {
        private String[] mySuggestions = ArrayUtilRt.EMPTY_STRING_ARRAY;

        MyComboBoxModel() {
        }

        @Override
        public int getSize() {
            return this.mySuggestions.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.mySuggestions[index];
        }

        public void setSuggestions(String[] suggestions) {
            this.fireIntervalRemoved(this, 0, this.mySuggestions.length);
            this.mySuggestions = suggestions;
            this.fireIntervalAdded(this, 0, this.mySuggestions.length);
        }
    }
}

