/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogListener;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.runtime.log.TerminalHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class CloudLoggingHandlerImpl
implements CloudAgentLoggingHandler {
    private final HashMap<String, LogListenerImpl> myPipeName2LogListener;
    private final LoggingHandler myMainLoggingHandler;
    private final DeploymentLogManager myLogManager;

    public CloudLoggingHandlerImpl(DeploymentLogManager logManager) {
        this.myMainLoggingHandler = logManager.getMainLoggingHandler();
        this.myPipeName2LogListener = new HashMap();
        this.myLogManager = logManager;
    }

    public String getProjectHash() {
        Project project = this.myLogManager.getProject();
        return "`" + project.getName() + "`:" + project.getLocationHash();
    }

    public void println(String message) {
        this.myMainLoggingHandler.print(message + "\n");
    }

    public LogListener getOrCreateLogListener(String pipeName) {
        LogListenerImpl cached = this.myPipeName2LogListener.get(pipeName);
        if (cached != null && !cached.isClosed()) {
            return cached;
        }
        LogListenerImpl result2 = new LogListenerImpl(this.myLogManager.addAdditionalLog(pipeName));
        this.myPipeName2LogListener.put(pipeName, result2);
        return result2;
    }

    public boolean isTtySupported() {
        return this.myLogManager.isTtySupported();
    }

    public TerminalListener createTerminal(@Nls String pipeName, OutputStream terminalInput, InputStream terminalOutput, InputStream stderr) {
        final TerminalHandler terminalHandler = this.myLogManager.addTerminal(pipeName, terminalOutput, terminalInput);
        return new TerminalListener(){

            public void close() {
                if (terminalHandler != null) {
                    terminalHandler.close();
                }
            }

            public void setTtyResizeHandler(@Nullable TerminalListener.TtyResizeHandler ttyResizeHandler) {
                if (terminalHandler instanceof TerminalHandlerBase && ttyResizeHandler != null) {
                    ((TerminalHandlerBase)terminalHandler).setResizeHandler(ttyResizeHandler);
                }
            }
        };
    }

    private static class LogListenerImpl
    implements LogListener {
        private final LoggingHandler myLoggingHandler;

        LogListenerImpl(LoggingHandler loggingHandler) {
            this.myLoggingHandler = loggingHandler;
        }

        public void lineLogged(String line) {
            this.myLoggingHandler.print(line);
        }

        public void close() {
            if (this.myLoggingHandler instanceof LoggingHandlerBase) {
                ((LoggingHandlerBase)this.myLoggingHandler).close();
            }
        }

        public boolean isClosed() {
            return this.myLoggingHandler instanceof LoggingHandlerBase && ((LoggingHandlerBase)this.myLoggingHandler).isClosed();
        }

        public void clear() {
            this.myLoggingHandler.clear();
        }
    }
}

