/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.tools.ToolsBundle;
import org.jetbrains.annotations.NotNull;

public class ToolProcessAdapter
extends ProcessAdapter {
    private final Project myProject;
    private final boolean mySynchronizeAfterExecution;
    private final String myName;

    public ToolProcessAdapter(Project project, boolean synchronizeAfterExecution, String name) {
        this.myProject = project;
        this.mySynchronizeAfterExecution = synchronizeAfterExecution;
        this.myName = name;
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        StatusBar statusBar;
        if (event == null) {
            ToolProcessAdapter.$$$reportNull$$$0(0);
        }
        String message = ToolsBundle.message("tools.completed.message", this.myName, event.getExitCode());
        if (this.mySynchronizeAfterExecution) {
            ApplicationManager.getApplication().runReadAction(() -> VirtualFileManager.getInstance().asyncRefresh(() -> {
                StatusBar statusBar;
                if (ProjectManagerEx.getInstanceEx().isProjectOpened(this.myProject) && (statusBar = WindowManager.getInstance().getStatusBar(this.myProject)) != null) {
                    statusBar.setInfo(message);
                }
            }));
        }
        if (ProjectManagerEx.getInstanceEx().isProjectOpened(this.myProject) && (statusBar = WindowManager.getInstance().getStatusBar(this.myProject)) != null) {
            statusBar.setInfo(message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/tools/ToolProcessAdapter", "processTerminated"));
    }
}

