/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ProgressSlide;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.Splash;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;

final class ProgressSlidePainter {
    private static final int PREFETCH_PARALLEL_COUNT = 4;
    private static final int PREFETCH_BUFFER_SIZE = 15;
    private final List<ProgressSlide> myProgressSlides;
    private final AtomicReferenceArray<Slide> myPrefetchedSlides;
    private final AtomicInteger myPrefetchSlideIndex;
    private volatile int myNextSlideIndex;

    ProgressSlidePainter(@NotNull ApplicationInfoEx appInfo) {
        if (appInfo == null) {
            ProgressSlidePainter.$$$reportNull$$$0(0);
        }
        this.myNextSlideIndex = 0;
        this.myProgressSlides = appInfo.getProgressSlides();
        this.myProgressSlides.sort(Comparator.comparing(it -> Float.valueOf(it.progressRation)));
        this.myPrefetchedSlides = new AtomicReferenceArray(this.myProgressSlides.size());
        this.myPrefetchSlideIndex = new AtomicInteger(0);
    }

    public void startPreloading() {
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        for (int i2 = 0; i2 < 4; ++i2) {
            executorService.execute(() -> {
                int slideIndex;
                while ((slideIndex = this.myPrefetchSlideIndex.getAndIncrement()) < this.myProgressSlides.size()) {
                    while (slideIndex > this.myNextSlideIndex + 15) {
                        Thread.onSpinWait();
                    }
                    ProgressSlide slide = this.myProgressSlides.get(slideIndex);
                    Image image = Splash.doLoadImage(slide.url);
                    if (image == null) {
                        Logger.getInstance(ProgressSlidePainter.class).error("Cannot load slide by url: " + slide.url);
                        this.myPrefetchedSlides.set(slideIndex, Slide.Empty);
                        continue;
                    }
                    this.myPrefetchedSlides.compareAndSet(slideIndex, null, new Slide(slide.progressRation, image));
                }
                return;
            });
        }
    }

    public void paintSlides(@NotNull Graphics g, double currentProgress) {
        if (g == null) {
            ProgressSlidePainter.$$$reportNull$$$0(1);
        }
        while (true) {
            int index;
            if ((index = this.myNextSlideIndex) >= this.myPrefetchedSlides.length()) {
                return;
            }
            Slide newSlide = this.myPrefetchedSlides.get(index);
            if (newSlide == null || newSlide.isEmpty()) {
                if ((double)this.myProgressSlides.get((int)index).progressRation <= currentProgress) {
                    this.next(index);
                    continue;
                }
                return;
            }
            if (!(newSlide.progress <= currentProgress)) break;
            StartupUiUtil.drawImage((Graphics)g, (Image)newSlide.image, (int)0, (int)0, null);
            this.next(index);
        }
    }

    private void next(int index) {
        this.myPrefetchedSlides.set(index, Slide.Empty);
        ++this.myNextSlideIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ProgressSlidePainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "paintSlides";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Slide {
        private static final Slide Empty = new Slide(0.0, null);
        public final double progress;
        public final Image image;

        public boolean isEmpty() {
            return Empty.equals(this);
        }

        Slide(double progress2, Image image) {
            this.progress = progress2;
            this.image = image;
        }
    }
}

