/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.jdkEx.JdkEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.util.FieldAccessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.VolatileImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@ApiStatus.Experimental
public class HwFacadeHelper {
    public static final Color TRANSPARENT_COLOR = new Color(1, 1, 1, 0);
    private final JComponent myTarget;
    private JWindow myHwFacade;
    private ComponentAdapter myOwnerListener;
    private ComponentAdapter myTargetListener;
    private VolatileImage myBackBuffer;
    @NotNull
    Consumer<? super JBCefBrowser> myOnBrowserMoveResizeCallback = browser2 -> {
        if (!this.isActive()) {
            this.activateIfNeeded(Collections.singletonList(browser2.getCefBrowser()));
        }
    };

    public HwFacadeHelper(JComponent target2) {
        this.myTarget = target2;
    }

    private boolean isActive() {
        return this.myHwFacade != null;
    }

    private static boolean isCefAppActive() {
        return JCEFAccessor.getCefApp() != null && !JBCefApp.isOffScreenRenderingMode();
    }

    private void onShowing() {
        if (!HwFacadeHelper.isCefAppActive()) {
            return;
        }
        assert (this.myHwFacade == null);
        assert (this.myTarget.isVisible());
        this.myTargetListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (HwFacadeHelper.this.isActive()) {
                    HwFacadeHelper.this.myHwFacade.setSize(HwFacadeHelper.this.myTarget.getSize());
                } else {
                    HwFacadeHelper.this.activateIfNeeded(JCEFAccessor.getBrowsers());
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (HwFacadeHelper.this.isActive()) {
                    if (HwFacadeHelper.this.myHwFacade.isVisible()) {
                        HwFacadeHelper.this.myHwFacade.setLocation(HwFacadeHelper.this.myTarget.getLocationOnScreen());
                    }
                } else {
                    HwFacadeHelper.this.activateIfNeeded(JCEFAccessor.getBrowsers());
                }
            }
        };
        this.myTarget.addComponentListener(this.myTargetListener);
        this.activateIfNeeded(JCEFAccessor.getBrowsers());
    }

    private void activateIfNeeded(@NotNull List<CefBrowser> browsers) {
        if (browsers == null) {
            HwFacadeHelper.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isLinux || !HwFacadeHelper.isCefAppActive() || !this.myTarget.isShowing()) {
            return;
        }
        Rectangle targetBounds = new Rectangle(this.myTarget.getLocationOnScreen(), this.myTarget.getSize());
        boolean overlaps = false;
        for (CefBrowser browser2 : browsers) {
            Component browserComp = browser2.getUIComponent();
            if (browserComp == null || !browserComp.isVisible() || !browserComp.isShowing() || SwingUtilities.isDescendingFrom(browserComp, this.myTarget) || !new Rectangle(browserComp.getLocationOnScreen(), browserComp.getSize()).intersects(targetBounds)) continue;
            overlaps = true;
            break;
        }
        if (overlaps) {
            Window owner = SwingUtilities.getWindowAncestor(this.myTarget);
            this.myOwnerListener = new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (HwFacadeHelper.this.myTarget.isVisible()) {
                        HwFacadeHelper.this.myHwFacade.setLocation(HwFacadeHelper.this.myTarget.getLocationOnScreen());
                    }
                }
            };
            owner.addComponentListener(this.myOwnerListener);
            this.myHwFacade = new JWindow(owner);
            this.myHwFacade.add(new JPanel(){
                {
                    this.setBackground(TRANSPARENT_COLOR);
                }

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (HwFacadeHelper.this.myBackBuffer != null) {
                        g.drawImage(HwFacadeHelper.this.myBackBuffer, 0, 0, null);
                    }
                }
            });
            JdkEx.setIgnoreMouseEvents(this.myHwFacade, true);
            this.myHwFacade.setBounds(targetBounds);
            this.myHwFacade.setFocusableWindowState(false);
            this.myHwFacade.setBackground(TRANSPARENT_COLOR);
            this.myHwFacade.setVisible(true);
        }
    }

    public void addNotify() {
        if (this.myTarget.isVisible()) {
            this.onShowing();
        }
        if (!SystemInfo.isLinux) {
            JBCefBrowser.addOnBrowserMoveResizeCallback(this.myOnBrowserMoveResizeCallback);
        }
    }

    public void show() {
        if (!HwFacadeHelper.isCefAppActive()) {
            return;
        }
        if (AWTAccessor.getComponentAccessor().getPeer(this.myTarget) != null) {
            if (this.isActive()) {
                this.myHwFacade.setVisible(true);
            } else {
                this.onShowing();
            }
        }
    }

    public void removeNotify() {
        if (this.isActive()) {
            this.myHwFacade.dispose();
            this.myHwFacade = null;
            this.myBackBuffer = null;
            this.myTarget.removeComponentListener(this.myTargetListener);
            Window owner = SwingUtilities.getWindowAncestor(this.myTarget);
            assert (owner != null);
            owner.removeComponentListener(this.myOwnerListener);
        }
        if (!SystemInfo.isLinux) {
            JBCefBrowser.removeOnBrowserMoveResizeCallback(this.myOnBrowserMoveResizeCallback);
        }
    }

    public void hide() {
        if (this.isActive()) {
            this.myHwFacade.setVisible(false);
        }
    }

    public void paint(Graphics g, Consumer<? super Graphics> targetPaint) {
        if (this.isActive()) {
            Dimension size = this.myTarget.getSize();
            if (this.myBackBuffer == null || this.myBackBuffer.getWidth() != size.width || this.myBackBuffer.getHeight() != size.height) {
                this.myBackBuffer = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleVolatileImage(size.width, size.height, 3);
            }
            Graphics2D bbGraphics = (Graphics2D)this.myBackBuffer.getGraphics();
            bbGraphics.setBackground(TRANSPARENT_COLOR);
            bbGraphics.clearRect(0, 0, size.width, size.height);
            targetPaint.accept(bbGraphics);
            this.myHwFacade.repaint();
        } else {
            targetPaint.accept(g);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browsers", "com/intellij/ui/jcef/HwFacadeHelper", "activateIfNeeded"));
    }

    private static final class JCEFAccessor {
        private static FieldAccessor<CefApp, HashSet<CefClient>> clientsField;
        private static FieldAccessor<CefClient, HashMap<Integer, CefBrowser>> browsersField;
        private static CefApp ourCefApp;

        private JCEFAccessor() {
        }

        @Nullable
        public static CefApp getCefApp() {
            if (ourCefApp == null && CefApp.getState() != CefApp.CefAppState.NONE) {
                ourCefApp = CefApp.getInstance();
                clientsField = new FieldAccessor(CefApp.class, "clients_");
                browsersField = new FieldAccessor(CefClient.class, "browser_");
            }
            return ourCefApp;
        }

        @NotNull
        public static List<CefBrowser> getBrowsers() {
            Set clients;
            LinkedList<CefBrowser> list2 = new LinkedList<CefBrowser>();
            if (JCEFAccessor.getCefApp() != null && clientsField.isAvailable() && browsersField.isAvailable() && (clients = (Set)clientsField.get((Object)ourCefApp)) != null) {
                for (CefClient client : clients) {
                    HashMap browsers = (HashMap)browsersField.get((Object)client);
                    if (browsers == null) continue;
                    list2.addAll(browsers.values());
                }
            }
            LinkedList<CefBrowser> linkedList = list2;
            if (linkedList == null) {
                JCEFAccessor.$$$reportNull$$$0(0);
            }
            return linkedList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/jcef/HwFacadeHelper$JCEFAccessor", "getBrowsers"));
        }
    }
}

