/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.dto.JsonIndexDiagnostic;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001/B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u00128BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0016\u001a\n \b*\u0004\u0018\u00010\u00170\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001e8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010\u0002\u001a\u0004\b \u0010!R$\u0010\"\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b#\u0010\u0002\u001a\u0004\b$\u0010!\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u001e8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010\u0002\u001a\u0004\b)\u0010!\u00a8\u00060"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "diagnosticDateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "fileNamePrefix", "", "indexingDiagnosticDir", "Ljava/nio/file/Path;", "getIndexingDiagnosticDir", "()Ljava/nio/file/Path;", "indexingDiagnosticDir$delegate", "Lkotlin/Lazy;", "indexingDiagnosticsLimitOfFiles", "", "getIndexingDiagnosticsLimitOfFiles$annotations", "getIndexingDiagnosticsLimitOfFiles", "()I", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectWriter;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectWriter;", "jacksonMapper$delegate", "lastTime", "Ljava/time/LocalDateTime;", "shouldDumpDiagnosticsForInterruptedUpdaters", "", "getShouldDumpDiagnosticsForInterruptedUpdaters$annotations", "getShouldDumpDiagnosticsForInterruptedUpdaters", "()Z", "shouldDumpInUnitTestMode", "getShouldDumpInUnitTestMode$annotations", "getShouldDumpInUnitTestMode", "setShouldDumpInUnitTestMode", "(Z)V", "shouldDumpPathsOfIndexedFiles", "getShouldDumpPathsOfIndexedFiles$annotations", "getShouldDumpPathsOfIndexedFiles", "dumpProjectIndexingHistoryIfNecessary", "", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "dumpProjectIndexingHistoryToLogSubdirectory", "ProjectIndexingHistoryListener", "intellij.platform.lang.impl"})
public final class IndexDiagnosticDumper {
    @TestOnly
    private static boolean shouldDumpInUnitTestMode;
    @NotNull
    private static final Lazy indexingDiagnosticDir$delegate;
    private static final Logger LOG;
    private static final Lazy jacksonMapper$delegate;
    private static final DateTimeFormatter diagnosticDateTimeFormatter;
    private static final String fileNamePrefix = "diagnostic-";
    private static LocalDateTime lastTime;
    public static final IndexDiagnosticDumper INSTANCE;

    @JvmStatic
    private static /* synthetic */ void getShouldDumpDiagnosticsForInterruptedUpdaters$annotations() {
    }

    private static final boolean getShouldDumpDiagnosticsForInterruptedUpdaters() {
        return SystemProperties.getBooleanProperty((String)"intellij.indexes.diagnostics.should.dump.for.interrupted.index.updaters", (boolean)false);
    }

    @JvmStatic
    private static /* synthetic */ void getIndexingDiagnosticsLimitOfFiles$annotations() {
    }

    private static final int getIndexingDiagnosticsLimitOfFiles() {
        return SystemProperties.getIntProperty((String)"intellij.indexes.diagnostics.limit.of.files", (int)20);
    }

    @JvmStatic
    public static /* synthetic */ void getShouldDumpPathsOfIndexedFiles$annotations() {
    }

    public static final boolean getShouldDumpPathsOfIndexedFiles() {
        return SystemProperties.getBooleanProperty((String)"intellij.indexes.diagnostics.should.dump.paths.of.indexed.files", (boolean)false);
    }

    @JvmStatic
    public static /* synthetic */ void getShouldDumpInUnitTestMode$annotations() {
    }

    public static final boolean getShouldDumpInUnitTestMode() {
        return shouldDumpInUnitTestMode;
    }

    public static final void setShouldDumpInUnitTestMode(boolean bl) {
        shouldDumpInUnitTestMode = bl;
    }

    @NotNull
    public final Path getIndexingDiagnosticDir() {
        Lazy lazy = indexingDiagnosticDir$delegate;
        IndexDiagnosticDumper indexDiagnosticDumper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Path)lazy.getValue();
    }

    private final ObjectWriter getJacksonMapper() {
        Lazy lazy = jacksonMapper$delegate;
        IndexDiagnosticDumper indexDiagnosticDumper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectWriter)lazy.getValue();
    }

    public final void dumpProjectIndexingHistoryIfNecessary(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        ProjectIndexingHistoryListener.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new Consumer<ProjectIndexingHistoryListener>(projectIndexingHistory){
            final /* synthetic */ ProjectIndexingHistory $projectIndexingHistory;

            public final void accept(ProjectIndexingHistoryListener it) {
                it.onFinishedIndexing(this.$projectIndexingHistory);
            }
            {
                this.$projectIndexingHistory = projectIndexingHistory;
            }
        });
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode() && !shouldDumpInUnitTestMode) {
            return;
        }
        if (projectIndexingHistory.getTimes().getWasInterrupted() && !IndexDiagnosticDumper.getShouldDumpDiagnosticsForInterruptedUpdaters()) {
            return;
        }
        NonUrgentExecutor.getInstance().execute(new Runnable(projectIndexingHistory){
            final /* synthetic */ ProjectIndexingHistory $projectIndexingHistory;

            public final void run() {
                IndexDiagnosticDumper.access$dumpProjectIndexingHistoryToLogSubdirectory(IndexDiagnosticDumper.INSTANCE, this.$projectIndexingHistory);
            }
            {
                this.$projectIndexingHistory = projectIndexingHistory;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void dumpProjectIndexingHistoryToLogSubdirectory(ProjectIndexingHistory projectIndexingHistory) {
        try {
            Object files22;
            Path indexDiagnosticDirectory = ProjectUtil.getProjectCachePath$default((Project)projectIndexingHistory.getProject(), (Path)this.getIndexingDiagnosticDir(), (boolean)false, null, (int)6, null);
            PathKt.createDirectories((Path)indexDiagnosticDirectory);
            LocalDateTime nowTime = LocalDateTime.now();
            if (Intrinsics.areEqual((Object)lastTime, (Object)nowTime)) {
                LocalDateTime localDateTime = nowTime = nowTime.plusNanos(TimeUnit.MILLISECONDS.toNanos(1L));
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"nowTime");
                lastTime = localDateTime;
            }
            String timestamp = nowTime.format(diagnosticDateTimeFormatter);
            Path diagnosticJson = indexDiagnosticDirectory.resolve(fileNamePrefix + timestamp + ".json");
            JsonIndexDiagnostic jsonIndexDiagnostic = JsonIndexDiagnostic.Companion.generateForHistory(projectIndexingHistory);
            this.getJacksonMapper().writeValue(diagnosticJson.toFile(), (Object)jsonIndexDiagnostic);
            int limitOfHistories = IndexDiagnosticDumper.getIndexingDiagnosticsLimitOfFiles();
            AutoCloseable autoCloseable = Files.list(indexDiagnosticDirectory);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                files22 = (Stream)autoCloseable;
                boolean bl3 = false;
                Stream stream = files22;
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"files");
                Sequence $this$sortedByDescending$iv = SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)dumpProjectIndexingHistoryToLogSubdirectory.survivedHistories.1.1.INSTANCE);
                boolean $i$f$sortedByDescending = false;
                boolean bl4 = false;
                files22 = SequencesKt.toSet((Sequence)SequencesKt.take((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        LocalDateTime localDateTime;
                        boolean bl = false;
                        Path file2 = (Path)b;
                        boolean bl2 = false;
                        Path path = file2;
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                        String timeStamp = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)((Object)path.getFileName()).toString(), (String)"diagnostic-", null, (int)2, null), (String)".json", null, (int)2, null);
                        try {
                            localDateTime = LocalDateTime.parse(timeStamp, IndexDiagnosticDumper.access$getDiagnosticDateTimeFormatter$p(IndexDiagnosticDumper.INSTANCE));
                        }
                        catch (DateTimeParseException e) {
                            localDateTime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
                        }
                        file2 = (Path)a;
                        Comparable comparable = localDateTime;
                        bl2 = false;
                        Path path2 = file2;
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
                        timeStamp = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)((Object)path2.getFileName()).toString(), (String)"diagnostic-", null, (int)2, null), (String)".json", null, (int)2, null);
                        try {
                            localDateTime = LocalDateTime.parse(timeStamp, IndexDiagnosticDumper.access$getDiagnosticDateTimeFormatter$p(IndexDiagnosticDumper.INSTANCE));
                        }
                        catch (DateTimeParseException e) {
                            localDateTime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
                        }
                        LocalDateTime localDateTime2 = localDateTime;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)localDateTime2);
                    }
                }), (int)limitOfHistories));
            }
            catch (Throwable files22) {
                throwable = files22;
                throw files22;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Object survivedHistories2 = files22;
            autoCloseable = Files.list(indexDiagnosticDirectory);
            bl = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                files22 = (Stream)autoCloseable;
                boolean bl6 = false;
                Object object = files22;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"files");
                Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)StreamsKt.asSequence((Stream)object), (Function1)((Function1)new Function1<Path, Boolean>((Set)survivedHistories2){
                    final /* synthetic */ Set $survivedHistories$inlined;
                    {
                        this.$survivedHistories$inlined = set2;
                        super(1);
                    }

                    public final boolean invoke(Path it) {
                        return this.$survivedHistories$inlined.contains(it);
                    }
                })), (Function1)dumpProjectIndexingHistoryToLogSubdirectory.1.2.INSTANCE);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl7 = false;
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to dump index diagnostic", (Throwable)e);
        }
    }

    private IndexDiagnosticDumper() {
    }

    static {
        IndexDiagnosticDumper indexDiagnosticDumper;
        INSTANCE = indexDiagnosticDumper = new IndexDiagnosticDumper();
        indexingDiagnosticDir$delegate = LazyKt.lazy((Function0)indexingDiagnosticDir.2.INSTANCE);
        Logger logger = Logger.getInstance(IndexDiagnosticDumper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Index\u2026nosticDumper::class.java)");
        LOG = logger;
        jacksonMapper$delegate = LazyKt.lazy((Function0)jacksonMapper.2.INSTANCE);
        diagnosticDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS");
        LocalDateTime localDateTime = LocalDateTime.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.MIN");
        lastTime = localDateTime;
    }

    public static final /* synthetic */ void access$dumpProjectIndexingHistoryToLogSubdirectory(IndexDiagnosticDumper $this, ProjectIndexingHistory projectIndexingHistory) {
        $this.dumpProjectIndexingHistoryToLogSubdirectory(projectIndexingHistory);
    }

    public static final /* synthetic */ DateTimeFormatter access$getDiagnosticDateTimeFormatter$p(IndexDiagnosticDumper $this) {
        IndexDiagnosticDumper indexDiagnosticDumper = $this;
        return diagnosticDateTimeFormatter;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener;", "", "onFinishedIndexing", "", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "Companion", "intellij.platform.lang.impl"})
    public static interface ProjectIndexingHistoryListener {
        public static final Companion Companion = Companion.$$INSTANCE;

        public void onFinishedIndexing(@NotNull ProjectIndexingHistory var1);

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ProjectIndexingHistoryListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.platform.lang.impl"})
        public static final class Companion {
            @NotNull
            private static final ExtensionPointName<ProjectIndexingHistoryListener> EP_NAME;
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final ExtensionPointName<ProjectIndexingHistoryListener> getEP_NAME() {
                return EP_NAME;
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
                ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.projectIndexingHistoryListener");
                Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026IndexingHistoryListener\")");
                EP_NAME = extensionPointName;
            }
        }
    }
}

