/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBus;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelPreUpdateHandler;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelCacheImpl;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelInitialTestContent;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.impl.VersionedEntityStorageImpl;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J'\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u001f0!H\u0016\u00a2\u0006\u0002\u0010\"J'\u0010#\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u001f0!H\u0016\u00a2\u0006\u0002\u0010\"R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl;", "Lcom/intellij/workspaceModel/ide/WorkspaceModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelCacheImpl;", "cacheEnabled", "", "cacheEnabled$1", "entityStorage", "Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "getEntityStorage", "()Lcom/intellij/workspaceModel/storage/impl/VersionedEntityStorageImpl;", "<set-?>", "loadedFromCache", "getLoadedFromCache", "()Z", "dispose", "", "onBeforeChanged", "change", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "onChanged", "startPreUpdateHandlers", "before", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "updateProjectModel", "R", "updater", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateProjectModelSilent", "Companion", "intellij.platform.ide.impl"})
public final class WorkspaceModelImpl
implements WorkspaceModel,
Disposable {
    private final boolean cacheEnabled$1;
    private final WorkspaceModelCacheImpl cache;
    private volatile boolean loadedFromCache;
    @NotNull
    private final VersionedEntityStorageImpl entityStorage;
    private final Project project;
    private static final Logger log;
    @NotNull
    public static final String ENABLED_CACHE_KEY = "ide.new.project.model.cache";
    private static boolean forceEnableCaching;
    private static final boolean cacheEnabled;
    private static final ExtensionPointName<WorkspaceModelPreUpdateHandler> PRE_UPDATE_HANDLERS;
    private static final int PRE_UPDATE_LOOP_BLOCK = 100;
    public static final Companion Companion;

    public final boolean getLoadedFromCache() {
        return this.loadedFromCache;
    }

    @Override
    @NotNull
    public VersionedEntityStorageImpl getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public <R> R updateProjectModel(@NotNull Function1<? super WorkspaceEntityStorageBuilder, ? extends R> updater) {
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        WorkspaceEntityStorage before = this.getEntityStorage().getCurrent();
        WorkspaceEntityStorageBuilder builder2 = WorkspaceEntityStorageBuilder.Companion.from(before);
        Object result2 = updater.invoke((Object)builder2);
        this.startPreUpdateHandlers(before, builder2);
        Map<Class<?>, List<EntityChange<?>>> changes = builder2.collectChanges(before);
        this.getEntityStorage().replace(builder2.toStorage(), changes, (Function1<? super VersionedStorageChange, Unit>)((Function1)new Function1<VersionedStorageChange, Unit>(this){

            public final void invoke(@NotNull VersionedStorageChange p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WorkspaceModelImpl.access$onBeforeChanged((WorkspaceModelImpl)this.receiver, p1);
            }
        }), (Function1<? super VersionedStorageChange, Unit>)((Function1)new Function1<VersionedStorageChange, Unit>(this){

            public final void invoke(@NotNull VersionedStorageChange p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                WorkspaceModelImpl.access$onChanged((WorkspaceModelImpl)this.receiver, p1);
            }
        }));
        return (R)result2;
    }

    @Override
    public <R> R updateProjectModelSilent(@NotNull Function1<? super WorkspaceEntityStorageBuilder, ? extends R> updater) {
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        WorkspaceEntityStorageBuilder builder2 = WorkspaceEntityStorageBuilder.Companion.from(this.getEntityStorage().getCurrent());
        Object result2 = updater.invoke((Object)builder2);
        this.getEntityStorage().replaceSilently(builder2.toStorage());
        return (R)result2;
    }

    public void dispose() {
    }

    private final void onBeforeChanged(VersionedStorageChange change) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"project.messageBus");
        workspaceModelTopics.syncPublisher(messageBus).beforeChanged(change);
    }

    private final void onChanged(VersionedStorageChange change) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.project.isDisposed()) {
            return;
        }
        WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"project.messageBus");
        workspaceModelTopics.syncPublisher(messageBus).changed(change);
    }

    /*
     * WARNING - void declaration
     */
    private final void startPreUpdateHandlers(WorkspaceEntityStorage before, WorkspaceEntityStorageBuilder builder2) {
        void startUpdateLoop;
        int updatesStarted;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        for (updatesStarted = 0; startUpdateLoop.element && updatesStarted < 100; ++updatesStarted) {
            startUpdateLoop.element = false;
            PRE_UPDATE_HANDLERS.extensions().forEach((Consumer)new Consumer<WorkspaceModelPreUpdateHandler>((Ref.BooleanRef)startUpdateLoop, before, builder2){
                final /* synthetic */ Ref.BooleanRef $startUpdateLoop;
                final /* synthetic */ WorkspaceEntityStorage $before;
                final /* synthetic */ WorkspaceEntityStorageBuilder $builder;

                public final void accept(WorkspaceModelPreUpdateHandler it) {
                    this.$startUpdateLoop.element |= it.update(this.$before, this.$builder);
                }
                {
                    this.$startUpdateLoop = booleanRef;
                    this.$before = workspaceEntityStorage;
                    this.$builder = workspaceEntityStorageBuilder;
                }
            });
        }
        if (updatesStarted >= 100) {
            log.error("Loop workspace model updating");
        }
    }

    public WorkspaceModelImpl(@NotNull Project project) {
        WorkspaceEntityStorage workspaceEntityStorage;
        WorkspaceEntityStorage projectEntities;
        WorkspaceEntityStorage workspaceEntityStorage2;
        WorkspaceEntityStorage workspaceEntityStorage3;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        this.cacheEnabled$1 = !application.isUnitTestMode() && cacheEnabled || forceEnableCaching;
        this.cache = this.cacheEnabled$1 ? new WorkspaceModelCacheImpl(this.project, this) : null;
        Logger $this$debug$iv = log;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Loading workspace model";
            logger.debug(string, (Throwable)e$iv);
        }
        WorkspaceEntityStorage initialContent = WorkspaceModelInitialTestContent.INSTANCE.pop$intellij_platform_ide_impl();
        if (initialContent != null) {
            workspaceEntityStorage3 = initialContent;
        } else if (this.cache != null) {
            WorkspaceEntityStorage workspaceEntityStorage4;
            Activity activity = StartUpMeasurer.startActivity((String)"(wm) Loading cache");
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startAct\u2026ity(\"(wm) Loading cache\")");
            Activity activity2 = activity;
            WorkspaceEntityStorage previousStorage = null;
            boolean $i$f$measureTimeMillis = false;
            boolean bl = false;
            long start$iv = System.currentTimeMillis();
            boolean bl2 = false;
            previousStorage = this.cache.loadCache();
            long loadingCacheTime = System.currentTimeMillis() - start$iv;
            if (previousStorage != null) {
                log.info("Load workspace model from cache in " + loadingCacheTime + " ms");
                this.loadedFromCache = true;
                workspaceEntityStorage4 = previousStorage;
            } else {
                workspaceEntityStorage4 = WorkspaceEntityStorageBuilder.Companion.create();
            }
            WorkspaceEntityStorage storage = workspaceEntityStorage4;
            activity2.end();
            workspaceEntityStorage3 = storage;
        } else {
            workspaceEntityStorage3 = WorkspaceEntityStorageBuilder.Companion.create();
        }
        if (!((workspaceEntityStorage2 = (projectEntities = workspaceEntityStorage3)) instanceof WorkspaceEntityStorageBuilder)) {
            workspaceEntityStorage2 = null;
        }
        if ((workspaceEntityStorage = (WorkspaceEntityStorageBuilder)workspaceEntityStorage2) == null || (workspaceEntityStorage = workspaceEntityStorage.toStorage()) == null) {
            workspaceEntityStorage = projectEntities;
        }
        this.entityStorage = new VersionedEntityStorageImpl(workspaceEntityStorage);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceModelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
        cacheEnabled = Registry.is((String)ENABLED_CACHE_KEY);
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)"com.intellij.workspaceModel.preUpdateHandler");
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"ExtensionPointName.creat\u2026eModel.preUpdateHandler\")");
        PRE_UPDATE_HANDLERS = extensionPointName;
    }

    public static final /* synthetic */ void access$onBeforeChanged(WorkspaceModelImpl $this, VersionedStorageChange change) {
        $this.onBeforeChanged(change);
    }

    public static final /* synthetic */ void access$onChanged(WorkspaceModelImpl $this, VersionedStorageChange change) {
        $this.onChanged(change);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl$Companion;", "", "()V", "ENABLED_CACHE_KEY", "", "PRE_UPDATE_HANDLERS", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelPreUpdateHandler;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "PRE_UPDATE_LOOP_BLOCK", "", "cacheEnabled", "", "getCacheEnabled", "()Z", "forceEnableCaching", "getForceEnableCaching", "setForceEnableCaching", "(Z)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        public final boolean getForceEnableCaching() {
            return forceEnableCaching;
        }

        public final void setForceEnableCaching(boolean bl) {
            forceEnableCaching = bl;
        }

        public final boolean getCacheEnabled() {
            return cacheEnabled;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

