/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"levelToLibraryTableId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryTableId;", "level", "", "loadStorageFile", "", "Lorg/jdom/Element;", "xmlFile", "Ljava/nio/file/Path;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "intellij.platform.workspaceModel.ide"})
public final class JpsProjectEntitiesLoaderKt {
    @NotNull
    public static final Map<String, Element> loadStorageFile(@NotNull Path xmlFile, @NotNull PathMacroManager pathMacroManager) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)pathMacroManager, (String)"pathMacroManager");
        Element element2 = JDOMUtil.load((Path)xmlFile);
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"JDOMUtil.load(xmlFile)");
        Element rootElement = element2;
        if (Strings.endsWith((CharSequence)((Object)xmlFile).toString(), (CharSequence)".iml")) {
            Iterator iterator2;
            Element optionElement = new Element("component").setAttribute("name", "DeprecatedModuleOptionManager");
            Iterator iterator3 = iterator2 = rootElement.getAttributes().iterator();
            boolean bl = false;
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Attribute attribute;
                Attribute attribute2 = attribute = (Attribute)iterator4.next();
                Intrinsics.checkNotNullExpressionValue((Object)attribute2, (String)"attribute");
                if (!(Intrinsics.areEqual((Object)attribute2.getName(), (Object)"version") ^ true)) continue;
                iterator2.remove();
                optionElement.addContent(new Element("option").setAttribute("key", attribute.getName()).setAttribute("value", attribute.getValue()));
            }
            rootElement.addContent(optionElement);
        }
        Map<String, Element> map2 = FileStorageCoreUtil.load(rootElement, pathMacroManager, true);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"FileStorageCoreUtil.load\u2026, pathMacroManager, true)");
        return map2;
    }

    @NotNull
    public static final LibraryTableId levelToLibraryTableId(@NotNull String level) {
        LibraryTableId libraryTableId;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        switch (level) {
            case "module": {
                String string = "this method isn't supposed to be used for module-level libraries";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case "project": {
                libraryTableId = LibraryTableId.ProjectLibraryTableId.INSTANCE;
                break;
            }
            default: {
                libraryTableId = new LibraryTableId.GlobalLibraryTableId(level);
            }
        }
        return libraryTableId;
    }
}

