/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.impl.ModuleManagerEx;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.ProjectKt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.JpsEntitySourcesKt;
import com.intellij.workspaceModel.ide.JpsImportedEntitySource;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocation;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import com.intellij.workspaceModel.ide.impl.StartupMeasurerHelperKt;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelInitialTestContent;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ErrorReporter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.IdeErrorReporter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsConfigurationFilesChange;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentReaderWithCache;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentWriter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileEntitiesSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectEntitiesLoader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectModelSynchronizer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectModelSynchronizer$reloadProjectEntities$3$$special$;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializers;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializersImpl;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ProjectStoreWithJpsContentReader;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleId;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002J'\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000eH\u0002J\b\u0010!\u001a\u00020\u0017H\u0007J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u0017H\u0002J\u0006\u0010%\u001a\u00020\u0017J\u000e\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u0011 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsProjectModelSynchronizer;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileContentReader", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentReaderWithCache;", "incomingChanges", "", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsConfigurationFilesChange;", "kotlin.jvm.PlatformType", "", "serializers", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsProjectSerializers;", "sourcesToSave", "", "Lcom/intellij/workspaceModel/storage/EntitySource;", "", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "combineChanges", "dispose", "", "getAndResetIncomingChanges", "loadAndReportErrors", "T", "action", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/ErrorReporter;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "loadRealProject", "loadStateOfUnloadedModules", "markAllEntitiesAsDirty", "needToReloadProjectEntities", "", "registerListener", "reloadProjectEntities", "saveChangedProjectEntities", "writer", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentWriter;", "Companion", "intellij.platform.ide.impl"})
public final class JpsProjectModelSynchronizer
implements Disposable {
    private final List<JpsConfigurationFilesChange> incomingChanges;
    private final VirtualFileUrlManager virtualFileManager;
    private JpsFileContentReaderWithCache fileContentReader;
    private final AtomicReference<JpsProjectSerializers> serializers;
    private final Set<EntitySource> sourcesToSave;
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean needToReloadProjectEntities() {
        if (StoreReloadManager.Companion.getInstance().isReloadBlocked()) {
            return false;
        }
        if (this.serializers.get() == null) {
            return false;
        }
        List<JpsConfigurationFilesChange> list2 = this.incomingChanges;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"incomingChanges");
        List<JpsConfigurationFilesChange> list3 = list2;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list3) {
            boolean bl3 = false;
            List<JpsConfigurationFilesChange> list4 = this.incomingChanges;
            Intrinsics.checkNotNullExpressionValue(list4, (String)"incomingChanges");
            Collection collection = list4;
            boolean bl4 = false;
            boolean bl5 = !collection.isEmpty();
            return bl5;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reloadProjectEntities() {
        void changedSources;
        if (StoreReloadManager.Companion.getInstance().isReloadBlocked()) {
            LOG.debug("Skip reloading because it's blocked");
            return;
        }
        JpsProjectSerializers serializers = this.serializers.get();
        if (serializers == null) {
            LOG.debug("Skip reloading because initial loading wasn't performed yet");
            return;
        }
        JpsConfigurationFilesChange changes = this.getAndResetIncomingChanges();
        if (changes == null) {
            LOG.debug("Skip reloading because there are no changed files");
            return;
        }
        Object $this$debug$iv = LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Reload entities from changed files:\n" + changes;
            logger.debug(string, (Throwable)e$iv);
        }
        Pair pair = (Pair)this.loadAndReportErrors((Function1)new Function1<ErrorReporter, Pair<? extends Set<? extends EntitySource>, ? extends WorkspaceEntityStorageBuilder>>(this, serializers, changes){
            final /* synthetic */ JpsProjectModelSynchronizer this$0;
            final /* synthetic */ JpsProjectSerializers $serializers;
            final /* synthetic */ JpsConfigurationFilesChange $changes;

            @NotNull
            public final Pair<Set<EntitySource>, WorkspaceEntityStorageBuilder> invoke(@NotNull ErrorReporter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$serializers.reloadFromChangedFiles(this.$changes, JpsProjectModelSynchronizer.access$getFileContentReader$p(this.this$0), it);
            }
            {
                this.this$0 = jpsProjectModelSynchronizer;
                this.$serializers = jpsProjectSerializers;
                this.$changes = jpsConfigurationFilesChange;
                super(1);
            }
        });
        $this$debug$iv = (Set)pair.component1();
        WorkspaceEntityStorageBuilder builder2 = (WorkspaceEntityStorageBuilder)pair.component2();
        JpsFileContentReaderWithCache jpsFileContentReaderWithCache = this.fileContentReader;
        if (jpsFileContentReaderWithCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileContentReader");
        }
        jpsFileContentReaderWithCache.clearCache();
        LOG.debugValues("Changed entity sources", (Collection)changedSources);
        if (changedSources.isEmpty() && builder2.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this, (Set)changedSources, builder2){
            final /* synthetic */ JpsProjectModelSynchronizer this$0;
            final /* synthetic */ Set $changedSources;
            final /* synthetic */ WorkspaceEntityStorageBuilder $builder;

            public final void run() {
                boolean $i$f$runWriteAction = false;
                ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                    final /* synthetic */ reloadProjectEntities.3 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        WorkspaceModel.Companion.getInstance(JpsProjectModelSynchronizer.access$getProject$p(this.this$0.this$0)).updateProjectModel((Function1)new Function1<WorkspaceEntityStorageBuilder, Unit>(this){
                            final /* synthetic */ reloadProjectEntities$3$$special$$inlined$runWriteAction$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull WorkspaceEntityStorageBuilder updater) {
                                Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                                updater.replaceBySource((Function1<? super EntitySource, Boolean>)((Function1)new Function1<EntitySource, Boolean>(this){
                                    final /* synthetic */ reloadProjectEntities$3$$special$$inlined$runWriteAction$1$lambda$1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }

                                    public final boolean invoke(@NotNull EntitySource it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        return this.this$0.this$0.this$0.$changedSources.contains(it) || it instanceof JpsImportedEntitySource && !((JpsImportedEntitySource)it).getStoredExternally() && this.this$0.this$0.this$0.$changedSources.contains(((JpsImportedEntitySource)it).getInternalFile());
                                    }
                                }), this.this$0.this$0.$builder.toStorage());
                            }
                        });
                        JpsProjectModelSynchronizer.access$getSourcesToSave$p(this.this$0.this$0).removeAll(this.this$0.$changedSources);
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = jpsProjectModelSynchronizer;
                this.$changedSources = set2;
                this.$builder = workspaceEntityStorageBuilder;
            }
        });
    }

    private final <T> T loadAndReportErrors(Function1<? super ErrorReporter, ? extends T> action2) {
        IdeErrorReporter reporter = new IdeErrorReporter(this.project);
        Object result2 = action2.invoke((Object)reporter);
        ArrayList<ConfigurationErrorDescription> errors = reporter.getErrors();
        Collection collection = errors;
        boolean bl = false;
        if (!collection.isEmpty()) {
            ProjectLoadingErrorsNotifier.getInstance(this.project).registerErrors((Collection<? extends ConfigurationErrorDescription>)errors);
        }
        return (T)result2;
    }

    private final void registerListener() {
        registerListener.1 $fun$isParentOfStorageFiles$1 = registerListener.1.INSTANCE;
        registerListener.2 $fun$isStorageFile$2 = registerListener.2.INSTANCE;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(this){
            final /* synthetic */ JpsProjectModelSynchronizer this$0;

            public void after(@NotNull List<? extends VFileEvent> events) {
                block8: {
                    ArrayList<String> changedUrls;
                    ArrayList<String> removedUrls;
                    ArrayList<String> addedUrls;
                    block7: {
                        Intrinsics.checkNotNullParameter(events, (String)"events");
                        addedUrls = new ArrayList<String>();
                        removedUrls = new ArrayList<String>();
                        changedUrls = new ArrayList<String>();
                        for (VFileEvent vFileEvent : events) {
                            if (!StateStorageManagerKt.isFireStorageFileChangedEvent(vFileEvent)) continue;
                            VFileEvent vFileEvent2 = vFileEvent;
                            if (vFileEvent2 instanceof VFileCreateEvent) {
                                String fileName;
                                Intrinsics.checkNotNullExpressionValue((Object)((VFileCreateEvent)vFileEvent).getChildName(), (String)"event.childName");
                                if (!FileUtilRt.extensionEquals((String)fileName, (String)"iml") || ((VFileCreateEvent)vFileEvent).isDirectory()) {
                                    VirtualFile virtualFile = ((VFileCreateEvent)vFileEvent).getParent();
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.parent");
                                    if (!registerListener.1.INSTANCE.invoke(virtualFile) || ((VFileCreateEvent)vFileEvent).isEmptyDirectory()) continue;
                                }
                                addedUrls.add(JpsPathUtil.pathToUrl((String)((VFileCreateEvent)vFileEvent).getPath()));
                                continue;
                            }
                            if (vFileEvent2 instanceof VFileDeleteEvent) {
                                VirtualFile virtualFile = ((VFileDeleteEvent)vFileEvent).getFile();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                                if (!registerListener.2.INSTANCE.invoke(virtualFile)) continue;
                                removedUrls.add(JpsPathUtil.pathToUrl((String)((VFileDeleteEvent)vFileEvent).getPath()));
                                continue;
                            }
                            if (!(vFileEvent2 instanceof VFileContentChangeEvent)) continue;
                            VirtualFile virtualFile = ((VFileContentChangeEvent)vFileEvent).getFile();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                            if (!registerListener.2.INSTANCE.invoke(virtualFile)) continue;
                            changedUrls.add(JpsPathUtil.pathToUrl((String)((VFileContentChangeEvent)vFileEvent).getPath()));
                        }
                        Collection collection = addedUrls;
                        boolean bl = false;
                        if (!collection.isEmpty()) break block7;
                        Collection collection2 = removedUrls;
                        bl = false;
                        if (!collection2.isEmpty()) break block7;
                        Collection collection3 = changedUrls;
                        bl = false;
                        if (!(!collection3.isEmpty())) break block8;
                    }
                    JpsConfigurationFilesChange jpsConfigurationFilesChange = new JpsConfigurationFilesChange((Collection<String>)addedUrls, (Collection<String>)removedUrls, (Collection<String>)changedUrls);
                    JpsProjectModelSynchronizer.access$getIncomingChanges$p(this.this$0).add(jpsConfigurationFilesChange);
                    StoreReloadManager.Companion.getInstance().scheduleProcessingChangedFiles();
                }
            }
            {
                this.this$0 = this$0;
            }
        });
        WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        workspaceModelTopics.subscribeImmediately(messageBusConnection, new WorkspaceModelChangeListener(this){
            final /* synthetic */ JpsProjectModelSynchronizer this$0;

            public void changed(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                JpsProjectModelSynchronizer.access$getLOG$cp().debug("Marking changed entities for save");
                Sequence<EntityChange<?>> $this$forEach$iv = event.getAllChanges();
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    EntityChange it = (EntityChange)element$iv;
                    boolean bl = false;
                    EntityChange entityChange = it;
                    if (entityChange instanceof EntityChange.Added) {
                        JpsProjectModelSynchronizer.access$getSourcesToSave$p(this.this$0).add(((EntityChange.Added)it).getEntity().getEntitySource());
                        continue;
                    }
                    if (entityChange instanceof EntityChange.Removed) {
                        JpsProjectModelSynchronizer.access$getSourcesToSave$p(this.this$0).add(((EntityChange.Removed)it).getEntity().getEntitySource());
                        continue;
                    }
                    if (!(entityChange instanceof EntityChange.Replaced)) continue;
                    JpsProjectModelSynchronizer.access$getSourcesToSave$p(this.this$0).add(((EntityChange.Replaced)it).getOldEntity().getEntitySource());
                    JpsProjectModelSynchronizer.access$getSourcesToSave$p(this.this$0).add(((EntityChange.Replaced)it).getNewEntity().getEntitySource());
                }
            }
            {
                this.this$0 = this$0;
            }

            public void beforeChanged(@NotNull VersionedStorageChange event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                WorkspaceModelChangeListener.DefaultImpls.beforeChanged(this, event);
            }
        });
        this.project.getMessageBus().connect().subscribe(VirtualFilePointerListener.TOPIC, (Object)new VirtualFilePointerListener(this){
            final /* synthetic */ JpsProjectModelSynchronizer this$0;

            public void beforeUrlChanged(@NotNull VirtualFilePointer[] pointers) {
                Intrinsics.checkNotNullParameter((Object)pointers, (String)"pointers");
                VirtualFileUrlIndex virtualFileUrlIndex = WorkspaceModel.Companion.getInstance(JpsProjectModelSynchronizer.access$getProject$p(this.this$0)).getEntityStorage().getCurrent().getVirtualFileUrlIndex();
                VirtualFilePointer[] $this$forEach$iv = pointers;
                boolean $i$f$forEach = false;
                VirtualFilePointer[] virtualFilePointerArray = $this$forEach$iv;
                int n = virtualFilePointerArray.length;
                for (int j = 0; j < n; ++j) {
                    VirtualFilePointer element$iv;
                    VirtualFilePointer it = element$iv = virtualFilePointerArray[j];
                    boolean bl = false;
                    VirtualFilePointer virtualFilePointer = it;
                    if (virtualFilePointer == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.url.VirtualFileUrl");
                    }
                    Sequence<Pair<WorkspaceEntity, String>> $this$forEach$iv2 = virtualFileUrlIndex.findEntitiesByUrl((VirtualFileUrl)virtualFilePointer);
                    boolean $i$f$forEach2 = false;
                    for (E element$iv2 : $this$forEach$iv2) {
                        Pair it2 = (Pair)element$iv2;
                        boolean bl2 = false;
                        JpsProjectModelSynchronizer.access$getSourcesToSave$p(this.this$0).add(((WorkspaceEntity)it2.getFirst()).getEntitySource());
                    }
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public final void loadRealProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JpsProjectConfigLocation jpsProjectConfigLocation = JpsEntitySourcesKt.getConfigLocation(project);
        Intrinsics.checkNotNull((Object)jpsProjectConfigLocation);
        JpsProjectConfigLocation configLocation = jpsProjectConfigLocation;
        Logger $this$debug$iv = LOG;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Initial loading of project located at " + configLocation;
            logger.debug(string, (Throwable)e$iv);
        }
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        if (workspaceModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl");
        }
        if (!((WorkspaceModelImpl)workspaceModel).getLoadedFromCache()) {
            StartupMeasurerHelperKt.recordModuleLoadingActivity();
        }
        Activity activity = StartUpMeasurer.startActivity((String)"(wm) Load initial project");
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startAct\u2026m) Load initial project\")");
        Activity activity2 = activity;
        Activity activity3 = activity2.startChild("(wm) Prepare serializers");
        Intrinsics.checkNotNullExpressionValue((Object)activity3, (String)"activity.startChild(\"(wm) Prepare serializers\")");
        Activity childActivity = activity3;
        IProjectStore iProjectStore = ProjectKt.getStateStore(project);
        if (iProjectStore == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.jps.serialization.ProjectStoreWithJpsContentReader");
        }
        this.fileContentReader = ((ProjectStoreWithJpsContentReader)iProjectStore).createContentReader();
        Path externalStoragePath = ProjectUtil.getExternalConfigurationDir((Project)project);
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ExternalStorageConfigurationManager.getInstance((Project)project);
        JpsFileContentReaderWithCache jpsFileContentReaderWithCache = this.fileContentReader;
        if (jpsFileContentReaderWithCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileContentReader");
        }
        JpsProjectSerializers serializers = JpsProjectEntitiesLoader.INSTANCE.createProjectSerializers(configLocation, jpsFileContentReaderWithCache, externalStoragePath, false, this.virtualFileManager, externalStorageConfigurationManager);
        this.serializers.set(serializers);
        this.registerListener();
        WorkspaceEntityStorageBuilder builder2 = WorkspaceEntityStorageBuilder.Companion.create();
        Activity activity4 = childActivity.endAndStart("(wm) Load state of unloaded modules");
        Intrinsics.checkNotNullExpressionValue((Object)activity4, (String)"childActivity.endAndStar\u2026ate of unloaded modules\")");
        childActivity = activity4;
        this.loadStateOfUnloadedModules(serializers);
        if (!WorkspaceModelInitialTestContent.INSTANCE.getHasInitialContent$intellij_platform_ide_impl()) {
            Activity activity5 = childActivity.endAndStart("(wm) Read serializers");
            Intrinsics.checkNotNullExpressionValue((Object)activity5, (String)"childActivity.endAndStart(\"(wm) Read serializers\")");
            childActivity = activity5;
            this.loadAndReportErrors((Function1)new Function1<ErrorReporter, Unit>(this, serializers, builder2){
                final /* synthetic */ JpsProjectModelSynchronizer this$0;
                final /* synthetic */ JpsProjectSerializers $serializers;
                final /* synthetic */ WorkspaceEntityStorageBuilder $builder;

                public final void invoke(@NotNull ErrorReporter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$serializers.loadAll(JpsProjectModelSynchronizer.access$getFileContentReader$p(this.this$0), this.$builder, it);
                }
                {
                    this.this$0 = jpsProjectModelSynchronizer;
                    this.$serializers = jpsProjectSerializers;
                    this.$builder = workspaceEntityStorageBuilder;
                    super(1);
                }
            });
            Activity activity6 = childActivity.endAndStart("(wm) Add changes to store");
            Intrinsics.checkNotNullExpressionValue((Object)activity6, (String)"childActivity.endAndStar\u2026m) Add changes to store\")");
            childActivity = activity6;
            WriteAction.runAndWait((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(project, builder2){
                final /* synthetic */ Project $project;
                final /* synthetic */ WorkspaceEntityStorageBuilder $builder;

                public final void run() {
                    WorkspaceModel.Companion.getInstance(this.$project).updateProjectModel((Function1)new Function1<WorkspaceEntityStorageBuilder, Unit>(this){
                        final /* synthetic */ loadRealProject.3 this$0;

                        public final void invoke(@NotNull WorkspaceEntityStorageBuilder updater) {
                            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                            updater.replaceBySource((Function1<? super EntitySource, Boolean>)((Function1)loadRealProject.1.INSTANCE), this.this$0.$builder.toStorage());
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    });
                }
                {
                    this.$project = project;
                    this.$builder = workspaceEntityStorageBuilder;
                }
            }));
            this.sourcesToSave.clear();
            JpsFileContentReaderWithCache jpsFileContentReaderWithCache2 = this.fileContentReader;
            if (jpsFileContentReaderWithCache2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fileContentReader");
            }
            jpsFileContentReaderWithCache2.clearCache();
            childActivity.end();
        }
        activity2.end();
    }

    /*
     * WARNING - void declaration
     */
    private final void loadStateOfUnloadedModules(JpsProjectSerializers serializers) {
        void $this$mapTo$iv$iv;
        void unloadedModulePaths;
        UnloadedModulesListStorage unloadedModulesListStorage = UnloadedModulesListStorage.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)unloadedModulesListStorage, (String)"UnloadedModulesListStorage.getInstance(project)");
        List<String> list2 = unloadedModulesListStorage.getUnloadedModuleNames();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"UnloadedModulesListStora\u2026ject).unloadedModuleNames");
        Set unloadedModuleNames = CollectionsKt.toSet((Iterable)list2);
        JpsProjectSerializers jpsProjectSerializers = serializers;
        if (jpsProjectSerializers == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializersImpl");
        }
        JpsProjectSerializersImpl cfr_ignored_0 = (JpsProjectSerializersImpl)jpsProjectSerializers;
        Iterable $this$partition$iv = serializers.getAllModulePaths();
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        Iterable<Object> second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            ModulePath it = (ModulePath)element$iv;
            boolean bl = false;
            if (unloadedModuleNames.contains(it.getModuleName())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List list3 = (List)pair.component1();
        List modulePathsToLoad = (List)pair.component2();
        WorkspaceEntityStorageBuilder tmpBuilder = WorkspaceEntityStorageBuilder.Companion.create();
        Iterable $this$map$iv = (Iterable)unloadedModulePaths;
        boolean $i$f$map = false;
        second$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UnloadedModuleDescriptionImpl unloadedModuleDescriptionImpl;
            void modulePath;
            ModulePath modulePath2 = (ModulePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.loadAndReportErrors((Function1)new Function1<ErrorReporter, Unit>((ModulePath)modulePath, this, serializers, tmpBuilder){
                final /* synthetic */ ModulePath $modulePath;
                final /* synthetic */ JpsProjectModelSynchronizer this$0;
                final /* synthetic */ JpsProjectSerializers $serializers$inlined;
                final /* synthetic */ WorkspaceEntityStorageBuilder $tmpBuilder$inlined;
                {
                    this.$modulePath = modulePath;
                    this.this$0 = jpsProjectModelSynchronizer;
                    this.$serializers$inlined = jpsProjectSerializers;
                    this.$tmpBuilder$inlined = workspaceEntityStorageBuilder;
                    super(1);
                }

                public final void invoke(@NotNull ErrorReporter it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    JpsFileEntitiesSerializer<?> jpsFileEntitiesSerializer = ((JpsProjectSerializersImpl)this.$serializers$inlined).findModuleSerializer(this.$modulePath);
                    Intrinsics.checkNotNull(jpsFileEntitiesSerializer);
                    jpsFileEntitiesSerializer.loadEntities(this.$tmpBuilder$inlined, JpsProjectModelSynchronizer.access$getFileContentReader$p(this.this$0), it, JpsProjectModelSynchronizer.access$getVirtualFileManager$p(this.this$0));
                }
            });
            if ((ModuleEntity)tmpBuilder.resolve(new ModuleId(modulePath.getModuleName())) == null) {
                unloadedModuleDescriptionImpl = null;
            } else {
                void $this$mapTo$iv$iv2;
                ModuleEntity moduleEntity;
                VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
                Sequence<ContentRootEntity> $this$sortedBy$iv = moduleEntity.getContentRoots();
                boolean $i$f$sortedBy = false;
                boolean bl2 = false;
                List contentRoots = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        ContentRootEntity contentEntry = (ContentRootEntity)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)contentEntry.getUrl().getUrl());
                        contentEntry = (ContentRootEntity)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = contentEntry.getUrl().getUrl();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                }), (Function1)((Function1)new Function1<ContentRootEntity, VirtualFilePointer>(pointerManager, this, serializers, tmpBuilder){
                    final /* synthetic */ VirtualFilePointerManager $pointerManager;
                    final /* synthetic */ JpsProjectModelSynchronizer this$0;
                    final /* synthetic */ JpsProjectSerializers $serializers$inlined;
                    final /* synthetic */ WorkspaceEntityStorageBuilder $tmpBuilder$inlined;
                    {
                        this.$pointerManager = virtualFilePointerManager;
                        this.this$0 = jpsProjectModelSynchronizer;
                        this.$serializers$inlined = jpsProjectSerializers;
                        this.$tmpBuilder$inlined = workspaceEntityStorageBuilder;
                        super(1);
                    }

                    @NotNull
                    public final VirtualFilePointer invoke(@NotNull ContentRootEntity contentEntry) {
                        Intrinsics.checkNotNullParameter((Object)contentEntry, (String)"contentEntry");
                        return this.$pointerManager.create(contentEntry.getUrl().getUrl(), (Disposable)this.this$0, null);
                    }
                })));
                Iterable $this$map$iv2 = CollectionsKt.filterIsInstance((Iterable)moduleEntity.getDependencies(), ModuleDependencyItem.Exportable.ModuleDependency.class);
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void moduleDependency;
                    ModuleDependencyItem.Exportable.ModuleDependency moduleDependency2 = (ModuleDependencyItem.Exportable.ModuleDependency)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    String string = moduleDependency.getModule().getName();
                    collection2.add(string);
                }
                List dependencyModuleNames = (List)destination$iv$iv2;
                unloadedModuleDescriptionImpl = new UnloadedModuleDescriptionImpl((ModulePath)modulePath, dependencyModuleNames, contentRoots);
            }
            UnloadedModuleDescriptionImpl unloadedModuleDescriptionImpl2 = unloadedModuleDescriptionImpl;
            collection.add(unloadedModuleDescriptionImpl2);
        }
        List unloaded = CollectionsKt.toMutableList((Collection)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        $this$map$iv = unloaded;
        boolean bl = false;
        if (!$this$map$iv.isEmpty()) {
            HashSet modulesToLoad = new HashSet(modulePathsToLoad);
            ModuleManagerEx.getInstanceEx(this.project).unloadNewlyAddedModulesIfPossible(modulesToLoad, unloaded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveChangedProjectEntities(@NotNull JpsFileContentWriter writer) {
        HashSet hashSet;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        LOG.debug("Saving project entities");
        JpsProjectSerializers data2 = this.serializers.get();
        if (data2 == null) {
            LOG.debug("Skipping save because initial loading wasn't performed");
            return;
        }
        WorkspaceEntityStorage storage = WorkspaceModel.Companion.getInstance(this.project).getEntityStorage().getCurrent();
        Set<EntitySource> set2 = this.sourcesToSave;
        Intrinsics.checkNotNullExpressionValue(set2, (String)"sourcesToSave");
        Set<EntitySource> set3 = set2;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set3) {
            boolean bl3 = false;
            HashSet copy2 = new HashSet(this.sourcesToSave);
            this.sourcesToSave.clear();
            hashSet = copy2;
        }
        HashSet affectedSources = hashSet;
        LOG.debugValues("Saving affected entities", (Collection)affectedSources);
        data2.saveEntities(storage, affectedSources, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void markAllEntitiesAsDirty() {
        Set<EntitySource> allSources2 = WorkspaceModel.Companion.getInstance(this.project).getEntityStorage().getCurrent().entitiesBySource((Function1<? super EntitySource, Boolean>)((Function1)markAllEntitiesAsDirty.allSources.1.INSTANCE)).keySet();
        Set<EntitySource> set2 = this.sourcesToSave;
        Intrinsics.checkNotNullExpressionValue(set2, (String)"sourcesToSave");
        Set<EntitySource> set3 = set2;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set3) {
            boolean bl3 = false;
            bl2 = this.sourcesToSave.addAll((Collection<EntitySource>)allSources2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JpsConfigurationFilesChange getAndResetIncomingChanges() {
        List<JpsConfigurationFilesChange> list2 = this.incomingChanges;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"incomingChanges");
        List<JpsConfigurationFilesChange> list3 = list2;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list3) {
            block4: {
                boolean bl3 = false;
                if (!this.incomingChanges.isEmpty()) break block4;
                JpsConfigurationFilesChange jpsConfigurationFilesChange = null;
                return jpsConfigurationFilesChange;
            }
            JpsConfigurationFilesChange combinedChanges = this.combineChanges();
            this.incomingChanges.clear();
            JpsConfigurationFilesChange jpsConfigurationFilesChange = combinedChanges;
            return jpsConfigurationFilesChange;
        }
    }

    private final JpsConfigurationFilesChange combineChanges() {
        List<JpsConfigurationFilesChange> list2 = this.incomingChanges;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"incomingChanges");
        JpsConfigurationFilesChange singleChange = (JpsConfigurationFilesChange)CollectionsKt.singleOrNull(list2);
        if (singleChange != null) {
            return singleChange;
        }
        LinkedHashSet<String> allAdded = new LinkedHashSet<String>();
        LinkedHashSet<String> allRemoved = new LinkedHashSet<String>();
        LinkedHashSet<String> allChanged = new LinkedHashSet<String>();
        for (JpsConfigurationFilesChange change : this.incomingChanges) {
            allChanged.addAll(change.getChangedFileUrls());
            for (String addedUrl : change.getAddedFileUrls()) {
                if (allRemoved.remove(addedUrl)) {
                    allChanged.add(addedUrl);
                    continue;
                }
                allAdded.add(addedUrl);
            }
            for (String removedUrl : change.getRemovedFileUrls()) {
                allChanged.remove(removedUrl);
                if (allAdded.remove(removedUrl)) continue;
                allRemoved.add(removedUrl);
            }
        }
        return new JpsConfigurationFilesChange((Collection<String>)allAdded, (Collection<String>)allRemoved, (Collection<String>)allChanged);
    }

    public void dispose() {
    }

    public JpsProjectModelSynchronizer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.incomingChanges = Collections.synchronizedList(new ArrayList());
        this.virtualFileManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, this.project);
        this.serializers = new AtomicReference();
        this.sourcesToSave = Collections.synchronizedSet(new HashSet());
        if (!this.project.isDefault()) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            application.getMessageBus().connect((Disposable)this).subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

                public void projectComponentsInitialized(@NotNull Project project) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Logger $this$debug$iv = LOG;
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl = false;
                        String string = "Project component initialized";
                        logger.debug(string, (Throwable)e$iv);
                    }
                    if (project == project) {
                        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
                        if (workspaceModel == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.WorkspaceModelImpl");
                        }
                        if (!((WorkspaceModelImpl)workspaceModel).getLoadedFromCache()) {
                            LOG.info("Workspace model loaded without cache. Loading real project state into workspace model. " + Thread.currentThread());
                            this.loadRealProject(project);
                        }
                    }
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JpsProjectModelSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ JpsFileContentReaderWithCache access$getFileContentReader$p(JpsProjectModelSynchronizer $this) {
        JpsFileContentReaderWithCache jpsFileContentReaderWithCache = $this.fileContentReader;
        if (jpsFileContentReaderWithCache == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileContentReader");
        }
        return jpsFileContentReaderWithCache;
    }

    public static final /* synthetic */ void access$setFileContentReader$p(JpsProjectModelSynchronizer $this, JpsFileContentReaderWithCache jpsFileContentReaderWithCache) {
        $this.fileContentReader = jpsFileContentReaderWithCache;
    }

    public static final /* synthetic */ Set access$getSourcesToSave$p(JpsProjectModelSynchronizer $this) {
        return $this.sourcesToSave;
    }

    public static final /* synthetic */ List access$getIncomingChanges$p(JpsProjectModelSynchronizer $this) {
        return $this.incomingChanges;
    }

    public static final /* synthetic */ VirtualFileUrlManager access$getVirtualFileManager$p(JpsProjectModelSynchronizer $this) {
        return $this.virtualFileManager;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsProjectModelSynchronizer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsProjectModelSynchronizer;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @Nullable
        public final JpsProjectModelSynchronizer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (JpsProjectModelSynchronizer)project.getComponent(JpsProjectModelSynchronizer.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

