/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorLinePainter;
import com.intellij.openapi.editor.LineExtensionInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerEditorLinePainter
extends EditorLinePainter {
    private static final Logger LOG = Logger.getInstance(XDebuggerEditorLinePainter.class);
    public static final Key<Map<Variable, VariableValue>> CACHE = Key.create((String)"debug.inline.variables.cache");
    private static final int LINE_EXTENSIONS_MAX_COUNT = 200;

    @Override
    public Collection<LineExtensionInfo> getLineExtensions(@NotNull Project project, @NotNull VirtualFile file2, int lineNumber) {
        if (project == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(1);
        }
        if (LightEdit.owns((Project)project)) {
            return null;
        }
        if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowValuesInline()) {
            return null;
        }
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session2 == null) {
            return null;
        }
        XVariablesView.InlineVariablesInfo data2 = XVariablesView.InlineVariablesInfo.get(session2);
        Document doc = FileDocumentManager.getInstance().getDocument(file2);
        if (data2 == null || doc == null) {
            return null;
        }
        Map<Variable, VariableValue> oldValues = XDebuggerEditorLinePainter.getOldValues(project);
        List<XValueNodeImpl> values = data2.get(file2, lineNumber, doc.getModificationStamp());
        if (values != null && !values.isEmpty()) {
            TextAttributes attributes = XDebuggerEditorLinePainter.getAttributes(lineNumber, file2, session2);
            ArrayList<VariableText> result2 = new ArrayList<VariableText>();
            for (XValueNodeImpl value2 : values) {
                SimpleColoredText simpleColoredText = XDebuggerEditorLinePainter.createPresentation(value2);
                if (simpleColoredText == null) continue;
                String name = value2.getName();
                if (StringUtil.isEmpty((String)simpleColoredText.toString())) continue;
                VariableText res2 = XDebuggerEditorLinePainter.computeVariablePresentationWithChanges(value2, name, simpleColoredText, attributes, lineNumber, oldValues);
                result2.add(res2);
            }
            ArrayList<LineExtensionInfo> infos = new ArrayList<LineExtensionInfo>();
            for (VariableText variableText : result2) {
                LineExtensionInfo varNameInfo = variableText.infos.get(0);
                LineExtensionInfo wrappedName = new LineExtensionInfo("  " + varNameInfo.getText() + ": ", varNameInfo.getColor(), varNameInfo.getEffectType(), varNameInfo.getEffectColor(), varNameInfo.getFontType());
                List<LineExtensionInfo> value3 = variableText.infos.subList(1, variableText.infos.size());
                infos.add(wrappedName);
                infos.addAll(value3);
            }
            return ContainerUtil.getFirstItems(infos, (int)200);
        }
        return null;
    }

    public static SimpleColoredText computeVariablePresentationWithChanges(XValueNodeImpl value2, String name, SimpleColoredText text2, TextAttributes attributes, int lineNumber, Project project) {
        Map<Variable, VariableValue> oldValues = XDebuggerEditorLinePainter.getOldValues(project);
        VariableText variableText = XDebuggerEditorLinePainter.computeVariablePresentationWithChanges(value2, name, text2, attributes, lineNumber, oldValues);
        SimpleColoredText coloredText = new SimpleColoredText();
        for (LineExtensionInfo info : variableText.infos) {
            TextAttributes textAttributes = new TextAttributes(info.getColor(), info.getBgColor(), info.getEffectColor(), info.getEffectType(), info.getFontType());
            coloredText.append(info.getText(), SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes));
        }
        return coloredText;
    }

    @NotNull
    private static VariableText computeVariablePresentationWithChanges(XValueNodeImpl value2, @NlsSafe String name, SimpleColoredText text2, TextAttributes attributes, int lineNumber, Map<Variable, VariableValue> oldValues) {
        VariableText res2 = new VariableText();
        res2.add(new LineExtensionInfo(name, attributes));
        Variable var = new Variable(name, lineNumber);
        VariableValue variableValue = oldValues.computeIfAbsent(var, k -> new VariableValue(text2.toString(), null, value2.hashCode()));
        if (variableValue.valueNodeHashCode != value2.hashCode()) {
            variableValue.old = variableValue.actual;
            variableValue.actual = text2.toString();
            variableValue.valueNodeHashCode = value2.hashCode();
        }
        if (!variableValue.isChanged()) {
            ArrayList texts = text2.getTexts();
            for (int i2 = 0; i2 < texts.size(); ++i2) {
                String s = (String)texts.get(i2);
                TextAttributes attr = Registry.is((String)"debugger.show.values.colorful") ? ((SimpleTextAttributes)text2.getAttributes().get(i2)).toTextAttributes() : attributes;
                res2.add(new LineExtensionInfo(s, attr));
            }
        } else {
            variableValue.produceChangedParts(res2.infos);
        }
        VariableText variableText = res2;
        if (variableText == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(2);
        }
        return variableText;
    }

    @NotNull
    public static Map<Variable, VariableValue> getOldValues(@NotNull Project project) {
        HashMap<Variable, VariableValue> oldValues;
        if (project == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(3);
        }
        if ((oldValues = (HashMap<Variable, VariableValue>)project.getUserData(CACHE)) == null) {
            oldValues = new HashMap<Variable, VariableValue>();
            project.putUserData(CACHE, oldValues);
        }
        HashMap<Variable, VariableValue> hashMap = oldValues;
        if (hashMap == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    public static TextAttributes getAttributes(int lineNumber, @NotNull VirtualFile file2, XDebugSession session2) {
        if (file2 == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(5);
        }
        int bpLine = XDebuggerEditorLinePainter.getCurrentBreakPointLineInFile(session2, file2);
        boolean isTopFrame = session2 instanceof XDebugSessionImpl && ((XDebugSessionImpl)session2).isTopFrameSelected();
        TextAttributes textAttributes = bpLine == lineNumber && isTopFrame && ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)session2.getProject())).isFullLineHighlighter() ? XDebuggerEditorLinePainter.getTopFrameSelectedAttributes() : XDebuggerEditorLinePainter.getNormalAttributes();
        if (textAttributes == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(6);
        }
        return textAttributes;
    }

    @Nullable
    public static SimpleColoredText createPresentation(@NotNull XValueNodeImpl value2) {
        if (value2 == null) {
            XDebuggerEditorLinePainter.$$$reportNull$$$0(7);
        }
        SimpleColoredText text2 = new SimpleColoredText();
        XValueTextRendererImpl renderer2 = new XValueTextRendererImpl((ColoredTextContainer)text2);
        XValuePresentation presentation2 = value2.getValuePresentation();
        if (presentation2 == null) {
            return null;
        }
        try {
            String type;
            if (presentation2 instanceof XValueCompactPresentation && !value2.getTree().isUnderRemoteDebug()) {
                ((XValueCompactPresentation)presentation2).renderValue(renderer2, value2);
            } else {
                presentation2.renderValue((XValuePresentation.XValueTextRenderer)renderer2);
            }
            if (StringUtil.isEmpty((String)text2.toString()) && !StringUtil.isEmpty((String)(type = value2.getValuePresentation().getType()))) {
                text2.append(type, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
        return text2;
    }

    private static int getCurrentBreakPointLineInFile(@Nullable XDebugSession session2, VirtualFile file2) {
        try {
            XSourcePosition position;
            if (session2 != null && (position = session2.getCurrentPosition()) != null && position.getFile().equals(file2)) {
                return position.getLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static TextAttributes getNormalAttributes() {
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES);
        if (attributes == null || attributes.getForegroundColor() == null) {
            return new TextAttributes((Color)new JBColor(() -> EditorColorsManager.getInstance().isDarkEditor() ? new Color(4030565) : Gray._135), null, null, null, 2);
        }
        return attributes;
    }

    private static TextAttributes getChangedAttributes() {
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES_MODIFIED);
        if (attributes == null || attributes.getForegroundColor() == null) {
            return new TextAttributes((Color)new JBColor(() -> EditorColorsManager.getInstance().isDarkEditor() ? new Color(10584842) : new Color(13271073)), null, null, null, 2);
        }
        return attributes;
    }

    private static TextAttributes getTopFrameSelectedAttributes() {
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
        if (attributes == null || attributes.getForegroundColor() == null) {
            return new TextAttributes(EditorColorsManager.getInstance().isDarkEditor() ? new Color(255, 235, 9) : new Color(0, 255, 86), null, null, null, 2);
        }
        return attributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/evaluate/XDebuggerEditorLinePainter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/evaluate/XDebuggerEditorLinePainter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariablePresentationWithChanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineExtensions";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOldValues";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VariableText {
        final List<LineExtensionInfo> infos = new ArrayList<LineExtensionInfo>();

        private VariableText() {
        }

        void add(LineExtensionInfo info) {
            this.infos.add(info);
        }
    }

    static class VariableValue {
        @NlsSafe
        private String actual;
        @NlsSafe
        private String old;
        private int valueNodeHashCode;

        VariableValue(String actual, String old, int valueNodeHashCode) {
            this.actual = actual;
            this.old = old;
            this.valueNodeHashCode = valueNodeHashCode;
        }

        public boolean isChanged() {
            return this.old != null && !StringUtil.equals((CharSequence)this.actual, (CharSequence)this.old);
        }

        void produceChangedParts(List<? super LineExtensionInfo> result2) {
            if (VariableValue.isArray(this.actual) && VariableValue.isArray(this.old)) {
                List<String> actualParts = VariableValue.getArrayParts(this.actual);
                List<String> oldParts = VariableValue.getArrayParts(this.old);
                result2.add(new LineExtensionInfo("{", XDebuggerEditorLinePainter.getNormalAttributes()));
                for (int i2 = 0; i2 < actualParts.size(); ++i2) {
                    if (i2 < oldParts.size() && StringUtil.equals((CharSequence)actualParts.get(i2), (CharSequence)oldParts.get(i2))) {
                        result2.add(new LineExtensionInfo(actualParts.get(i2), XDebuggerEditorLinePainter.getNormalAttributes()));
                    } else {
                        result2.add(new LineExtensionInfo(actualParts.get(i2), XDebuggerEditorLinePainter.getChangedAttributes()));
                    }
                    if (i2 == actualParts.size() - 1) continue;
                    result2.add(new LineExtensionInfo(", ", XDebuggerEditorLinePainter.getNormalAttributes()));
                }
                result2.add(new LineExtensionInfo("}", XDebuggerEditorLinePainter.getNormalAttributes()));
                return;
            }
            result2.add(new LineExtensionInfo(this.actual, XDebuggerEditorLinePainter.getChangedAttributes()));
        }

        private static boolean isArray(String s) {
            return s != null && s.startsWith("{") && s.endsWith("}");
        }

        private static List<String> getArrayParts(String array2) {
            return StringUtil.split((String)array2.substring(1, array2.length() - 1), (String)", ");
        }
    }

    static class Variable {
        private final int lineNumber;
        private final String name;

        Variable(String name, int lineNumber) {
            this.lineNumber = lineNumber;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            if (this.lineNumber != variable.lineNumber) {
                return false;
            }
            return this.name.equals(variable.name);
        }

        public int hashCode() {
            return Objects.hash(this.lineNumber, this.name);
        }
    }
}

