/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.jsonSchema.JsonSchemaCatalogProjectConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaCatalogConfigurable
implements Configurable {
    @NonNls
    public static final String SETTINGS_JSON_SCHEMA_CATALOG = "settings.json.schema.catalog";
    @NotNull
    private final Project myProject;
    private final JBCheckBox myCatalogCheckBox;
    private final JBCheckBox myRemoteCheckBox;
    private final JBCheckBox myPreferRemoteCheckBox;

    public JsonSchemaCatalogConfigurable(@NotNull Project project) {
        if (project == null) {
            JsonSchemaCatalogConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myCatalogCheckBox = new JBCheckBox(JsonBundle.message("checkbox.use.schemastore.org.json.schema.catalog", new Object[0]));
        this.myRemoteCheckBox = new JBCheckBox(JsonBundle.message("checkbox.allow.downloading.json.schemas.from.remote.sources", new Object[0]));
        this.myPreferRemoteCheckBox = new JBCheckBox(JsonBundle.message("checkbox.always.download.the.most.recent.version.of.schemas", new Object[0]));
    }

    @Nullable
    public JComponent createComponent() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addComponent((JComponent)this.myRemoteCheckBox);
        builder.addVerticalGap(2);
        this.myRemoteCheckBox.addChangeListener(c -> {
            boolean selected = this.myRemoteCheckBox.isSelected();
            this.myCatalogCheckBox.setEnabled(selected);
            this.myPreferRemoteCheckBox.setEnabled(selected);
            if (!selected) {
                this.myCatalogCheckBox.setSelected(false);
                this.myPreferRemoteCheckBox.setSelected(false);
            }
        });
        JsonSchemaCatalogConfigurable.addWithComment(builder, this.myCatalogCheckBox, JsonBundle.message("schema.catalog.hint", new Object[0]));
        JsonSchemaCatalogConfigurable.addWithComment(builder, this.myPreferRemoteCheckBox, JsonBundle.message("schema.catalog.remote.hint", new Object[0]));
        return JsonSchemaCatalogConfigurable.wrap(builder.getPanel());
    }

    private static void addWithComment(FormBuilder builder, JBCheckBox box, @NlsContexts.DetailedDescription String s) {
        builder.addComponent((JComponent)new ComponentPanelBuilder((JComponent)box).withComment(s).createPanel());
    }

    private static JPanel wrap(JComponent panel) {
        JBPanel wrapper = new JBPanel((LayoutManager)new BorderLayout());
        wrapper.add((Component)panel, "North");
        return wrapper;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCatalogCheckBox;
    }

    public void reset() {
        JsonSchemaCatalogProjectConfiguration.MyState state = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).getState();
        boolean remoteEnabled = state == null || state.myIsRemoteActivityEnabled;
        this.myRemoteCheckBox.setSelected(remoteEnabled);
        this.myCatalogCheckBox.setEnabled(remoteEnabled);
        this.myPreferRemoteCheckBox.setEnabled(remoteEnabled);
        this.myCatalogCheckBox.setSelected(state == null || state.myIsCatalogEnabled);
        this.myPreferRemoteCheckBox.setSelected(state == null || state.myIsPreferRemoteSchemas);
    }

    public boolean isModified() {
        JsonSchemaCatalogProjectConfiguration.MyState state = JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).getState();
        return state == null || state.myIsCatalogEnabled != this.myCatalogCheckBox.isSelected() || state.myIsPreferRemoteSchemas != this.myPreferRemoteCheckBox.isSelected() || state.myIsRemoteActivityEnabled != this.myRemoteCheckBox.isSelected();
    }

    public void apply() throws ConfigurationException {
        JsonSchemaCatalogProjectConfiguration.getInstance(this.myProject).setState(this.myCatalogCheckBox.isSelected(), this.myRemoteCheckBox.isSelected(), this.myPreferRemoteCheckBox.isSelected());
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return JsonBundle.message("configurable.JsonSchemaCatalogConfigurable.display.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return SETTINGS_JSON_SCHEMA_CATALOG;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaCatalogConfigurable", "<init>"));
    }
}

