/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.application.options.CodeStyle;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.NewCodeStyleNotificationKt;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.SuppressKotlinCodeStyleComponent;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.SuppressKotlinCodeStyleState;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"KOTLIN_UPDATE_CODE_STYLE_GROUP_ID", "", "createNotification", "Lcom/intellij/notification/Notification;", "notifyKotlinStyleUpdateIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
public final class NewCodeStyleNotificationKt {
    private static final String KOTLIN_UPDATE_CODE_STYLE_GROUP_ID = "Update Kotlin code style";

    public static final void notifyKotlinStyleUpdateIfNeeded(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        List list = ProjectFacetManager.getInstance((Project)project2).getModulesWithFacet(KotlinFacetType.Companion.getTYPE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ProjectFacetManager.getI\u2026(KotlinFacetType.TYPE_ID)");
        List modulesWithFacet = list;
        if (modulesWithFacet.isEmpty()) {
            return;
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"CodeStyle.getSettings(project)");
        if (Intrinsics.areEqual((Object)CodeStyleUtilsKt.kotlinCodeStyleDefaults((CodeStyleSettings)codeStyleSettings), (Object)"KOTLIN_OFFICIAL")) {
            return;
        }
        if (((SuppressKotlinCodeStyleState)SuppressKotlinCodeStyleComponent.Companion.getInstance(project2).getState()).getDisableForAll()) {
            return;
        }
        Notification notification2 = NewCodeStyleNotificationKt.createNotification();
        NotificationsConfiguration.getNotificationsConfiguration().register(KOTLIN_UPDATE_CODE_STYLE_GROUP_ID, NotificationDisplayType.STICKY_BALLOON, true);
        notification2.notify(project2);
    }

    private static final Notification createNotification() {
        Notification notification2 = new Notification(KOTLIN_UPDATE_CODE_STYLE_GROUP_ID, KotlinBundle.message("configuration.kotlin.code.style", new Object[0]), KotlinBundle.htmlMessage("configuration.notification.update.code.style.to.official", new Object[0]), NotificationType.WARNING);
        boolean bl = false;
        boolean bl2 = false;
        Notification $this$apply = notification2;
        boolean bl3 = false;
        NotificationAction notificationAction2 = NotificationAction.create((String)KotlinBundle.message("configuration.apply.new.code.style", new Object[0]), (BiConsumer)createNotification.1.notificationAction.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction2, (String)"NotificationAction.creat\u2026        }\n        }\n    }");
        NotificationAction notificationAction3 = notificationAction2;
        NotificationAction notificationAction4 = NotificationAction.create((String)KotlinBundle.message("configuration.do.not.suggest.new.code.style", new Object[0]), (BiConsumer)createNotification.1.disableAction.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction4, (String)"NotificationAction.creat\u2026        }\n        }\n    }");
        NotificationAction disableAction2 = notificationAction4;
        $this$apply.addActions(CollectionsKt.listOf((Object[])new NotificationAction[]{notificationAction3, disableAction2}));
        $this$apply.setImportant(true);
        return notification2;
    }
}

