/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import git4idea.GitApplyChangesProcess;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GitCherryPicker
extends VcsCherryPicker {
    private static final Logger LOG = Logger.getInstance(GitCherryPicker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitVcsSettings mySettings;

    public GitCherryPicker(@NotNull Project project) {
        if (project == null) {
            GitCherryPicker.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
    }

    public void cherryPick(@NotNull List<? extends VcsFullCommitDetails> commits2) {
        if (commits2 == null) {
            GitCherryPicker.$$$reportNull$$$0(1);
        }
        new GitApplyChangesProcess(this.myProject, commits2, GitCherryPicker.isAutoCommit(), GitBundle.message("cherry.pick.name", new Object[0]), GitBundle.message("cherry.pick.applied", new Object[0]), (Function4<? super GitRepository, ? super Hash, ? super Boolean, ? super List<? extends GitLineHandlerListener>, ? extends GitCommandResult>)((Function4)(repository, commit2, autoCommit, listeners) -> Git.getInstance().cherryPick((GitRepository)repository, commit2.asString(), (boolean)autoCommit, this.shouldAddSuffix((GitRepository)repository, (Hash)commit2), listeners.toArray(new GitLineHandlerListener[0]))), (Function1<? super GitCommandResult, Boolean>)((Function1)result2 -> GitCherryPicker.isNothingToCommitMessage(result2)), (Function2<? super GitRepository, ? super VcsFullCommitDetails, String>)((Function2)(repository, commit2) -> this.createCommitMessage((GitRepository)repository, (VcsFullCommitDetails)commit2)), true, (Function1<? super GitRepository, Unit>)((Function1)repository -> GitCherryPicker.cancelCherryPick(repository))).execute();
    }

    private static boolean isNothingToCommitMessage(@NotNull GitCommandResult result2) {
        String stdout;
        if (result2 == null) {
            GitCherryPicker.$$$reportNull$$$0(2);
        }
        return (stdout = result2.getOutputAsJoinedString()).contains("nothing to commit") || stdout.contains("previous cherry-pick is now empty");
    }

    @NotNull
    private String createCommitMessage(@NotNull GitRepository repository, @NotNull VcsFullCommitDetails commit2) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(3);
        }
        if (commit2 == null) {
            GitCherryPicker.$$$reportNull$$$0(4);
        }
        Object message = commit2.getFullMessage();
        if (this.shouldAddSuffix(repository, (Hash)commit2.getId())) {
            message = (String)message + String.format("\n\n(cherry picked from commit %s)", ((Hash)commit2.getId()).asString());
        }
        String string = message;
        if (string == null) {
            GitCherryPicker.$$$reportNull$$$0(5);
        }
        return string;
    }

    private boolean shouldAddSuffix(@NotNull GitRepository repository, @NotNull Hash commit2) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(6);
        }
        if (commit2 == null) {
            GitCherryPicker.$$$reportNull$$$0(7);
        }
        return this.mySettings.shouldAddSuffixToCherryPicksOfPublishedCommits() && GitProtectedBranchesKt.isCommitPublished(repository, commit2);
    }

    private static Unit cancelCherryPick(@NotNull GitRepository repository) {
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(8);
        }
        if (GitCherryPicker.isAutoCommit()) {
            GitCherryPicker.removeCherryPickHead(repository);
        }
        return Unit.INSTANCE;
    }

    private static void removeCherryPickHead(@NotNull GitRepository repository) {
        File cherryPickHeadFile;
        if (repository == null) {
            GitCherryPicker.$$$reportNull$$$0(9);
        }
        if ((cherryPickHeadFile = repository.getRepositoryFiles().getCherryPickHead()).exists()) {
            boolean deleted = FileUtil.delete((File)cherryPickHeadFile);
            if (!deleted) {
                LOG.warn("Couldn't delete " + cherryPickHeadFile);
            }
        } else {
            LOG.info("Cancel cherry-pick in " + repository.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            GitCherryPicker.$$$reportNull$$$0(10);
        }
        return vcsKey;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getActionTitle() {
        String string = DvcsBundle.message((String)"cherry.pick.action.text", (Object[])new Object[0]);
        if (string == null) {
            GitCherryPicker.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean isAutoCommit() {
        return GitVcsApplicationSettings.getInstance().isAutoCommitOnCherryPick();
    }

    public boolean canHandleForRoots(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            GitCherryPicker.$$$reportNull$$$0(12);
        }
        return roots.stream().allMatch(r -> this.myRepositoryManager.getRepositoryForRootQuick((VirtualFile)r) != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/cherrypick/GitCherryPicker";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/cherrypick/GitCherryPicker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedVcs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isNothingToCommitMessage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessage";
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddSuffix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cancelCherryPick";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeCherryPickHead";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canHandleForRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

