/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitConfigUtil;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.ui.StashInfo;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a.\u0010\f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0007\u001a@\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createStashHandler", "Lgit4idea/commands/GitLineHandler;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "keepIndex", "", "message", "", "loadChangesInStash", "", "", "Lcom/intellij/openapi/vcs/changes/Change;", "hash", "Lcom/intellij/vcs/log/Hash;", "loadStashStack", "Lgit4idea/ui/StashInfo;", "", "consumer", "Lcom/intellij/util/Consumer;", "unstash", "rootAndRevisions", "", "handlerProvider", "Lkotlin/Function1;", "conflictResolver", "Lgit4idea/merge/GitConflictResolver;", "intellij.vcs.git"})
@JvmName(name="GitStashUtils")
public final class GitStashUtils {
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final boolean unstash(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Hash> rootAndRevisions, @NotNull Function1<? super VirtualFile, ? extends GitLineHandler> handlerProvider, @NotNull GitConflictResolver conflictResolver) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rootAndRevisions, (String)"rootAndRevisions");
        Intrinsics.checkNotNullParameter(handlerProvider, (String)"handlerProvider");
        Intrinsics.checkNotNullParameter((Object)conflictResolver, (String)"conflictResolver");
        AutoCloseable autoCloseable = (AutoCloseable)DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitBundle.message("activity.name.unstash", new Object[0]));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl3 = false;
            VirtualFile virtualFile = rootAndRevisions;
            boolean bl4 = false;
            Iterator<Map.Entry<VirtualFile, ? extends Hash>> iterator = virtualFile.entrySet().iterator();
            while (iterator.hasNext()) {
                GitCommandResult result2;
                List<Collection<Change>> changesInStash;
                List<Collection<Change>> list2;
                void root;
                Map.Entry<VirtualFile, ? extends Hash> entry;
                Map.Entry<VirtualFile, ? extends Hash> entry2 = entry = iterator.next();
                boolean bl5 = false;
                virtualFile = entry2.getKey();
                entry2 = entry;
                bl5 = false;
                Hash hash = entry2.getValue();
                GitLineHandler handler = (GitLineHandler)handlerProvider.invoke((Object)root);
                GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT_ON_UNSTASH);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector((VirtualFile)root);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector((VirtualFile)root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                handler.addLineListener(conflictDetector);
                handler.addLineListener(untrackedFilesDetector);
                handler.addLineListener(localChangesDetector);
                Intrinsics.checkNotNullExpressionValue((Object)Git.getInstance().runCommand((Computable<? extends GitLineHandler>)((Computable)new Computable<GitLineHandler>(handler){
                    final /* synthetic */ GitLineHandler $handler;

                    public final GitLineHandler compute() {
                        return this.$handler;
                    }
                    {
                        this.$handler = gitLineHandler;
                    }
                })), (String)"Git.getInstance().runCommand { handler }");
                if (hash != null) {
                    Hash hash2;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Hash $this$run = hash2;
                    boolean bl8 = false;
                    list2 = GitStashUtils.loadChangesInStash(project, (VirtualFile)root, hash);
                } else {
                    list2 = null;
                }
                List<Collection<Change>> list3 = changesInStash = list2;
                GitUtil.refreshVfs((VirtualFile)root, list3 != null ? CollectionsKt.flatten((Iterable)list3) : null);
                if (conflictDetector.hasHappened()) {
                    boolean conflictsResolved = conflictResolver.merge();
                    if (conflictsResolved) continue;
                    boolean bl9 = false;
                    return bl9;
                }
                if (untrackedFilesDetector.wasMessageDetected()) {
                    GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, (VirtualFile)root, (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), GitBundle.message("unstash.operation.name", new Object[0]), null);
                    boolean bl10 = false;
                    return bl10;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, "git.stash.local.changes.detected", (VirtualFile)root, GitBundle.message("unstash.operation.name", new Object[0]), (Collection<String>)localChangesDetector.getRelativeFilePaths());
                    boolean bl11 = false;
                    return bl11;
                }
                if (result2.success()) continue;
                VcsNotifier.getInstance((Project)project).notifyError("git.unstash.failed", GitBundle.message("notification.title.unstash.failed", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                boolean bl12 = false;
                return bl12;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Collection<Change>> loadChangesInStash(Project project, VirtualFile root, Hash hash) {
        try {
            void $this$mapTo$iv$iv;
            GitCommit stashCommit;
            CollectConsumer consumer2 = new CollectConsumer();
            GitLogUtil.readFullDetailsForHashes(project, root, CollectionsKt.listOf((Object)hash.asString()), new GitCommitRequirements(false, GitCommitRequirements.DiffRenameLimit.NO_RENAMES, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS), (Consumer<? super GitCommit>)((Consumer)consumer2));
            Collection collection = consumer2.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"consumer.result");
            GitCommit gitCommit = stashCommit = (GitCommit)((Object)CollectionsKt.first((Iterable)collection));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitCommit), (String)"stashCommit");
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)gitCommit.getParents().size());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Collection collection3 = stashCommit.getChanges((int)it);
                collection2.add(collection3);
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Couldn't load changes in root [" + root + "] in stash resolved to [" + hash + ']', (Throwable)e);
            List<Collection<Change>> list2 = null;
            return list2;
        }
    }

    @Deprecated(message="use the simpler overloading method which returns a list")
    public static final void loadStashStack(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<StashInfo> consumer2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        for (StashInfo stash : GitStashUtils.loadStashStack(project, root)) {
            consumer2.consume((Object)stash);
        }
    }

    @NotNull
    public static final List<StashInfo> loadStashStack(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Charset charset = Charset.forName(GitConfigUtil.getLogEncoding(project, root));
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.STASH.readLockingCommand());
        h2.setSilent(true);
        h2.addParameters("list", "--pretty=format:%H:%gd:%s");
        h2.setCharset(charset);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(h2);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"Git.getInstance().runCommand(h)");
        GitCommandResult output = gitCommandResult;
        output.throwOnError(new int[0]);
        boolean bl = false;
        List result2 = new ArrayList();
        Iterator<String> iterator = output.getOutput().iterator();
        while (iterator.hasNext()) {
            boolean bl2;
            String line;
            String string = line = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line");
            List parts = StringsKt.split$default((CharSequence)string, (char[])new char[]{':'}, (boolean)false, (int)4, (int)2, null);
            if (parts.size() < 3) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error("Can't parse stash record: " + line);
                continue;
            }
            if (parts.size() == 3) {
                String string2 = (String)parts.get(2);
                bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                result2.add(new StashInfo(root, HashImpl.build((String)((String)parts.get(0))), (String)parts.get(1), null, ((Object)StringsKt.trim((CharSequence)string3)).toString()));
                continue;
            }
            String string4 = (String)parts.get(2);
            bl2 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string4 = (String)parts.get(3);
            bl2 = false;
            String string6 = string4;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            result2.add(new StashInfo(root, HashImpl.build((String)((String)parts.get(0))), (String)parts.get(1), ((Object)StringsKt.trim((CharSequence)string5)).toString(), ((Object)StringsKt.trim((CharSequence)string6)).toString()));
        }
        return result2;
    }

    @NotNull
    public static final GitLineHandler createStashHandler(@NotNull Project project, @NotNull VirtualFile root, boolean keepIndex, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.STASH);
        handler.addParameters("save");
        if (keepIndex) {
            handler.addParameters("--keep-index");
        }
        CharSequence charSequence = message;
        boolean bl = false;
        String msg = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        charSequence = msg;
        bl = false;
        if (charSequence.length() > 0) {
            handler.addParameters(msg);
        }
        return handler;
    }

    public static /* synthetic */ GitLineHandler createStashHandler$default(Project project, VirtualFile virtualFile, boolean bl, String string, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string = "";
        }
        return GitStashUtils.createStashHandler(project, virtualFile, bl, string);
    }

    static {
        Logger logger = Logger.getInstance((String)"#git4idea.stash.GitStashUtils");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#git\u2026dea.stash.GitStashUtils\")");
        LOG = logger;
    }
}

