/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.uploader.ExternalDataCollectorLogger;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventSerializer;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExternalEventsLogger
implements DataCollectorSystemEventLogger {
    @NonNls
    private final Logger myLogger = Logger.getLogger((String)"com.intellij.internal.statistic.uploader.events");

    public ExternalEventsLogger() {
        String logDirectory = ExternalDataCollectorLogger.findDirectory(1000000L);
        if (logDirectory != null) {
            this.myLogger.addAppender((Appender)ExternalEventsLogger.newAppender(ExternalEventsLogger.getEventLogFile(logDirectory).getAbsolutePath()));
            this.myLogger.setLevel(Level.ALL);
        }
    }

    @NotNull
    public static FileAppender newAppender(@NotNull String directory) {
        if (directory == null) {
            ExternalEventsLogger.$$$reportNull$$$0(0);
        }
        @NonNls FileAppender appender = new FileAppender();
        appender.setFile(directory);
        appender.setLayout((Layout)new PatternLayout("%m\n"));
        appender.setThreshold((Priority)Level.ALL);
        appender.setAppend(false);
        appender.activateOptions();
        FileAppender fileAppender = appender;
        if (fileAppender == null) {
            ExternalEventsLogger.$$$reportNull$$$0(1);
        }
        return fileAppender;
    }

    @NotNull
    private static File getEventLogFile(@NotNull String logDirectory) {
        if (logDirectory == null) {
            ExternalEventsLogger.$$$reportNull$$$0(2);
        }
        return new File(logDirectory, "idea_statistics_uploader_events.log");
    }

    public void logSendingLogsStarted() {
        this.logEvent(new ExternalUploadStartedEvent(System.currentTimeMillis()));
    }

    public void logSendingLogsFinished(@NotNull String error) {
        if (error == null) {
            ExternalEventsLogger.$$$reportNull$$$0(3);
        }
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error));
    }

    public void logSendingLogsFinished(@NotNull StatisticsResult.ResultCode code) {
        if (code == null) {
            ExternalEventsLogger.$$$reportNull$$$0(4);
        }
        String error = code == StatisticsResult.ResultCode.SEND ? null : code.name();
        this.logEvent(new ExternalUploadFinishedEvent(System.currentTimeMillis(), error));
    }

    public void logSendingLogsSucceed(@NotNull List<String> successfullySentFiles, int failed, int total) {
        if (successfullySentFiles == null) {
            ExternalEventsLogger.$$$reportNull$$$0(5);
        }
        this.logEvent(new ExternalUploadSendEvent(System.currentTimeMillis(), successfullySentFiles.size(), failed, total, successfullySentFiles));
    }

    @Override
    public void logErrorEvent(@NotNull String eventId, @NotNull Throwable exception) {
        if (eventId == null) {
            ExternalEventsLogger.$$$reportNull$$$0(6);
        }
        if (exception == null) {
            ExternalEventsLogger.$$$reportNull$$$0(7);
        }
        this.logEvent(new ExternalSystemErrorEvent(System.currentTimeMillis(), eventId, exception));
    }

    private void logEvent(@NotNull ExternalSystemEvent event) {
        if (event == null) {
            ExternalEventsLogger.$$$reportNull$$$0(8);
        }
        this.myLogger.info((Object)ExternalSystemEventSerializer.serialize(event));
    }

    @NotNull
    public static List<ExternalSystemEvent> parseEvents(@NotNull File directory) throws IOException {
        File file;
        List<String> lines;
        if (directory == null) {
            ExternalEventsLogger.$$$reportNull$$$0(9);
        }
        List<String> list = lines = (file = ExternalEventsLogger.getEventLogFile(directory.getAbsolutePath())).exists() ? Files.readAllLines(file.toPath()) : Collections.emptyList();
        if (!lines.isEmpty()) {
            ArrayList<ExternalSystemEvent> events = new ArrayList<ExternalSystemEvent>();
            for (String line : lines) {
                ExternalSystemEvent event = ExternalSystemEventSerializer.deserialize(line);
                if (event == null) continue;
                events.add(event);
            }
            ArrayList<ExternalSystemEvent> arrayList = events;
            if (arrayList == null) {
                ExternalEventsLogger.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        List<ExternalSystemEvent> list2 = Collections.emptyList();
        if (list2 == null) {
            ExternalEventsLogger.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/uploader/events/ExternalEventsLogger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successfullySentFiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/uploader/events/ExternalEventsLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newAppender";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newAppender";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEventLogFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logSendingLogsFinished";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logSendingLogsSucceed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logErrorEvent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseEvents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

