/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.MathUtil;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\f\u0010\u0016\u001a\u00020\b*\u00020\u0003H\u0002J\f\u0010\u0017\u001a\u00020\u0003*\u00020\u0003H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "", "recorderId", "", "(Ljava/lang/String;)V", "anonymizedCache", "Ljava/util/HashMap;", "bucket", "", "getBucket", "()I", "deviceId", "getDeviceId", "()Ljava/lang/String;", "salt", "", "sessionId", "getSessionId", "anonymize", "data", "getOrGenerateDeviceId", "getOrGenerateSalt", "asBucket", "shortedUUID", "intellij.platform.statistics"})
public final class EventLogRecorderConfiguration {
    @NotNull
    private final String sessionId;
    @NotNull
    private final String deviceId;
    private final int bucket;
    private final byte[] salt;
    private final HashMap<String, String> anonymizedCache;

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    public final int getBucket() {
        return this.bucket;
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        if (this.anonymizedCache.containsKey(data)) {
            String string = this.anonymizedCache.get(data);
            if (string == null) {
                string = "";
            }
            return string;
        }
        String result = EventLogConfiguration.INSTANCE.hashSha256(this.salt, data);
        ((Map)this.anonymizedCache).put(data, result);
        return result;
    }

    private final String shortedUUID(String $this$shortedUUID) {
        int start = StringsKt.lastIndexOf$default((CharSequence)$this$shortedUUID, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start > 0 && start + 1 < $this$shortedUUID.length()) {
            String string = $this$shortedUUID;
            int n = start + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $this$shortedUUID;
    }

    private final int asBucket(String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final String getOrGenerateDeviceId(String recorderId) {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property = EventLogConfiguration.INSTANCE.getHeadlessDeviceIdProperty$intellij_platform_statistics(recorderId);
            String string = System.getProperty(property);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                return it;
            }
        }
        String string = DeviceIdManager.getOrGenerateId(recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DeviceIdManager.getOrGenerateId(recorderId)");
        return string;
    }

    private final byte[] getOrGenerateSalt(String recorderId) {
        String string;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property = EventLogConfiguration.INSTANCE.getHeadlessSaltProperty$intellij_platform_statistics(recorderId);
            String string2 = System.getProperty(property);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                String string4 = it;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string5.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                return byArray;
            }
        }
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"ApplicationInfoImpl.getShadowInstance()");
        String companyName = applicationInfoEx.getShortCompanyName();
        if (StringUtil.isEmptyOrSpaces((String)companyName)) {
            string = "jetbrains";
        } else {
            String string6 = companyName;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"companyName");
            String string7 = string6;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean it = false;
            String string8 = string7;
            if (string8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase(locale)");
        }
        String name = string;
        Preferences prefs = Preferences.userRoot().node(name);
        String saltKey = EventLogConfiguration.INSTANCE.getSaltPropertyKey$intellij_platform_statistics(recorderId);
        byte[] salt = prefs.getByteArray(saltKey, null);
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            prefs.putByteArray(saltKey, salt);
            EventLogConfiguration.INSTANCE.getLOG$intellij_platform_statistics().info("Generating salt for the device");
        }
        return salt;
    }

    public EventLogRecorderConfiguration(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        this.sessionId = this.shortedUUID(string);
        this.deviceId = this.getOrGenerateDeviceId(recorderId);
        this.bucket = this.asBucket(this.deviceId);
        this.salt = this.getOrGenerateSalt(recorderId);
        this.anonymizedCache = new HashMap();
    }
}

