/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.nano;

import com.android.tools.idea.protobuf.nano.CodedInputByteBufferNano;
import com.android.tools.idea.protobuf.nano.MessageNano;
import com.google.common.io.ByteStreams;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.nano.MessageNanoFactory;
import io.grpc.protobuf.nano.NanoProtoInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NanoUtils {
    private NanoUtils() {
    }

    public static <T extends MessageNano> MethodDescriptor.Marshaller<T> marshaller(final MessageNanoFactory<T> factory) {
        return new MethodDescriptor.Marshaller<T>(){

            @Override
            public InputStream stream(T value) {
                return new NanoProtoInputStream((MessageNano)value);
            }

            @Override
            public T parse(InputStream stream) {
                try {
                    CodedInputByteBufferNano input = CodedInputByteBufferNano.newInstance((byte[])ByteStreams.toByteArray((InputStream)stream));
                    input.setSizeLimit(Integer.MAX_VALUE);
                    Object message = factory.newInstance();
                    message.mergeFrom(input);
                    return message;
                }
                catch (IOException ipbe) {
                    throw Status.INTERNAL.withDescription("Failed parsing nano proto message").withCause(ipbe).asRuntimeException();
                }
            }
        };
    }
}

