// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
(function() {
  function checkAllLoaded(blocks) {
    return new Promise(resolve => {
      if (blocks.length === 0) {
        resolve();
        return;
      }
      const interval = setInterval(() => {
        if (blocks.every(block => block.querySelector("svg") != null)) {
          clearInterval(interval);
          resolve();
        }
      }, 20);
    });
  }

  function renderAll() {
    console.time("mermaid-init");
    console.log("Calling mermaid init");
    const blocks = Array.from(document.querySelectorAll("div.mermaid"));
    blocks.forEach(block => block.removeAttribute("data-processed"));
    console.log(`${blocks.length} blocks will be generated by mermaid`);
    let blocksProcessed = 0;
    mermaid.init(null, "div.mermaid", id => {
      const element = document.getElementById(id);
      let cacheId = element.parentElement.getAttribute("cache-id");
      console.log(`Generated by mermaid: ${id} for cache-id: ${cacheId}`);
      window.messagePipe.post("storeMermaidFile", `${cacheId};${element.outerHTML}`);
      blocksProcessed += 1;
      if (blocksProcessed === blocks.length) {
        console.timeEnd("mermaid-init");
      }
    });
  }

  IncrementalDOM.notifications.afterPatchListeners.push(renderAll);
  renderAll();
})();
