/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
/**
 * Generates a `cdn.json` file with the prefixes of CDN where Theia and Monaco files
 * should be retrieved from.
 *
 * @author David Festal
 */
export declare class Cdn {
    readonly assemblyFolder: string;
    readonly theiaCDN: string;
    readonly monacoCDN: string;
    static readonly defaultTheiaCdnPrefix = "https://cdn.jsdelivr.net/gh/davidfestal/che-theia-cdn@latest/che-theia-editor/";
    static readonly defaultMonacoCdnPrefix = "https://cdn.jsdelivr.net/npm/";
    static argBuilder: (theYargs: any) => any;
    constructor(assemblyFolder: string, theiaCDN: string, monacoCDN: string);
    create(): Promise<void>;
}
//# sourceMappingURL=cdn.d.ts.map