/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.Command = void 0;
/**
 * Mock of the command class.
 */
class Command {
    constructor() { }
    // mock any exec command by providing the output
    static __setExecCommandOutput(command, output) {
        Command.execMap.set(command, output);
    }
    async exec(command) {
        const result = Command.execMap.get(command);
        if (result) {
            return Promise.resolve(result);
        }
        else {
            return Promise.resolve('');
        }
    }
}
exports.Command = Command;
/**
 * Map between the name of the exec command and the output.
 */
Command.execMap = new Map();
//# sourceMappingURL=command.js.map