// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/conversion_adjustment_upload_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for
// [ConversionAdjustmentUploadService.UploadConversionAdjustments][google.ads.googleads.v3.services.ConversionAdjustmentUploadService.UploadConversionAdjustments].
type UploadConversionAdjustmentsRequest struct {
	// Required. The ID of the customer performing the upload.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The conversion adjustments that are being uploaded.
	ConversionAdjustments []*ConversionAdjustment `protobuf:"bytes,2,rep,name=conversion_adjustments,json=conversionAdjustments,proto3" json:"conversion_adjustments,omitempty"`
	// Required. If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried out
	// in one transaction if and only if they are all valid. This should always be
	// set to true.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UploadConversionAdjustmentsRequest) Reset()         { *m = UploadConversionAdjustmentsRequest{} }
func (m *UploadConversionAdjustmentsRequest) String() string { return proto.CompactTextString(m) }
func (*UploadConversionAdjustmentsRequest) ProtoMessage()    {}
func (*UploadConversionAdjustmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dcef73f64d51915, []int{0}
}

func (m *UploadConversionAdjustmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UploadConversionAdjustmentsRequest.Unmarshal(m, b)
}
func (m *UploadConversionAdjustmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UploadConversionAdjustmentsRequest.Marshal(b, m, deterministic)
}
func (m *UploadConversionAdjustmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UploadConversionAdjustmentsRequest.Merge(m, src)
}
func (m *UploadConversionAdjustmentsRequest) XXX_Size() int {
	return xxx_messageInfo_UploadConversionAdjustmentsRequest.Size(m)
}
func (m *UploadConversionAdjustmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UploadConversionAdjustmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UploadConversionAdjustmentsRequest proto.InternalMessageInfo

func (m *UploadConversionAdjustmentsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *UploadConversionAdjustmentsRequest) GetConversionAdjustments() []*ConversionAdjustment {
	if m != nil {
		return m.ConversionAdjustments
	}
	return nil
}

func (m *UploadConversionAdjustmentsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *UploadConversionAdjustmentsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// Response message for
// [ConversionAdjustmentUploadService.UploadConversionAdjustments][google.ads.googleads.v3.services.ConversionAdjustmentUploadService.UploadConversionAdjustments].
type UploadConversionAdjustmentsResponse struct {
	// Errors that pertain to conversion adjustment failures in the partial
	// failure mode. Returned when all errors occur inside the adjustments. If any
	// errors occur outside the adjustments (e.g. auth errors), we return an RPC
	// level error.
	PartialFailureError *status.Status `protobuf:"bytes,1,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// Returned for successfully processed conversion adjustments. Proto will be
	// empty for rows that received an error. Results are not returned when
	// validate_only is true.
	Results              []*ConversionAdjustmentResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *UploadConversionAdjustmentsResponse) Reset()         { *m = UploadConversionAdjustmentsResponse{} }
func (m *UploadConversionAdjustmentsResponse) String() string { return proto.CompactTextString(m) }
func (*UploadConversionAdjustmentsResponse) ProtoMessage()    {}
func (*UploadConversionAdjustmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dcef73f64d51915, []int{1}
}

func (m *UploadConversionAdjustmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UploadConversionAdjustmentsResponse.Unmarshal(m, b)
}
func (m *UploadConversionAdjustmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UploadConversionAdjustmentsResponse.Marshal(b, m, deterministic)
}
func (m *UploadConversionAdjustmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UploadConversionAdjustmentsResponse.Merge(m, src)
}
func (m *UploadConversionAdjustmentsResponse) XXX_Size() int {
	return xxx_messageInfo_UploadConversionAdjustmentsResponse.Size(m)
}
func (m *UploadConversionAdjustmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_UploadConversionAdjustmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_UploadConversionAdjustmentsResponse proto.InternalMessageInfo

func (m *UploadConversionAdjustmentsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *UploadConversionAdjustmentsResponse) GetResults() []*ConversionAdjustmentResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// A conversion adjustment.
type ConversionAdjustment struct {
	// Resource name of the conversion action associated with this conversion
	// adjustment. Note: Although this resource name consists of a customer id and
	// a conversion action id, validation will ignore the customer id and use the
	// conversion action id as the sole identifier of the conversion action.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,3,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The date time at which the adjustment occurred. Must be after the
	// conversion_date_time. The timezone must be specified. The format is
	// "yyyy-mm-dd hh:mm:ss+|-hh:mm", e.g. "2019-01-01 12:32:45-08:00".
	AdjustmentDateTime *wrappers.StringValue `protobuf:"bytes,4,opt,name=adjustment_date_time,json=adjustmentDateTime,proto3" json:"adjustment_date_time,omitempty"`
	// The adjustment type.
	AdjustmentType enums.ConversionAdjustmentTypeEnum_ConversionAdjustmentType `protobuf:"varint,5,opt,name=adjustment_type,json=adjustmentType,proto3,enum=google.ads.googleads.v3.enums.ConversionAdjustmentTypeEnum_ConversionAdjustmentType" json:"adjustment_type,omitempty"`
	// Information needed to restate the conversion's value.
	// Required for restatements. Should not be supplied for retractions. An error
	// will be returned if provided for a retraction.
	RestatementValue *RestatementValue `protobuf:"bytes,6,opt,name=restatement_value,json=restatementValue,proto3" json:"restatement_value,omitempty"`
	// Identifies the conversion to be adjusted.
	//
	// Types that are valid to be assigned to ConversionIdentifier:
	//	*ConversionAdjustment_GclidDateTimePair
	//	*ConversionAdjustment_OrderId
	ConversionIdentifier isConversionAdjustment_ConversionIdentifier `protobuf_oneof:"conversion_identifier"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *ConversionAdjustment) Reset()         { *m = ConversionAdjustment{} }
func (m *ConversionAdjustment) String() string { return proto.CompactTextString(m) }
func (*ConversionAdjustment) ProtoMessage()    {}
func (*ConversionAdjustment) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dcef73f64d51915, []int{2}
}

func (m *ConversionAdjustment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConversionAdjustment.Unmarshal(m, b)
}
func (m *ConversionAdjustment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConversionAdjustment.Marshal(b, m, deterministic)
}
func (m *ConversionAdjustment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConversionAdjustment.Merge(m, src)
}
func (m *ConversionAdjustment) XXX_Size() int {
	return xxx_messageInfo_ConversionAdjustment.Size(m)
}
func (m *ConversionAdjustment) XXX_DiscardUnknown() {
	xxx_messageInfo_ConversionAdjustment.DiscardUnknown(m)
}

var xxx_messageInfo_ConversionAdjustment proto.InternalMessageInfo

func (m *ConversionAdjustment) GetConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *ConversionAdjustment) GetAdjustmentDateTime() *wrappers.StringValue {
	if m != nil {
		return m.AdjustmentDateTime
	}
	return nil
}

func (m *ConversionAdjustment) GetAdjustmentType() enums.ConversionAdjustmentTypeEnum_ConversionAdjustmentType {
	if m != nil {
		return m.AdjustmentType
	}
	return enums.ConversionAdjustmentTypeEnum_UNSPECIFIED
}

func (m *ConversionAdjustment) GetRestatementValue() *RestatementValue {
	if m != nil {
		return m.RestatementValue
	}
	return nil
}

type isConversionAdjustment_ConversionIdentifier interface {
	isConversionAdjustment_ConversionIdentifier()
}

type ConversionAdjustment_GclidDateTimePair struct {
	GclidDateTimePair *GclidDateTimePair `protobuf:"bytes,1,opt,name=gclid_date_time_pair,json=gclidDateTimePair,proto3,oneof"`
}

type ConversionAdjustment_OrderId struct {
	OrderId *wrappers.StringValue `protobuf:"bytes,2,opt,name=order_id,json=orderId,proto3,oneof"`
}

func (*ConversionAdjustment_GclidDateTimePair) isConversionAdjustment_ConversionIdentifier() {}

func (*ConversionAdjustment_OrderId) isConversionAdjustment_ConversionIdentifier() {}

func (m *ConversionAdjustment) GetConversionIdentifier() isConversionAdjustment_ConversionIdentifier {
	if m != nil {
		return m.ConversionIdentifier
	}
	return nil
}

func (m *ConversionAdjustment) GetGclidDateTimePair() *GclidDateTimePair {
	if x, ok := m.GetConversionIdentifier().(*ConversionAdjustment_GclidDateTimePair); ok {
		return x.GclidDateTimePair
	}
	return nil
}

func (m *ConversionAdjustment) GetOrderId() *wrappers.StringValue {
	if x, ok := m.GetConversionIdentifier().(*ConversionAdjustment_OrderId); ok {
		return x.OrderId
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ConversionAdjustment) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ConversionAdjustment_GclidDateTimePair)(nil),
		(*ConversionAdjustment_OrderId)(nil),
	}
}

// Contains information needed to restate a conversion's value.
type RestatementValue struct {
	// The restated conversion value. This is the value of the conversion after
	// restatement. For example, to change the value of a conversion from 100 to
	// 70, an adjusted value of 70 should be reported.
	AdjustedValue *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=adjusted_value,json=adjustedValue,proto3" json:"adjusted_value,omitempty"`
	// The currency of the restated value. If not provided, then the default
	// currency from the conversion action is used, and if that is not set then
	// the account currency is used. This is the ISO 4217 3-character currency
	// code e.g. USD or EUR.
	CurrencyCode         *wrappers.StringValue `protobuf:"bytes,2,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *RestatementValue) Reset()         { *m = RestatementValue{} }
func (m *RestatementValue) String() string { return proto.CompactTextString(m) }
func (*RestatementValue) ProtoMessage()    {}
func (*RestatementValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dcef73f64d51915, []int{3}
}

func (m *RestatementValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestatementValue.Unmarshal(m, b)
}
func (m *RestatementValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestatementValue.Marshal(b, m, deterministic)
}
func (m *RestatementValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestatementValue.Merge(m, src)
}
func (m *RestatementValue) XXX_Size() int {
	return xxx_messageInfo_RestatementValue.Size(m)
}
func (m *RestatementValue) XXX_DiscardUnknown() {
	xxx_messageInfo_RestatementValue.DiscardUnknown(m)
}

var xxx_messageInfo_RestatementValue proto.InternalMessageInfo

func (m *RestatementValue) GetAdjustedValue() *wrappers.DoubleValue {
	if m != nil {
		return m.AdjustedValue
	}
	return nil
}

func (m *RestatementValue) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

// Uniquely identifies a conversion that was reported without an order ID
// specified.
type GclidDateTimePair struct {
	// Google click ID (gclid) associated with the original conversion for this
	// adjustment.
	Gclid *wrappers.StringValue `protobuf:"bytes,1,opt,name=gclid,proto3" json:"gclid,omitempty"`
	// The date time at which the original conversion for this adjustment
	// occurred. The timezone must be specified. The format is "yyyy-mm-dd
	// hh:mm:ss+|-hh:mm", e.g. "2019-01-01 12:32:45-08:00".
	ConversionDateTime   *wrappers.StringValue `protobuf:"bytes,2,opt,name=conversion_date_time,json=conversionDateTime,proto3" json:"conversion_date_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GclidDateTimePair) Reset()         { *m = GclidDateTimePair{} }
func (m *GclidDateTimePair) String() string { return proto.CompactTextString(m) }
func (*GclidDateTimePair) ProtoMessage()    {}
func (*GclidDateTimePair) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dcef73f64d51915, []int{4}
}

func (m *GclidDateTimePair) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GclidDateTimePair.Unmarshal(m, b)
}
func (m *GclidDateTimePair) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GclidDateTimePair.Marshal(b, m, deterministic)
}
func (m *GclidDateTimePair) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GclidDateTimePair.Merge(m, src)
}
func (m *GclidDateTimePair) XXX_Size() int {
	return xxx_messageInfo_GclidDateTimePair.Size(m)
}
func (m *GclidDateTimePair) XXX_DiscardUnknown() {
	xxx_messageInfo_GclidDateTimePair.DiscardUnknown(m)
}

var xxx_messageInfo_GclidDateTimePair proto.InternalMessageInfo

func (m *GclidDateTimePair) GetGclid() *wrappers.StringValue {
	if m != nil {
		return m.Gclid
	}
	return nil
}

func (m *GclidDateTimePair) GetConversionDateTime() *wrappers.StringValue {
	if m != nil {
		return m.ConversionDateTime
	}
	return nil
}

// Information identifying a successfully processed ConversionAdjustment.
type ConversionAdjustmentResult struct {
	// Resource name of the conversion action associated with this conversion
	// adjustment.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,3,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The date time at which the adjustment occurred. The format is
	// "yyyy-mm-dd hh:mm:ss+|-hh:mm", e.g. "2019-01-01 12:32:45-08:00".
	AdjustmentDateTime *wrappers.StringValue `protobuf:"bytes,4,opt,name=adjustment_date_time,json=adjustmentDateTime,proto3" json:"adjustment_date_time,omitempty"`
	// The adjustment type.
	AdjustmentType enums.ConversionAdjustmentTypeEnum_ConversionAdjustmentType `protobuf:"varint,5,opt,name=adjustment_type,json=adjustmentType,proto3,enum=google.ads.googleads.v3.enums.ConversionAdjustmentTypeEnum_ConversionAdjustmentType" json:"adjustment_type,omitempty"`
	// Identifies the conversion that was adjusted.
	//
	// Types that are valid to be assigned to ConversionIdentifier:
	//	*ConversionAdjustmentResult_GclidDateTimePair
	//	*ConversionAdjustmentResult_OrderId
	ConversionIdentifier isConversionAdjustmentResult_ConversionIdentifier `protobuf_oneof:"conversion_identifier"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *ConversionAdjustmentResult) Reset()         { *m = ConversionAdjustmentResult{} }
func (m *ConversionAdjustmentResult) String() string { return proto.CompactTextString(m) }
func (*ConversionAdjustmentResult) ProtoMessage()    {}
func (*ConversionAdjustmentResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dcef73f64d51915, []int{5}
}

func (m *ConversionAdjustmentResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConversionAdjustmentResult.Unmarshal(m, b)
}
func (m *ConversionAdjustmentResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConversionAdjustmentResult.Marshal(b, m, deterministic)
}
func (m *ConversionAdjustmentResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConversionAdjustmentResult.Merge(m, src)
}
func (m *ConversionAdjustmentResult) XXX_Size() int {
	return xxx_messageInfo_ConversionAdjustmentResult.Size(m)
}
func (m *ConversionAdjustmentResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ConversionAdjustmentResult.DiscardUnknown(m)
}

var xxx_messageInfo_ConversionAdjustmentResult proto.InternalMessageInfo

func (m *ConversionAdjustmentResult) GetConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *ConversionAdjustmentResult) GetAdjustmentDateTime() *wrappers.StringValue {
	if m != nil {
		return m.AdjustmentDateTime
	}
	return nil
}

func (m *ConversionAdjustmentResult) GetAdjustmentType() enums.ConversionAdjustmentTypeEnum_ConversionAdjustmentType {
	if m != nil {
		return m.AdjustmentType
	}
	return enums.ConversionAdjustmentTypeEnum_UNSPECIFIED
}

type isConversionAdjustmentResult_ConversionIdentifier interface {
	isConversionAdjustmentResult_ConversionIdentifier()
}

type ConversionAdjustmentResult_GclidDateTimePair struct {
	GclidDateTimePair *GclidDateTimePair `protobuf:"bytes,1,opt,name=gclid_date_time_pair,json=gclidDateTimePair,proto3,oneof"`
}

type ConversionAdjustmentResult_OrderId struct {
	OrderId *wrappers.StringValue `protobuf:"bytes,2,opt,name=order_id,json=orderId,proto3,oneof"`
}

func (*ConversionAdjustmentResult_GclidDateTimePair) isConversionAdjustmentResult_ConversionIdentifier() {
}

func (*ConversionAdjustmentResult_OrderId) isConversionAdjustmentResult_ConversionIdentifier() {}

func (m *ConversionAdjustmentResult) GetConversionIdentifier() isConversionAdjustmentResult_ConversionIdentifier {
	if m != nil {
		return m.ConversionIdentifier
	}
	return nil
}

func (m *ConversionAdjustmentResult) GetGclidDateTimePair() *GclidDateTimePair {
	if x, ok := m.GetConversionIdentifier().(*ConversionAdjustmentResult_GclidDateTimePair); ok {
		return x.GclidDateTimePair
	}
	return nil
}

func (m *ConversionAdjustmentResult) GetOrderId() *wrappers.StringValue {
	if x, ok := m.GetConversionIdentifier().(*ConversionAdjustmentResult_OrderId); ok {
		return x.OrderId
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ConversionAdjustmentResult) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ConversionAdjustmentResult_GclidDateTimePair)(nil),
		(*ConversionAdjustmentResult_OrderId)(nil),
	}
}

func init() {
	proto.RegisterType((*UploadConversionAdjustmentsRequest)(nil), "google.ads.googleads.v3.services.UploadConversionAdjustmentsRequest")
	proto.RegisterType((*UploadConversionAdjustmentsResponse)(nil), "google.ads.googleads.v3.services.UploadConversionAdjustmentsResponse")
	proto.RegisterType((*ConversionAdjustment)(nil), "google.ads.googleads.v3.services.ConversionAdjustment")
	proto.RegisterType((*RestatementValue)(nil), "google.ads.googleads.v3.services.RestatementValue")
	proto.RegisterType((*GclidDateTimePair)(nil), "google.ads.googleads.v3.services.GclidDateTimePair")
	proto.RegisterType((*ConversionAdjustmentResult)(nil), "google.ads.googleads.v3.services.ConversionAdjustmentResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/conversion_adjustment_upload_service.proto", fileDescriptor_0dcef73f64d51915)
}

var fileDescriptor_0dcef73f64d51915 = []byte{
	// 902 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x56, 0xcf, 0x8b, 0xe4, 0x44,
	0x14, 0xde, 0xa4, 0xf7, 0x97, 0x35, 0x3b, 0xb3, 0x3b, 0xe5, 0xac, 0xdb, 0xf4, 0x2e, 0xda, 0x66,
	0x07, 0x19, 0x96, 0x21, 0x81, 0x6e, 0x10, 0x36, 0xea, 0x42, 0xe6, 0xc7, 0xce, 0x0c, 0x82, 0x0e,
	0x99, 0xb1, 0x0f, 0x32, 0x10, 0xaa, 0x53, 0xd5, 0xb1, 0x24, 0xa9, 0x8a, 0x55, 0x95, 0x96, 0x46,
	0xf6, 0xe2, 0xdd, 0x83, 0x78, 0x10, 0x3c, 0x0a, 0x5e, 0xfc, 0x3f, 0xbc, 0x2c, 0x78, 0xf2, 0xe6,
	0xc9, 0x83, 0x07, 0xf1, 0xe8, 0x5f, 0x20, 0xf9, 0x51, 0xdd, 0xd9, 0xb6, 0xb3, 0x59, 0xf4, 0x24,
	0xec, 0xad, 0x52, 0xef, 0x7b, 0xdf, 0xfb, 0xea, 0xab, 0xf7, 0xa8, 0x80, 0xf7, 0x23, 0xce, 0xa3,
	0x98, 0x38, 0x08, 0x4b, 0xa7, 0x5c, 0xe6, 0xab, 0xe9, 0xd0, 0x91, 0x44, 0x4c, 0x69, 0x48, 0xa4,
	0x13, 0x72, 0x36, 0x25, 0x42, 0x52, 0xce, 0x02, 0x84, 0x3f, 0xcd, 0xa4, 0x4a, 0x08, 0x53, 0x41,
	0x96, 0xc6, 0x1c, 0xe1, 0xa0, 0x42, 0xd9, 0xa9, 0xe0, 0x8a, 0xc3, 0x7e, 0xc9, 0x60, 0x23, 0x2c,
	0xed, 0x39, 0x99, 0x3d, 0x1d, 0xda, 0x9a, 0xac, 0xf7, 0xa8, 0xa9, 0x1c, 0x61, 0x59, 0xd2, 0x54,
	0x4b, 0xcd, 0xd2, 0xaa, 0x42, 0xef, 0x9e, 0xce, 0x4f, 0xa9, 0x83, 0x18, 0xe3, 0x0a, 0x29, 0xca,
	0x99, 0xac, 0xa2, 0x77, 0x6a, 0xd1, 0x30, 0xa6, 0x84, 0xa9, 0x2a, 0xf0, 0x46, 0x2d, 0x30, 0xa1,
	0x24, 0xc6, 0xc1, 0x98, 0x7c, 0x82, 0xa6, 0x94, 0x8b, 0x0a, 0xf0, 0x7a, 0x05, 0x28, 0xbe, 0xc6,
	0xd9, 0xc4, 0xf9, 0x5c, 0xa0, 0x34, 0x25, 0x62, 0x99, 0x59, 0xa4, 0xa1, 0x23, 0x15, 0x52, 0x59,
	0x15, 0xb0, 0xbe, 0x36, 0x81, 0xf5, 0x51, 0xe1, 0xc5, 0xfe, 0x5c, 0xbb, 0x37, 0x97, 0x2e, 0x7d,
	0xf2, 0x59, 0x46, 0xa4, 0x82, 0xdb, 0x60, 0x2d, 0xcc, 0xa4, 0xe2, 0x09, 0x11, 0x01, 0xc5, 0x5d,
	0xa3, 0x6f, 0xec, 0xbc, 0xb2, 0xd7, 0xf9, 0xcd, 0x33, 0x7d, 0xa0, 0xf7, 0x4f, 0x30, 0x14, 0xe0,
	0xb5, 0x95, 0x0e, 0xc8, 0xae, 0xd9, 0xef, 0xec, 0xac, 0x0d, 0xde, 0xb6, 0xdb, 0x0c, 0xb6, 0x57,
	0xa9, 0x28, 0x0b, 0xdd, 0x0e, 0x57, 0x09, 0x84, 0xbb, 0xe0, 0x66, 0x8a, 0x84, 0xa2, 0x28, 0x0e,
	0x26, 0x88, 0xc6, 0x99, 0x20, 0xdd, 0x4e, 0xdf, 0xd8, 0xb9, 0x5e, 0x26, 0x6d, 0x54, 0xb1, 0xc7,
	0x65, 0x08, 0xde, 0x07, 0xeb, 0x53, 0x14, 0x53, 0x8c, 0x14, 0x09, 0x38, 0x8b, 0x67, 0xdd, 0xcb,
	0x39, 0xd6, 0xbf, 0xa1, 0x37, 0x3f, 0x64, 0xf1, 0xcc, 0xfa, 0xc9, 0x00, 0xf7, 0x9f, 0xeb, 0x89,
	0x4c, 0x39, 0x93, 0x04, 0x3e, 0x06, 0xb7, 0x97, 0x4a, 0x07, 0x44, 0x08, 0x2e, 0x0a, 0x7b, 0xd6,
	0x06, 0x50, 0x9f, 0x56, 0xa4, 0xa1, 0x7d, 0x56, 0x98, 0xee, 0xbf, 0xfa, 0xac, 0x9e, 0xc3, 0x1c,
	0x0e, 0x47, 0xe0, 0x9a, 0x20, 0x32, 0x8b, 0xe7, 0x3e, 0xbd, 0xfb, 0xef, 0x7c, 0xf2, 0x0b, 0x12,
	0x5f, 0x93, 0x59, 0x3f, 0x5f, 0x06, 0x5b, 0xab, 0x70, 0xf0, 0x04, 0x6c, 0xd6, 0xef, 0x29, 0xcc,
	0x7b, 0xb0, 0x70, 0x6d, 0x6d, 0x70, 0x4f, 0x97, 0xd6, 0x9d, 0x64, 0x9f, 0x29, 0x41, 0x59, 0x34,
	0x42, 0x71, 0x46, 0xfc, 0x5b, 0xb5, 0x3b, 0x28, 0xb2, 0xe0, 0x07, 0x60, 0xab, 0xd6, 0xe9, 0x85,
	0xaf, 0x8a, 0x26, 0xa4, 0xf0, 0xb5, 0x8d, 0x0d, 0x2e, 0x32, 0x0f, 0x90, 0x22, 0xe7, 0x34, 0x21,
	0xf0, 0x09, 0xb8, 0xb9, 0x34, 0x39, 0xdd, 0x2b, 0x7d, 0x63, 0x67, 0x63, 0x70, 0xde, 0xe8, 0x49,
	0x31, 0x7a, 0x2b, 0x0d, 0x39, 0x9f, 0xa5, 0xe4, 0x90, 0x65, 0x49, 0x63, 0xd0, 0xdf, 0x40, 0xcf,
	0x7c, 0xc3, 0x00, 0x6c, 0x0a, 0x92, 0x0f, 0x08, 0x29, 0xea, 0x4f, 0x73, 0x9d, 0xdd, 0xab, 0xc5,
	0x59, 0x06, 0xed, 0x97, 0xe2, 0x2f, 0x52, 0x2b, 0xbf, 0xc4, 0xd2, 0x0e, 0x9c, 0x80, 0xad, 0x28,
	0x8c, 0x29, 0x5e, 0x58, 0x15, 0xa4, 0x88, 0xea, 0x96, 0x19, 0xb6, 0xd7, 0x38, 0xca, 0xb3, 0xb5,
	0x5d, 0xa7, 0x88, 0x8a, 0xe3, 0x4b, 0xfe, 0x66, 0xb4, 0xbc, 0x09, 0x1f, 0x82, 0xeb, 0x5c, 0xe0,
	0x72, 0x5a, 0xcd, 0xf6, 0xbb, 0x38, 0xbe, 0xe4, 0x5f, 0x2b, 0xf0, 0x27, 0x78, 0xef, 0x0e, 0xa8,
	0x8d, 0x5a, 0x40, 0x31, 0x61, 0x8a, 0x4e, 0x28, 0x11, 0xd6, 0x77, 0x06, 0xb8, 0xb5, 0x7c, 0x44,
	0xb8, 0x0f, 0x2a, 0x0f, 0x09, 0xae, 0xec, 0x32, 0x1a, 0xca, 0x1d, 0xf0, 0x6c, 0x1c, 0x93, 0xd2,
	0x98, 0x75, 0x9d, 0x53, 0x92, 0x78, 0x60, 0x3d, 0xcc, 0x84, 0x20, 0x2c, 0x9c, 0x05, 0x21, 0xc7,
	0xe4, 0x45, 0x24, 0xfb, 0x37, 0x74, 0xca, 0x3e, 0xc7, 0xc4, 0xfa, 0xd6, 0x00, 0x9b, 0xff, 0xf0,
	0x06, 0x0e, 0xc0, 0x95, 0xc2, 0x9b, 0x46, 0x51, 0x75, 0xc2, 0x12, 0x9a, 0xb7, 0x74, 0xed, 0xfc,
	0x8b, 0x96, 0x7e, 0x11, 0x4d, 0x70, 0x91, 0xa9, 0x75, 0x58, 0x7f, 0x75, 0x40, 0xaf, 0x79, 0x5c,
	0x5f, 0x0e, 0x63, 0xe3, 0x30, 0xfe, 0x8f, 0x67, 0x65, 0xf0, 0x87, 0x09, 0xde, 0x5c, 0x75, 0xd0,
	0xf2, 0x5d, 0x39, 0x2b, 0x15, 0xc2, 0x1f, 0x4c, 0x70, 0xf7, 0x39, 0x2f, 0x0d, 0x3c, 0x68, 0x3f,
	0x63, 0xfb, 0xe3, 0xdd, 0x3b, 0xfc, 0x8f, 0x2c, 0xe5, 0x73, 0x67, 0xcd, 0x7e, 0xf5, 0x06, 0xb5,
	0x9f, 0x80, 0xdd, 0xd5, 0x4f, 0xfd, 0xee, 0xd2, 0x93, 0xf8, 0xe5, 0x2f, 0xbf, 0x7f, 0x63, 0x3e,
	0xb2, 0x1e, 0xe6, 0x3f, 0x49, 0x3a, 0x5b, 0x3a, 0x5f, 0xd4, 0x88, 0xde, 0x7b, 0xf0, 0xc4, 0xcd,
	0x9a, 0xeb, 0xbb, 0xc6, 0x83, 0xde, 0xdd, 0xa7, 0x5e, 0x77, 0x21, 0xbc, 0x5a, 0xa5, 0x54, 0xda,
	0x21, 0x4f, 0xf6, 0xbe, 0x32, 0xc1, 0x76, 0xc8, 0x93, 0xd6, 0x43, 0xee, 0xbd, 0xd5, 0x7a, 0x21,
	0xa7, 0xf9, 0x75, 0x9f, 0x1a, 0x1f, 0x1f, 0x57, 0x5c, 0x11, 0x8f, 0x11, 0x8b, 0x6c, 0x2e, 0x22,
	0x27, 0x22, 0xac, 0x68, 0x06, 0x67, 0x51, 0xbd, 0xf9, 0xa7, 0xf3, 0x1d, 0xbd, 0xf8, 0xde, 0xec,
	0x1c, 0x79, 0xde, 0x8f, 0x66, 0xff, 0xa8, 0x24, 0xf4, 0xb0, 0xb4, 0xcb, 0x65, 0xbe, 0x1a, 0x0d,
	0xed, 0xaa, 0xb0, 0x7c, 0xaa, 0x21, 0x17, 0x1e, 0x96, 0x17, 0x73, 0xc8, 0xc5, 0x68, 0x78, 0xa1,
	0x21, 0x7f, 0x9a, 0xdb, 0xe5, 0xbe, 0xeb, 0x7a, 0x58, 0xba, 0xee, 0x1c, 0xe4, 0xba, 0xa3, 0xa1,
	0xeb, 0x6a, 0xd8, 0xf8, 0x6a, 0xa1, 0x73, 0xf8, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0x3d, 0xc0,
	0x22, 0x0a, 0x1b, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConversionAdjustmentUploadServiceClient is the client API for ConversionAdjustmentUploadService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConversionAdjustmentUploadServiceClient interface {
	// Processes the given conversion adjustments.
	UploadConversionAdjustments(ctx context.Context, in *UploadConversionAdjustmentsRequest, opts ...grpc.CallOption) (*UploadConversionAdjustmentsResponse, error)
}

type conversionAdjustmentUploadServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewConversionAdjustmentUploadServiceClient(cc grpc.ClientConnInterface) ConversionAdjustmentUploadServiceClient {
	return &conversionAdjustmentUploadServiceClient{cc}
}

func (c *conversionAdjustmentUploadServiceClient) UploadConversionAdjustments(ctx context.Context, in *UploadConversionAdjustmentsRequest, opts ...grpc.CallOption) (*UploadConversionAdjustmentsResponse, error) {
	out := new(UploadConversionAdjustmentsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.ConversionAdjustmentUploadService/UploadConversionAdjustments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversionAdjustmentUploadServiceServer is the server API for ConversionAdjustmentUploadService service.
type ConversionAdjustmentUploadServiceServer interface {
	// Processes the given conversion adjustments.
	UploadConversionAdjustments(context.Context, *UploadConversionAdjustmentsRequest) (*UploadConversionAdjustmentsResponse, error)
}

// UnimplementedConversionAdjustmentUploadServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConversionAdjustmentUploadServiceServer struct {
}

func (*UnimplementedConversionAdjustmentUploadServiceServer) UploadConversionAdjustments(ctx context.Context, req *UploadConversionAdjustmentsRequest) (*UploadConversionAdjustmentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UploadConversionAdjustments not implemented")
}

func RegisterConversionAdjustmentUploadServiceServer(s *grpc.Server, srv ConversionAdjustmentUploadServiceServer) {
	s.RegisterService(&_ConversionAdjustmentUploadService_serviceDesc, srv)
}

func _ConversionAdjustmentUploadService_UploadConversionAdjustments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UploadConversionAdjustmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversionAdjustmentUploadServiceServer).UploadConversionAdjustments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.ConversionAdjustmentUploadService/UploadConversionAdjustments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversionAdjustmentUploadServiceServer).UploadConversionAdjustments(ctx, req.(*UploadConversionAdjustmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConversionAdjustmentUploadService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.ConversionAdjustmentUploadService",
	HandlerType: (*ConversionAdjustmentUploadServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UploadConversionAdjustments",
			Handler:    _ConversionAdjustmentUploadService_UploadConversionAdjustments_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/conversion_adjustment_upload_service.proto",
}
