// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/chromeos/moblab/v1beta1/build_service.proto

package moblab

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for listing builds.
// NEXT_TAG: 7
type ListBuildsRequest struct {
	// Required. The full resource name of the model. The model id is the same as
	// the build target id for non-unified builds.
	// For example,
	// 'buildTargets/octopus/models/bobba'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The number of builds to return in a page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListBuilds` call. Provide this to
	// retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter that specifies value constraints of fields. For example, the
	// filter can be set as "filter='milestone=milestones/80'" to only select
	// builds in milestone 80.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Read mask that specifies which Build fields to return. If empty, all Build
	// fields will be returned.
	// Valid fields: name, milestone, build_version.
	// For example, if the read_mask is set as "read_mask='milestone'", the
	// ListBuilds will return a list of Builds object with only the milestone
	// field.
	ReadMask *field_mask.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// Optional. The operation that groups by all the Build fields specified in the read
	// mask. The group_by field should be the same as the read_mask field in
	// convention of SQL.
	GroupBy              *field_mask.FieldMask `protobuf:"bytes,6,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListBuildsRequest) Reset()         { *m = ListBuildsRequest{} }
func (m *ListBuildsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBuildsRequest) ProtoMessage()    {}
func (*ListBuildsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{0}
}

func (m *ListBuildsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildsRequest.Unmarshal(m, b)
}
func (m *ListBuildsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildsRequest.Marshal(b, m, deterministic)
}
func (m *ListBuildsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildsRequest.Merge(m, src)
}
func (m *ListBuildsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBuildsRequest.Size(m)
}
func (m *ListBuildsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildsRequest proto.InternalMessageInfo

func (m *ListBuildsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListBuildsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBuildsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListBuildsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListBuildsRequest) GetReadMask() *field_mask.FieldMask {
	if m != nil {
		return m.ReadMask
	}
	return nil
}

func (m *ListBuildsRequest) GetGroupBy() *field_mask.FieldMask {
	if m != nil {
		return m.GroupBy
	}
	return nil
}

// Response message for listing builds.
// NEXT_TAG: 4
type ListBuildsResponse struct {
	// The list of builds.
	Builds []*Build `protobuf:"bytes,1,rep,name=builds,proto3" json:"builds,omitempty"`
	// Token to retrieve the next page of builds. If this field is omitted, there
	// are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of builds.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBuildsResponse) Reset()         { *m = ListBuildsResponse{} }
func (m *ListBuildsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBuildsResponse) ProtoMessage()    {}
func (*ListBuildsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{1}
}

func (m *ListBuildsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildsResponse.Unmarshal(m, b)
}
func (m *ListBuildsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildsResponse.Marshal(b, m, deterministic)
}
func (m *ListBuildsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildsResponse.Merge(m, src)
}
func (m *ListBuildsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBuildsResponse.Size(m)
}
func (m *ListBuildsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildsResponse proto.InternalMessageInfo

func (m *ListBuildsResponse) GetBuilds() []*Build {
	if m != nil {
		return m.Builds
	}
	return nil
}

func (m *ListBuildsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListBuildsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for checking if the build artifact is staged.
type CheckBuildStageStatusRequest struct {
	// Required. The full resource name of the build artifact.
	// For example,
	// 'buildTargets/octopus/models/bobba/builds/12607.6.0/artifacts/chromeos-moblab-peng-staging'.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckBuildStageStatusRequest) Reset()         { *m = CheckBuildStageStatusRequest{} }
func (m *CheckBuildStageStatusRequest) String() string { return proto.CompactTextString(m) }
func (*CheckBuildStageStatusRequest) ProtoMessage()    {}
func (*CheckBuildStageStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{2}
}

func (m *CheckBuildStageStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckBuildStageStatusRequest.Unmarshal(m, b)
}
func (m *CheckBuildStageStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckBuildStageStatusRequest.Marshal(b, m, deterministic)
}
func (m *CheckBuildStageStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckBuildStageStatusRequest.Merge(m, src)
}
func (m *CheckBuildStageStatusRequest) XXX_Size() int {
	return xxx_messageInfo_CheckBuildStageStatusRequest.Size(m)
}
func (m *CheckBuildStageStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckBuildStageStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckBuildStageStatusRequest proto.InternalMessageInfo

func (m *CheckBuildStageStatusRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for checking the stage status of a build artifact.
// NEXT_TAG: 4
type CheckBuildStageStatusResponse struct {
	// The status to represent if the build is staged or not.
	IsBuildStaged bool `protobuf:"varint,1,opt,name=is_build_staged,json=isBuildStaged,proto3" json:"is_build_staged,omitempty"`
	// The staged build artifact in the destination bucket.
	StagedBuildArtifact *BuildArtifact `protobuf:"bytes,2,opt,name=staged_build_artifact,json=stagedBuildArtifact,proto3" json:"staged_build_artifact,omitempty"`
	// The source build artifact in the source bucket.
	SourceBuildArtifact  *BuildArtifact `protobuf:"bytes,3,opt,name=source_build_artifact,json=sourceBuildArtifact,proto3" json:"source_build_artifact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CheckBuildStageStatusResponse) Reset()         { *m = CheckBuildStageStatusResponse{} }
func (m *CheckBuildStageStatusResponse) String() string { return proto.CompactTextString(m) }
func (*CheckBuildStageStatusResponse) ProtoMessage()    {}
func (*CheckBuildStageStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{3}
}

func (m *CheckBuildStageStatusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckBuildStageStatusResponse.Unmarshal(m, b)
}
func (m *CheckBuildStageStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckBuildStageStatusResponse.Marshal(b, m, deterministic)
}
func (m *CheckBuildStageStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckBuildStageStatusResponse.Merge(m, src)
}
func (m *CheckBuildStageStatusResponse) XXX_Size() int {
	return xxx_messageInfo_CheckBuildStageStatusResponse.Size(m)
}
func (m *CheckBuildStageStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckBuildStageStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckBuildStageStatusResponse proto.InternalMessageInfo

func (m *CheckBuildStageStatusResponse) GetIsBuildStaged() bool {
	if m != nil {
		return m.IsBuildStaged
	}
	return false
}

func (m *CheckBuildStageStatusResponse) GetStagedBuildArtifact() *BuildArtifact {
	if m != nil {
		return m.StagedBuildArtifact
	}
	return nil
}

func (m *CheckBuildStageStatusResponse) GetSourceBuildArtifact() *BuildArtifact {
	if m != nil {
		return m.SourceBuildArtifact
	}
	return nil
}

// Request message for staging a build artifact.
type StageBuildRequest struct {
	// Required. The full resource name of the build artifact.
	// For example,
	// 'buildTargets/octopus/models/bobba/builds/12607.6.0/artifacts/chromeos-moblab-peng-staging'.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StageBuildRequest) Reset()         { *m = StageBuildRequest{} }
func (m *StageBuildRequest) String() string { return proto.CompactTextString(m) }
func (*StageBuildRequest) ProtoMessage()    {}
func (*StageBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{4}
}

func (m *StageBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageBuildRequest.Unmarshal(m, b)
}
func (m *StageBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageBuildRequest.Marshal(b, m, deterministic)
}
func (m *StageBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageBuildRequest.Merge(m, src)
}
func (m *StageBuildRequest) XXX_Size() int {
	return xxx_messageInfo_StageBuildRequest.Size(m)
}
func (m *StageBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StageBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StageBuildRequest proto.InternalMessageInfo

func (m *StageBuildRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for staging a build artifact.
type StageBuildResponse struct {
	// The staged build in the destination bucket.
	StagedBuildArtifact  *BuildArtifact `protobuf:"bytes,1,opt,name=staged_build_artifact,json=stagedBuildArtifact,proto3" json:"staged_build_artifact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *StageBuildResponse) Reset()         { *m = StageBuildResponse{} }
func (m *StageBuildResponse) String() string { return proto.CompactTextString(m) }
func (*StageBuildResponse) ProtoMessage()    {}
func (*StageBuildResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{5}
}

func (m *StageBuildResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageBuildResponse.Unmarshal(m, b)
}
func (m *StageBuildResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageBuildResponse.Marshal(b, m, deterministic)
}
func (m *StageBuildResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageBuildResponse.Merge(m, src)
}
func (m *StageBuildResponse) XXX_Size() int {
	return xxx_messageInfo_StageBuildResponse.Size(m)
}
func (m *StageBuildResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StageBuildResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StageBuildResponse proto.InternalMessageInfo

func (m *StageBuildResponse) GetStagedBuildArtifact() *BuildArtifact {
	if m != nil {
		return m.StagedBuildArtifact
	}
	return nil
}

// Metadata message for staging a build artifact.
// NEXT_TAG: 4
type StageBuildMetadata struct {
	// Approximate percentage of progress, e.g. "50" means 50%.
	ProgressPercent float32 `protobuf:"fixed32,1,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Build stage start time.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Build stage end time.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StageBuildMetadata) Reset()         { *m = StageBuildMetadata{} }
func (m *StageBuildMetadata) String() string { return proto.CompactTextString(m) }
func (*StageBuildMetadata) ProtoMessage()    {}
func (*StageBuildMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{6}
}

func (m *StageBuildMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageBuildMetadata.Unmarshal(m, b)
}
func (m *StageBuildMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageBuildMetadata.Marshal(b, m, deterministic)
}
func (m *StageBuildMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageBuildMetadata.Merge(m, src)
}
func (m *StageBuildMetadata) XXX_Size() int {
	return xxx_messageInfo_StageBuildMetadata.Size(m)
}
func (m *StageBuildMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StageBuildMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StageBuildMetadata proto.InternalMessageInfo

func (m *StageBuildMetadata) GetProgressPercent() float32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *StageBuildMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *StageBuildMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func init() {
	proto.RegisterType((*ListBuildsRequest)(nil), "google.chromeos.moblab.v1beta1.ListBuildsRequest")
	proto.RegisterType((*ListBuildsResponse)(nil), "google.chromeos.moblab.v1beta1.ListBuildsResponse")
	proto.RegisterType((*CheckBuildStageStatusRequest)(nil), "google.chromeos.moblab.v1beta1.CheckBuildStageStatusRequest")
	proto.RegisterType((*CheckBuildStageStatusResponse)(nil), "google.chromeos.moblab.v1beta1.CheckBuildStageStatusResponse")
	proto.RegisterType((*StageBuildRequest)(nil), "google.chromeos.moblab.v1beta1.StageBuildRequest")
	proto.RegisterType((*StageBuildResponse)(nil), "google.chromeos.moblab.v1beta1.StageBuildResponse")
	proto.RegisterType((*StageBuildMetadata)(nil), "google.chromeos.moblab.v1beta1.StageBuildMetadata")
}

func init() {
	proto.RegisterFile("google/chromeos/moblab/v1beta1/build_service.proto", fileDescriptor_14f08d110278057f)
}

var fileDescriptor_14f08d110278057f = []byte{
	// 917 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xd7, 0xda, 0x8d, 0x1b, 0xbf, 0x50, 0x85, 0x0c, 0xaa, 0x30, 0xa6, 0x01, 0x6b, 0xab, 0x56,
	0x6e, 0xaa, 0xee, 0x12, 0x57, 0x1c, 0x08, 0xcd, 0x61, 0xdd, 0x8a, 0x72, 0x68, 0x44, 0xd8, 0xe6,
	0x84, 0x90, 0xac, 0xf1, 0x7a, 0xb2, 0x1e, 0x65, 0x77, 0x66, 0x99, 0x19, 0x27, 0xb4, 0x08, 0x21,
	0xb8, 0x73, 0xe2, 0xc6, 0xb7, 0xe0, 0x00, 0x1f, 0xa2, 0x47, 0xb8, 0xf5, 0x42, 0x91, 0x90, 0xf8,
	0x0e, 0x9c, 0xd0, 0xfc, 0x59, 0x7b, 0xf3, 0xcf, 0x2e, 0x6d, 0x8e, 0xf3, 0xe6, 0xfd, 0xde, 0x7b,
	0xbf, 0xdf, 0x9b, 0xf7, 0x76, 0xa1, 0x97, 0x72, 0x9e, 0x66, 0x24, 0x4c, 0xc6, 0x82, 0xe7, 0x84,
	0xcb, 0x30, 0xe7, 0xc3, 0x0c, 0x0f, 0xc3, 0xc3, 0xcd, 0x21, 0x51, 0x78, 0x33, 0x1c, 0x4e, 0x68,
	0x36, 0x1a, 0x48, 0x22, 0x0e, 0x69, 0x42, 0x82, 0x42, 0x70, 0xc5, 0xd1, 0x7b, 0x16, 0x13, 0x94,
	0x98, 0xc0, 0x62, 0x02, 0x87, 0x69, 0x5f, 0x73, 0x31, 0x71, 0x41, 0x43, 0xcc, 0x18, 0x57, 0x58,
	0x51, 0xce, 0xa4, 0x45, 0xb7, 0xdf, 0xae, 0xdc, 0x26, 0x19, 0x25, 0x4c, 0xb9, 0x8b, 0xf7, 0x2b,
	0x17, 0xfb, 0x94, 0x64, 0xa3, 0xc1, 0x90, 0x8c, 0xf1, 0x21, 0xe5, 0xc2, 0x39, 0xbc, 0x53, 0x71,
	0x10, 0x44, 0xf2, 0x89, 0x28, 0x4b, 0x6a, 0x07, 0x0b, 0x68, 0x94, 0xee, 0x65, 0x11, 0xd7, 0x9d,
	0x7f, 0xc6, 0x59, 0x2a, 0x26, 0x8c, 0x51, 0x96, 0x86, 0xbc, 0x20, 0xe2, 0x58, 0xa5, 0x1d, 0xe7,
	0x64, 0x4e, 0xc3, 0xc9, 0xbe, 0xab, 0x2a, 0xc7, 0xf2, 0xe0, 0x44, 0xc9, 0x53, 0x0f, 0x45, 0x73,
	0x22, 0x15, 0xce, 0x0b, 0xeb, 0xe0, 0xff, 0x5a, 0x83, 0xb5, 0x47, 0x54, 0xaa, 0xbe, 0x96, 0x51,
	0xc6, 0xe4, 0xab, 0x09, 0x91, 0x0a, 0xdd, 0x87, 0x46, 0x81, 0x05, 0x61, 0xaa, 0xe5, 0x75, 0xbc,
	0x6e, 0xb3, 0x7f, 0xfb, 0x45, 0x54, 0xfb, 0x37, 0xba, 0x01, 0xd7, 0xcb, 0xf2, 0x9d, 0xa0, 0x36,
	0x3a, 0x2e, 0xa8, 0x0c, 0x12, 0x9e, 0x87, 0x3b, 0x7c, 0x44, 0xb2, 0xd8, 0x41, 0x51, 0x07, 0x9a,
	0x05, 0x4e, 0xc9, 0x40, 0xd2, 0xa7, 0xa4, 0x55, 0xeb, 0x78, 0xdd, 0xa5, 0x7e, 0xfd, 0x45, 0xe4,
	0xc5, 0xcb, 0xda, 0xfa, 0x98, 0x3e, 0x25, 0xc8, 0x07, 0x30, 0x1e, 0x8a, 0x1f, 0x10, 0xd6, 0xaa,
	0x9b, 0x54, 0xc6, 0xc5, 0x00, 0xf7, 0xb4, 0x15, 0xbd, 0x0b, 0x8d, 0x7d, 0x9a, 0x29, 0x22, 0x5a,
	0x97, 0x66, 0xf7, 0xce, 0x84, 0xee, 0x41, 0x53, 0x10, 0x6c, 0x19, 0xb7, 0x96, 0x3a, 0x5e, 0x77,
	0xa5, 0x57, 0x2a, 0x1d, 0x94, 0x94, 0x83, 0x4f, 0xb4, 0x28, 0x3b, 0x58, 0x1e, 0xb8, 0xf4, 0x1a,
	0xa1, 0x8f, 0x68, 0x0b, 0x96, 0x53, 0xc1, 0x27, 0xc5, 0x60, 0xf8, 0xa4, 0xd5, 0x78, 0x39, 0xf0,
	0x65, 0x03, 0xe8, 0x3f, 0xf1, 0x7f, 0xf6, 0x00, 0x55, 0x75, 0x93, 0x05, 0x67, 0x92, 0xa0, 0x6d,
	0x68, 0x98, 0x07, 0x29, 0x5b, 0x5e, 0xa7, 0xde, 0x5d, 0xe9, 0xdd, 0x08, 0xe6, 0x3f, 0xc5, 0xc0,
	0xe0, 0x63, 0x07, 0x42, 0x37, 0x61, 0x95, 0x91, 0xaf, 0xd5, 0xa0, 0xa2, 0x8a, 0x16, 0xae, 0x19,
	0x5f, 0xd1, 0xe6, 0xdd, 0xa9, 0x28, 0xeb, 0x00, 0x8a, 0x2b, 0x9c, 0x59, 0x6d, 0xb5, 0x70, 0x4b,
	0x71, 0xd3, 0x58, 0xb4, 0xae, 0x7e, 0x0a, 0xd7, 0xee, 0x8f, 0x49, 0x72, 0x60, 0x82, 0x3f, 0x56,
	0x5a, 0x6e, 0x85, 0xd5, 0x64, 0xda, 0xde, 0x87, 0x70, 0x89, 0xe1, 0x9c, 0xb8, 0xe6, 0xde, 0x35,
	0xcd, 0xbd, 0x03, 0xb7, 0xe7, 0x37, 0xd7, 0x04, 0x8b, 0x84, 0xa2, 0xfb, 0x38, 0x51, 0xb1, 0x09,
	0xe0, 0xff, 0x58, 0x83, 0xf5, 0x73, 0x32, 0x39, 0x41, 0x6e, 0xc2, 0x2a, 0x95, 0x03, 0x37, 0xa4,
	0xfa, 0x7e, 0x64, 0xb2, 0x2e, 0xc7, 0x57, 0xa8, 0x9c, 0x81, 0x46, 0x08, 0xc3, 0x55, 0x7b, 0xed,
	0x7c, 0xb1, 0x4b, 0x64, 0xf8, 0xaf, 0xf4, 0xee, 0xbc, 0x94, 0x8e, 0xd3, 0xea, 0xde, 0xb2, 0xb1,
	0x8e, 0x19, 0x4d, 0x0a, 0x33, 0x63, 0x27, 0x53, 0xd4, 0x5f, 0x2d, 0x85, 0x89, 0x75, 0xcc, 0xe8,
	0x7f, 0x09, 0x6b, 0x86, 0x8f, 0xed, 0xea, 0x45, 0xab, 0x7d, 0x04, 0xa8, 0x1a, 0xdd, 0x29, 0x7c,
	0xae, 0x72, 0xde, 0x45, 0x29, 0xe7, 0xff, 0xe2, 0x55, 0x33, 0xef, 0x10, 0x85, 0x47, 0x58, 0x61,
	0x74, 0x0b, 0xde, 0x2c, 0x04, 0x4f, 0x05, 0x91, 0x72, 0x50, 0x10, 0x91, 0x94, 0xfb, 0xa2, 0x16,
	0xaf, 0x96, 0xf6, 0x5d, 0x6b, 0x46, 0x1f, 0x01, 0x48, 0x85, 0x85, 0x1a, 0xe8, 0xfd, 0xe3, 0x7a,
	0x7a, 0x7a, 0xd8, 0xf6, 0xca, 0xe5, 0x14, 0x37, 0x8d, 0xb7, 0x3e, 0xa3, 0x0f, 0x61, 0x99, 0xb0,
	0x91, 0x05, 0xd6, 0x17, 0x02, 0x2f, 0x13, 0x36, 0xd2, 0xa7, 0xde, 0x5f, 0x4b, 0xf0, 0x86, 0x7d,
	0x60, 0xf6, 0xd3, 0x80, 0x7e, 0xf3, 0x00, 0x66, 0x13, 0x8b, 0x36, 0x17, 0xe9, 0x72, 0x6a, 0x2b,
	0xb6, 0x7b, 0xff, 0x07, 0x62, 0xbb, 0xe3, 0x47, 0xcf, 0x23, 0xb7, 0x0f, 0x7f, 0xf8, 0xe3, 0xef,
	0x9f, 0x6a, 0x3d, 0xf4, 0xc1, 0x74, 0xe5, 0x7f, 0x63, 0xed, 0xdb, 0xa6, 0x6d, 0x7b, 0x58, 0xa4,
	0x44, 0xc9, 0x70, 0x23, 0xcc, 0xf5, 0x12, 0x95, 0xe1, 0xc6, 0xb7, 0xa1, 0x5b, 0x0a, 0xff, 0x78,
	0x70, 0xf5, 0xcc, 0x21, 0x43, 0xf7, 0x16, 0x15, 0x34, 0x6f, 0x0b, 0xb4, 0xb7, 0x5f, 0x11, 0xed,
	0x98, 0x7d, 0xfe, 0x3c, 0x32, 0xcf, 0xd2, 0xf0, 0x7a, 0x80, 0xfa, 0x33, 0x5e, 0xda, 0x7a, 0x1e,
	0x2b, 0x47, 0x2a, 0xdc, 0x08, 0xcb, 0x77, 0xaa, 0xa9, 0x6e, 0x25, 0x3a, 0x15, 0xfa, 0xd3, 0x03,
	0x98, 0xbd, 0xb3, 0xc5, 0x2d, 0x3a, 0x35, 0x6b, 0xed, 0xf5, 0x12, 0x52, 0xf9, 0x6e, 0x06, 0x9f,
	0x95, 0xdf, 0x4d, 0xff, 0xbb, 0x67, 0x51, 0xf7, 0xcc, 0x21, 0x3a, 0xe3, 0x79, 0x57, 0xe9, 0x3d,
	0xf4, 0x5f, 0x8f, 0x9e, 0x19, 0xaa, 0x2d, 0x6f, 0xa3, 0xfd, 0xe8, 0x59, 0xb4, 0x3e, 0x77, 0xf0,
	0x7f, 0x8f, 0x6e, 0x8d, 0x95, 0x2a, 0xe4, 0x56, 0x18, 0x1e, 0x1d, 0x1d, 0x9d, 0xdc, 0x0a, 0x78,
	0xa2, 0xc6, 0xee, 0xcf, 0x01, 0x17, 0xb4, 0xff, 0xbd, 0x07, 0x7e, 0xc2, 0xf3, 0x05, 0x32, 0xf5,
	0xd7, 0xaa, 0x73, 0xb0, 0xab, 0x67, 0xe6, 0x53, 0x6f, 0xd7, 0xfb, 0xe2, 0x81, 0x83, 0xa5, 0x3c,
	0xc3, 0x2c, 0x0d, 0xb8, 0x48, 0xc3, 0x94, 0x30, 0x33, 0x53, 0xe1, 0x2c, 0xef, 0x79, 0x7f, 0x2c,
	0x1f, 0xdb, 0xe3, 0xb0, 0x61, 0x00, 0x77, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xf5, 0xdf, 0x53,
	0x8c, 0xa8, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BuildServiceClient is the client API for BuildService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BuildServiceClient interface {
	// Lists all builds for the given build target and model in descending order
	// for the milestones and build versions.
	ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error)
	// Checks the stage status for a given build artifact in a partner Google
	// Cloud Storage bucket.
	CheckBuildStageStatus(ctx context.Context, in *CheckBuildStageStatusRequest, opts ...grpc.CallOption) (*CheckBuildStageStatusResponse, error)
	// Stages a given build artifact from a internal Google Cloud Storage bucket
	// to a partner Google Cloud Storage bucket. If any of objects has already
	// been copied, it will overwrite the previous objects. Operation <response:
	// [StageBuildResponse][google.chromeos.moblab.v1beta1.StageBuildResponse],
	//            metadata: [StageBuildMetadata][google.chromeos.moblab.v1beta1.StageBuildMetadata]>
	StageBuild(ctx context.Context, in *StageBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type buildServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBuildServiceClient(cc grpc.ClientConnInterface) BuildServiceClient {
	return &buildServiceClient{cc}
}

func (c *buildServiceClient) ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error) {
	out := new(ListBuildsResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/ListBuilds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildServiceClient) CheckBuildStageStatus(ctx context.Context, in *CheckBuildStageStatusRequest, opts ...grpc.CallOption) (*CheckBuildStageStatusResponse, error) {
	out := new(CheckBuildStageStatusResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/CheckBuildStageStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildServiceClient) StageBuild(ctx context.Context, in *StageBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/StageBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BuildServiceServer is the server API for BuildService service.
type BuildServiceServer interface {
	// Lists all builds for the given build target and model in descending order
	// for the milestones and build versions.
	ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error)
	// Checks the stage status for a given build artifact in a partner Google
	// Cloud Storage bucket.
	CheckBuildStageStatus(context.Context, *CheckBuildStageStatusRequest) (*CheckBuildStageStatusResponse, error)
	// Stages a given build artifact from a internal Google Cloud Storage bucket
	// to a partner Google Cloud Storage bucket. If any of objects has already
	// been copied, it will overwrite the previous objects. Operation <response:
	// [StageBuildResponse][google.chromeos.moblab.v1beta1.StageBuildResponse],
	//            metadata: [StageBuildMetadata][google.chromeos.moblab.v1beta1.StageBuildMetadata]>
	StageBuild(context.Context, *StageBuildRequest) (*longrunning.Operation, error)
}

// UnimplementedBuildServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBuildServiceServer struct {
}

func (*UnimplementedBuildServiceServer) ListBuilds(ctx context.Context, req *ListBuildsRequest) (*ListBuildsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuilds not implemented")
}
func (*UnimplementedBuildServiceServer) CheckBuildStageStatus(ctx context.Context, req *CheckBuildStageStatusRequest) (*CheckBuildStageStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckBuildStageStatus not implemented")
}
func (*UnimplementedBuildServiceServer) StageBuild(ctx context.Context, req *StageBuildRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StageBuild not implemented")
}

func RegisterBuildServiceServer(s *grpc.Server, srv BuildServiceServer) {
	s.RegisterService(&_BuildService_serviceDesc, srv)
}

func _BuildService_ListBuilds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).ListBuilds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/ListBuilds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).ListBuilds(ctx, req.(*ListBuildsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BuildService_CheckBuildStageStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckBuildStageStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).CheckBuildStageStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/CheckBuildStageStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).CheckBuildStageStatus(ctx, req.(*CheckBuildStageStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BuildService_StageBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StageBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).StageBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/StageBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).StageBuild(ctx, req.(*StageBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BuildService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.chromeos.moblab.v1beta1.BuildService",
	HandlerType: (*BuildServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListBuilds",
			Handler:    _BuildService_ListBuilds_Handler,
		},
		{
			MethodName: "CheckBuildStageStatus",
			Handler:    _BuildService_CheckBuildStageStatus_Handler,
		},
		{
			MethodName: "StageBuild",
			Handler:    _BuildService_StageBuild_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/chromeos/moblab/v1beta1/build_service.proto",
}
