// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/websecurityscanner/v1/finding_addon.proto

package websecurityscanner

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Types of XSS attack vector.
type Xss_AttackVector int32

const (
	// Unknown attack vector.
	Xss_ATTACK_VECTOR_UNSPECIFIED Xss_AttackVector = 0
	// The attack comes from fuzzing the browser's localStorage.
	Xss_LOCAL_STORAGE Xss_AttackVector = 1
	// The attack comes from fuzzing the browser's sessionStorage.
	Xss_SESSION_STORAGE Xss_AttackVector = 2
	// The attack comes from fuzzing the window's name property.
	Xss_WINDOW_NAME Xss_AttackVector = 3
	// The attack comes from fuzzing the referrer property.
	Xss_REFERRER Xss_AttackVector = 4
	// The attack comes from fuzzing an input element.
	Xss_FORM_INPUT Xss_AttackVector = 5
	// The attack comes from fuzzing the browser's cookies.
	Xss_COOKIE Xss_AttackVector = 6
	// The attack comes from hijacking the post messaging mechanism.
	Xss_POST_MESSAGE Xss_AttackVector = 7
	// The attack comes from fuzzing parameters in the url.
	Xss_GET_PARAMETERS Xss_AttackVector = 8
	// The attack comes from fuzzing the fragment in the url.
	Xss_URL_FRAGMENT Xss_AttackVector = 9
	// The attack comes from fuzzing the HTML comments.
	Xss_HTML_COMMENT Xss_AttackVector = 10
	// The attack comes from fuzzing the POST parameters.
	Xss_POST_PARAMETERS Xss_AttackVector = 11
	// The attack comes from fuzzing the protocol.
	Xss_PROTOCOL Xss_AttackVector = 12
	// The attack comes from the server side and is stored.
	Xss_STORED_XSS Xss_AttackVector = 13
	// The attack is a Same-Origin Method Execution attack via a GET parameter.
	Xss_SAME_ORIGIN Xss_AttackVector = 14
	// The attack payload is received from a third-party host via a URL that is
	// user-controllable
	Xss_USER_CONTROLLABLE_URL Xss_AttackVector = 15
)

var Xss_AttackVector_name = map[int32]string{
	0:  "ATTACK_VECTOR_UNSPECIFIED",
	1:  "LOCAL_STORAGE",
	2:  "SESSION_STORAGE",
	3:  "WINDOW_NAME",
	4:  "REFERRER",
	5:  "FORM_INPUT",
	6:  "COOKIE",
	7:  "POST_MESSAGE",
	8:  "GET_PARAMETERS",
	9:  "URL_FRAGMENT",
	10: "HTML_COMMENT",
	11: "POST_PARAMETERS",
	12: "PROTOCOL",
	13: "STORED_XSS",
	14: "SAME_ORIGIN",
	15: "USER_CONTROLLABLE_URL",
}

var Xss_AttackVector_value = map[string]int32{
	"ATTACK_VECTOR_UNSPECIFIED": 0,
	"LOCAL_STORAGE":             1,
	"SESSION_STORAGE":           2,
	"WINDOW_NAME":               3,
	"REFERRER":                  4,
	"FORM_INPUT":                5,
	"COOKIE":                    6,
	"POST_MESSAGE":              7,
	"GET_PARAMETERS":            8,
	"URL_FRAGMENT":              9,
	"HTML_COMMENT":              10,
	"POST_PARAMETERS":           11,
	"PROTOCOL":                  12,
	"STORED_XSS":                13,
	"SAME_ORIGIN":               14,
	"USER_CONTROLLABLE_URL":     15,
}

func (x Xss_AttackVector) String() string {
	return proto.EnumName(Xss_AttackVector_name, int32(x))
}

func (Xss_AttackVector) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0ef715fa8ce0714a, []int{5, 0}
}

// ! Information about a vulnerability with an HTML.
type Form struct {
	// ! The URI where to send the form when it's submitted.
	ActionUri string `protobuf:"bytes,1,opt,name=action_uri,json=actionUri,proto3" json:"action_uri,omitempty"`
	// ! The names of form fields related to the vulnerability.
	Fields               []string `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Form) Reset()         { *m = Form{} }
func (m *Form) String() string { return proto.CompactTextString(m) }
func (*Form) ProtoMessage()    {}
func (*Form) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ef715fa8ce0714a, []int{0}
}

func (m *Form) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Form.Unmarshal(m, b)
}
func (m *Form) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Form.Marshal(b, m, deterministic)
}
func (m *Form) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Form.Merge(m, src)
}
func (m *Form) XXX_Size() int {
	return xxx_messageInfo_Form.Size(m)
}
func (m *Form) XXX_DiscardUnknown() {
	xxx_messageInfo_Form.DiscardUnknown(m)
}

var xxx_messageInfo_Form proto.InternalMessageInfo

func (m *Form) GetActionUri() string {
	if m != nil {
		return m.ActionUri
	}
	return ""
}

func (m *Form) GetFields() []string {
	if m != nil {
		return m.Fields
	}
	return nil
}

// Information reported for an outdated library.
type OutdatedLibrary struct {
	// The name of the outdated library.
	LibraryName string `protobuf:"bytes,1,opt,name=library_name,json=libraryName,proto3" json:"library_name,omitempty"`
	// The version number.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// URLs to learn more information about the vulnerabilities in the library.
	LearnMoreUrls        []string `protobuf:"bytes,3,rep,name=learn_more_urls,json=learnMoreUrls,proto3" json:"learn_more_urls,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutdatedLibrary) Reset()         { *m = OutdatedLibrary{} }
func (m *OutdatedLibrary) String() string { return proto.CompactTextString(m) }
func (*OutdatedLibrary) ProtoMessage()    {}
func (*OutdatedLibrary) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ef715fa8ce0714a, []int{1}
}

func (m *OutdatedLibrary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutdatedLibrary.Unmarshal(m, b)
}
func (m *OutdatedLibrary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutdatedLibrary.Marshal(b, m, deterministic)
}
func (m *OutdatedLibrary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutdatedLibrary.Merge(m, src)
}
func (m *OutdatedLibrary) XXX_Size() int {
	return xxx_messageInfo_OutdatedLibrary.Size(m)
}
func (m *OutdatedLibrary) XXX_DiscardUnknown() {
	xxx_messageInfo_OutdatedLibrary.DiscardUnknown(m)
}

var xxx_messageInfo_OutdatedLibrary proto.InternalMessageInfo

func (m *OutdatedLibrary) GetLibraryName() string {
	if m != nil {
		return m.LibraryName
	}
	return ""
}

func (m *OutdatedLibrary) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *OutdatedLibrary) GetLearnMoreUrls() []string {
	if m != nil {
		return m.LearnMoreUrls
	}
	return nil
}

// Information regarding any resource causing the vulnerability such
// as JavaScript sources, image, audio files, etc.
type ViolatingResource struct {
	// The MIME type of this resource.
	ContentType string `protobuf:"bytes,1,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// URL of this violating resource.
	ResourceUrl          string   `protobuf:"bytes,2,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ViolatingResource) Reset()         { *m = ViolatingResource{} }
func (m *ViolatingResource) String() string { return proto.CompactTextString(m) }
func (*ViolatingResource) ProtoMessage()    {}
func (*ViolatingResource) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ef715fa8ce0714a, []int{2}
}

func (m *ViolatingResource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ViolatingResource.Unmarshal(m, b)
}
func (m *ViolatingResource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ViolatingResource.Marshal(b, m, deterministic)
}
func (m *ViolatingResource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ViolatingResource.Merge(m, src)
}
func (m *ViolatingResource) XXX_Size() int {
	return xxx_messageInfo_ViolatingResource.Size(m)
}
func (m *ViolatingResource) XXX_DiscardUnknown() {
	xxx_messageInfo_ViolatingResource.DiscardUnknown(m)
}

var xxx_messageInfo_ViolatingResource proto.InternalMessageInfo

func (m *ViolatingResource) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *ViolatingResource) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

// Information about vulnerable request parameters.
type VulnerableParameters struct {
	// The vulnerable parameter names.
	ParameterNames       []string `protobuf:"bytes,1,rep,name=parameter_names,json=parameterNames,proto3" json:"parameter_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerableParameters) Reset()         { *m = VulnerableParameters{} }
func (m *VulnerableParameters) String() string { return proto.CompactTextString(m) }
func (*VulnerableParameters) ProtoMessage()    {}
func (*VulnerableParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ef715fa8ce0714a, []int{3}
}

func (m *VulnerableParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerableParameters.Unmarshal(m, b)
}
func (m *VulnerableParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerableParameters.Marshal(b, m, deterministic)
}
func (m *VulnerableParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerableParameters.Merge(m, src)
}
func (m *VulnerableParameters) XXX_Size() int {
	return xxx_messageInfo_VulnerableParameters.Size(m)
}
func (m *VulnerableParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerableParameters.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerableParameters proto.InternalMessageInfo

func (m *VulnerableParameters) GetParameterNames() []string {
	if m != nil {
		return m.ParameterNames
	}
	return nil
}

// Information about vulnerable or missing HTTP Headers.
type VulnerableHeaders struct {
	// List of vulnerable headers.
	Headers []*VulnerableHeaders_Header `protobuf:"bytes,1,rep,name=headers,proto3" json:"headers,omitempty"`
	// List of missing headers.
	MissingHeaders       []*VulnerableHeaders_Header `protobuf:"bytes,2,rep,name=missing_headers,json=missingHeaders,proto3" json:"missing_headers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *VulnerableHeaders) Reset()         { *m = VulnerableHeaders{} }
func (m *VulnerableHeaders) String() string { return proto.CompactTextString(m) }
func (*VulnerableHeaders) ProtoMessage()    {}
func (*VulnerableHeaders) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ef715fa8ce0714a, []int{4}
}

func (m *VulnerableHeaders) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerableHeaders.Unmarshal(m, b)
}
func (m *VulnerableHeaders) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerableHeaders.Marshal(b, m, deterministic)
}
func (m *VulnerableHeaders) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerableHeaders.Merge(m, src)
}
func (m *VulnerableHeaders) XXX_Size() int {
	return xxx_messageInfo_VulnerableHeaders.Size(m)
}
func (m *VulnerableHeaders) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerableHeaders.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerableHeaders proto.InternalMessageInfo

func (m *VulnerableHeaders) GetHeaders() []*VulnerableHeaders_Header {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *VulnerableHeaders) GetMissingHeaders() []*VulnerableHeaders_Header {
	if m != nil {
		return m.MissingHeaders
	}
	return nil
}

// Describes a HTTP Header.
type VulnerableHeaders_Header struct {
	// Header name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Header value.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VulnerableHeaders_Header) Reset()         { *m = VulnerableHeaders_Header{} }
func (m *VulnerableHeaders_Header) String() string { return proto.CompactTextString(m) }
func (*VulnerableHeaders_Header) ProtoMessage()    {}
func (*VulnerableHeaders_Header) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ef715fa8ce0714a, []int{4, 0}
}

func (m *VulnerableHeaders_Header) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerableHeaders_Header.Unmarshal(m, b)
}
func (m *VulnerableHeaders_Header) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerableHeaders_Header.Marshal(b, m, deterministic)
}
func (m *VulnerableHeaders_Header) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerableHeaders_Header.Merge(m, src)
}
func (m *VulnerableHeaders_Header) XXX_Size() int {
	return xxx_messageInfo_VulnerableHeaders_Header.Size(m)
}
func (m *VulnerableHeaders_Header) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerableHeaders_Header.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerableHeaders_Header proto.InternalMessageInfo

func (m *VulnerableHeaders_Header) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VulnerableHeaders_Header) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Information reported for an XSS.
type Xss struct {
	// Stack traces leading to the point where the XSS occurred.
	StackTraces []string `protobuf:"bytes,1,rep,name=stack_traces,json=stackTraces,proto3" json:"stack_traces,omitempty"`
	// An error message generated by a javascript breakage.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// The attack vector of the payload triggering this XSS.
	AttackVector Xss_AttackVector `protobuf:"varint,3,opt,name=attack_vector,json=attackVector,proto3,enum=google.cloud.websecurityscanner.v1.Xss_AttackVector" json:"attack_vector,omitempty"`
	// The reproduction url for the seeding POST request of a Stored XSS.
	StoredXssSeedingUrl  string   `protobuf:"bytes,4,opt,name=stored_xss_seeding_url,json=storedXssSeedingUrl,proto3" json:"stored_xss_seeding_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Xss) Reset()         { *m = Xss{} }
func (m *Xss) String() string { return proto.CompactTextString(m) }
func (*Xss) ProtoMessage()    {}
func (*Xss) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ef715fa8ce0714a, []int{5}
}

func (m *Xss) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Xss.Unmarshal(m, b)
}
func (m *Xss) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Xss.Marshal(b, m, deterministic)
}
func (m *Xss) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Xss.Merge(m, src)
}
func (m *Xss) XXX_Size() int {
	return xxx_messageInfo_Xss.Size(m)
}
func (m *Xss) XXX_DiscardUnknown() {
	xxx_messageInfo_Xss.DiscardUnknown(m)
}

var xxx_messageInfo_Xss proto.InternalMessageInfo

func (m *Xss) GetStackTraces() []string {
	if m != nil {
		return m.StackTraces
	}
	return nil
}

func (m *Xss) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

func (m *Xss) GetAttackVector() Xss_AttackVector {
	if m != nil {
		return m.AttackVector
	}
	return Xss_ATTACK_VECTOR_UNSPECIFIED
}

func (m *Xss) GetStoredXssSeedingUrl() string {
	if m != nil {
		return m.StoredXssSeedingUrl
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.websecurityscanner.v1.Xss_AttackVector", Xss_AttackVector_name, Xss_AttackVector_value)
	proto.RegisterType((*Form)(nil), "google.cloud.websecurityscanner.v1.Form")
	proto.RegisterType((*OutdatedLibrary)(nil), "google.cloud.websecurityscanner.v1.OutdatedLibrary")
	proto.RegisterType((*ViolatingResource)(nil), "google.cloud.websecurityscanner.v1.ViolatingResource")
	proto.RegisterType((*VulnerableParameters)(nil), "google.cloud.websecurityscanner.v1.VulnerableParameters")
	proto.RegisterType((*VulnerableHeaders)(nil), "google.cloud.websecurityscanner.v1.VulnerableHeaders")
	proto.RegisterType((*VulnerableHeaders_Header)(nil), "google.cloud.websecurityscanner.v1.VulnerableHeaders.Header")
	proto.RegisterType((*Xss)(nil), "google.cloud.websecurityscanner.v1.Xss")
}

func init() {
	proto.RegisterFile("google/cloud/websecurityscanner/v1/finding_addon.proto", fileDescriptor_0ef715fa8ce0714a)
}

var fileDescriptor_0ef715fa8ce0714a = []byte{
	// 783 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x94, 0xdd, 0x6e, 0xdb, 0x36,
	0x14, 0xc7, 0xe7, 0x8f, 0x3a, 0xcd, 0xf1, 0x97, 0xc2, 0x76, 0x85, 0x3b, 0xa0, 0x40, 0xe6, 0x01,
	0x5d, 0xae, 0x6c, 0x34, 0x1d, 0x76, 0xb3, 0x0d, 0x83, 0xe2, 0xd0, 0xa9, 0x51, 0x49, 0x34, 0x28,
	0xd9, 0x4d, 0x77, 0x43, 0x30, 0x12, 0xab, 0x09, 0x93, 0x45, 0x83, 0x94, 0xbd, 0xe5, 0x05, 0xf6,
	0x02, 0xbb, 0xda, 0xa3, 0xec, 0xed, 0x06, 0x52, 0x72, 0x16, 0x20, 0xc0, 0x96, 0x8b, 0x5d, 0x99,
	0xe7, 0x47, 0xfe, 0xff, 0xe7, 0x90, 0x47, 0x3e, 0xf0, 0x6d, 0x2a, 0x65, 0x9a, 0x8b, 0x69, 0x9c,
	0xcb, 0x5d, 0x32, 0xfd, 0x55, 0xdc, 0x68, 0x11, 0xef, 0x54, 0x56, 0xde, 0xea, 0x98, 0x17, 0x85,
	0x50, 0xd3, 0xfd, 0x9b, 0xe9, 0xa7, 0xac, 0x48, 0xb2, 0x22, 0x65, 0x3c, 0x49, 0x64, 0x31, 0xd9,
	0x2a, 0x59, 0x4a, 0x34, 0xae, 0x74, 0x13, 0xab, 0x9b, 0x3c, 0xd4, 0x4d, 0xf6, 0x6f, 0xc6, 0x3f,
	0x40, 0x7b, 0x2e, 0xd5, 0x06, 0xbd, 0x02, 0xe0, 0x71, 0x99, 0xc9, 0x82, 0xed, 0x54, 0x36, 0x6a,
	0x9c, 0x36, 0xce, 0x8e, 0xe9, 0x71, 0x45, 0x56, 0x2a, 0x43, 0x2f, 0xa0, 0xf3, 0x29, 0x13, 0x79,
	0xa2, 0x47, 0xcd, 0xd3, 0xd6, 0xd9, 0x31, 0xad, 0xa3, 0xf1, 0x1e, 0x86, 0x64, 0x57, 0x26, 0xbc,
	0x14, 0x89, 0x97, 0xdd, 0x28, 0xae, 0x6e, 0xd1, 0x97, 0xd0, 0xcb, 0xab, 0x25, 0x2b, 0xf8, 0x46,
	0xd4, 0x5e, 0xdd, 0x9a, 0x05, 0x7c, 0x23, 0xd0, 0x08, 0x8e, 0xf6, 0x42, 0xe9, 0x4c, 0x16, 0xa3,
	0xa6, 0xdd, 0x3d, 0x84, 0xe8, 0x35, 0x0c, 0x73, 0xc1, 0x55, 0xc1, 0x36, 0x52, 0x09, 0xb6, 0x53,
	0xb9, 0x1e, 0xb5, 0x6c, 0xc2, 0xbe, 0xc5, 0xbe, 0x54, 0x62, 0xa5, 0x72, 0x3d, 0xfe, 0x08, 0x27,
	0xeb, 0x4c, 0xe6, 0xbc, 0xcc, 0x8a, 0x94, 0x0a, 0x2d, 0x77, 0x2a, 0x16, 0x26, 0x73, 0x2c, 0x8b,
	0x52, 0x14, 0x25, 0x2b, 0x6f, 0xb7, 0x77, 0x99, 0x6b, 0x16, 0xdd, 0x6e, 0xed, 0x11, 0x55, 0x1f,
	0x37, 0xee, 0x75, 0xfa, 0xee, 0x81, 0xad, 0x54, 0x3e, 0xfe, 0x11, 0x9e, 0xaf, 0x77, 0x79, 0x21,
	0x14, 0xbf, 0xc9, 0xc5, 0x92, 0x2b, 0xbe, 0x11, 0xa5, 0x50, 0x1a, 0x7d, 0x0d, 0xc3, 0xed, 0x21,
	0xb2, 0x37, 0xd3, 0xa3, 0x86, 0x2d, 0x6d, 0x70, 0x87, 0xcd, 0xe5, 0xf4, 0xf8, 0xf7, 0x26, 0x9c,
	0xfc, 0xe3, 0xf0, 0x4e, 0xf0, 0xc4, 0xc8, 0xd7, 0x70, 0xf4, 0x73, 0xb5, 0xb4, 0xb2, 0xee, 0xf9,
	0xf7, 0x93, 0xff, 0x6e, 0xcf, 0xe4, 0x81, 0xcf, 0xa4, 0xfa, 0xa5, 0x07, 0x33, 0x24, 0x60, 0xb8,
	0xc9, 0xb4, 0x36, 0xbd, 0x3f, 0xf8, 0x37, 0xff, 0x07, 0xff, 0x41, 0x6d, 0x5a, 0xe3, 0x2f, 0xce,
	0xa1, 0x53, 0x2d, 0x11, 0x82, 0xf6, 0xbd, 0xbe, 0xda, 0x35, 0x7a, 0x0e, 0x4f, 0xf6, 0x3c, 0xdf,
	0x89, 0xfa, 0x3d, 0xab, 0x60, 0xfc, 0x67, 0x1b, 0x5a, 0xd7, 0x5a, 0x9b, 0x47, 0xd7, 0x25, 0x8f,
	0x7f, 0x61, 0xa5, 0xe2, 0xf1, 0xdd, 0xb3, 0x75, 0x2d, 0x8b, 0x2c, 0x42, 0x5f, 0x41, 0x5f, 0x28,
	0x25, 0x15, 0xdb, 0x08, 0xad, 0x79, 0x7a, 0x30, 0xea, 0x59, 0xe8, 0x57, 0x0c, 0x7d, 0x84, 0x3e,
	0x2f, 0xad, 0xd1, 0x5e, 0xc4, 0xa5, 0x54, 0xa3, 0xd6, 0x69, 0xe3, 0x6c, 0x70, 0xfe, 0xcd, 0x63,
	0x2e, 0x7a, 0xad, 0xf5, 0xc4, 0xb5, 0xe2, 0xb5, 0xd5, 0xd2, 0x1e, 0xbf, 0x17, 0xa1, 0xb7, 0xf0,
	0x42, 0x97, 0x52, 0x89, 0x84, 0xfd, 0xa6, 0x35, 0xd3, 0x42, 0xd8, 0x3f, 0x93, 0xf9, 0x42, 0xda,
	0xb6, 0x90, 0x67, 0xd5, 0xee, 0xb5, 0xd6, 0x61, 0xb5, 0x67, 0xbe, 0x94, 0xbf, 0x9a, 0xd0, 0xbb,
	0xef, 0x89, 0x5e, 0xc1, 0x4b, 0x37, 0x8a, 0xdc, 0xd9, 0x7b, 0xb6, 0xc6, 0xb3, 0x88, 0x50, 0xb6,
	0x0a, 0xc2, 0x25, 0x9e, 0x2d, 0xe6, 0x0b, 0x7c, 0xe9, 0x7c, 0x86, 0x4e, 0xa0, 0xef, 0x91, 0x99,
	0xeb, 0xb1, 0x30, 0x22, 0xd4, 0xbd, 0xc2, 0x4e, 0x03, 0x3d, 0x83, 0x61, 0x88, 0xc3, 0x70, 0x41,
	0x82, 0x3b, 0xd8, 0x44, 0x43, 0xe8, 0x7e, 0x58, 0x04, 0x97, 0xe4, 0x03, 0x0b, 0x5c, 0x1f, 0x3b,
	0x2d, 0xd4, 0x83, 0xa7, 0x14, 0xcf, 0x31, 0xa5, 0x98, 0x3a, 0x6d, 0x34, 0x00, 0x98, 0x13, 0xea,
	0xb3, 0x45, 0xb0, 0x5c, 0x45, 0xce, 0x13, 0x04, 0xd0, 0x99, 0x11, 0xf2, 0x7e, 0x81, 0x9d, 0x0e,
	0x72, 0xa0, 0xb7, 0x24, 0x61, 0xc4, 0x7c, 0x1c, 0x86, 0xc6, 0xec, 0x08, 0x21, 0x18, 0x5c, 0xe1,
	0x88, 0x2d, 0x5d, 0xea, 0xfa, 0x38, 0xc2, 0x34, 0x74, 0x9e, 0x9a, 0x53, 0x2b, 0xea, 0xb1, 0x39,
	0x75, 0xaf, 0x7c, 0x1c, 0x44, 0xce, 0xb1, 0x21, 0xef, 0x22, 0xdf, 0x63, 0x33, 0xe2, 0x5b, 0x02,
	0xa6, 0x32, 0xeb, 0x74, 0x4f, 0xd8, 0x35, 0x85, 0x2c, 0x29, 0x89, 0xc8, 0x8c, 0x78, 0x4e, 0xcf,
	0x14, 0x62, 0x8a, 0xc6, 0x97, 0xec, 0x3a, 0x0c, 0x9d, 0xbe, 0xa9, 0x3b, 0x74, 0x7d, 0xcc, 0x08,
	0x5d, 0x5c, 0x2d, 0x02, 0x67, 0x80, 0x5e, 0xc2, 0xe7, 0xab, 0x10, 0x53, 0x36, 0x23, 0x41, 0x44,
	0x89, 0xe7, 0xb9, 0x17, 0x1e, 0x66, 0x2b, 0xea, 0x39, 0xc3, 0x8b, 0x3f, 0x1a, 0xf0, 0x3a, 0x96,
	0x9b, 0x47, 0xb4, 0xee, 0xe2, 0x64, 0x5e, 0xcd, 0x36, 0xd7, 0x8c, 0xb6, 0xa5, 0x99, 0x6c, 0xcb,
	0xc6, 0x4f, 0x51, 0x2d, 0x4c, 0x65, 0xce, 0x8b, 0x74, 0x22, 0x55, 0x3a, 0x4d, 0x45, 0x61, 0xe7,
	0xde, 0xb4, 0xda, 0xe2, 0xdb, 0x4c, 0xff, 0xdb, 0xc8, 0xfc, 0xee, 0x21, 0xbd, 0xe9, 0x58, 0x83,
	0xb7, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0x1d, 0xda, 0x17, 0x1e, 0x72, 0x05, 0x00, 0x00,
}
