import { QueryConfig, QueryResult, ResolvedQueryConfig } from './types';
import { Query, Action, FetchMoreOptions, RefetchOptions } from './query';
export declare type UpdateListener<TResult, TError> = (result: QueryResult<TResult, TError>) => void;
export declare class QueryObserver<TResult, TError> {
    config: ResolvedQueryConfig<TResult, TError>;
    private currentQuery;
    private currentResult;
    private previousQueryResult?;
    private listener?;
    private isStale;
    private initialUpdateCount;
    private staleTimeoutId?;
    private refetchIntervalId?;
    constructor(config: ResolvedQueryConfig<TResult, TError>);
    subscribe(listener?: UpdateListener<TResult, TError>): () => void;
    unsubscribe(): void;
    updateConfig(config: QueryConfig<TResult, TError> | ResolvedQueryConfig<TResult, TError>): void;
    getCurrentQuery(): Query<TResult, TError>;
    getCurrentResult(): QueryResult<TResult, TError>;
    /**
     * @deprecated
     */
    clear(): void;
    remove(): void;
    refetch(options?: RefetchOptions): Promise<TResult | undefined>;
    fetchMore(fetchMoreVariable?: unknown, options?: FetchMoreOptions): Promise<TResult | undefined>;
    fetch(): Promise<TResult | undefined>;
    private optionalFetch;
    private updateStaleTimeout;
    private updateRefetchInterval;
    updateTimers(): void;
    clearTimers(): void;
    private clearStaleTimeout;
    private clearRefetchInterval;
    private updateResult;
    private updateQuery;
    onQueryUpdate(action: Action<TResult, TError>): void;
    private notify;
}
