import { PaginatedQueryConfig, PaginatedQueryResult, QueryFunction, QueryKey, TypedQueryFunction, TypedQueryFunctionArgs } from '../core/types';
export interface UsePaginatedQueryObjectConfig<TResult, TError> {
    queryKey: QueryKey;
    queryFn?: QueryFunction<TResult>;
    config?: PaginatedQueryConfig<TResult, TError>;
}
export declare function usePaginatedQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryConfig?: PaginatedQueryConfig<TResult, TError>): PaginatedQueryResult<TResult, TError>;
export declare function usePaginatedQuery<TResult, TError, TArgs extends TypedQueryFunctionArgs>(queryKey: QueryKey, queryFn: TypedQueryFunction<TResult, TArgs>, queryConfig?: PaginatedQueryConfig<TResult, TError>): PaginatedQueryResult<TResult, TError>;
export declare function usePaginatedQuery<TResult = unknown, TError = unknown>(queryKey: QueryKey, queryFn: QueryFunction<TResult>, queryConfig?: PaginatedQueryConfig<TResult, TError>): PaginatedQueryResult<TResult, TError>;
export declare function usePaginatedQuery<TResult = unknown, TError = unknown>(config: UsePaginatedQueryObjectConfig<TResult, TError>): PaginatedQueryResult<TResult, TError>;
