---
id: Gallery
section: layouts
cssPrefix: pf-l-gallery
---import './Gallery.css'

## Examples

### Basic

```html
<div class="pf-l-gallery">
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
</div>
```

### With gutter

```html
<div class="pf-l-gallery pf-m-gutter">
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
</div>
```

### Grid template minmax() min width customization

Grid template columms min value can be applied to <code>.pf-l-gallery</code>.  Min-width is set inline as `--pf-l-gallery--GridTemplateColumns--min{-on-[breakpoint]}: {width}`.

### Min width modified gallery

```html
<div class="pf-l-gallery pf-m-gutter" style="--pf-l-gallery--GridTemplateColumns--min: 150px;">
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
</div>
```

### Min width modified gallery, responsive updates

```html
<div class="pf-l-gallery pf-m-gutter" style="--pf-l-gallery--GridTemplateColumns--min-on-md: 100px; --pf-l-gallery--GridTemplateColumns--min-on-lg: 150px; --pf-l-gallery--GridTemplateColumns--min-on-xl: 200px; --pf-l-gallery--GridTemplateColumns--min-on-2xl: 300px;">
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
  <div class="pf-l-gallery__item">content</div>
</div>
```

## Documentation

### Overview

The gallery layout is designed so that all of its children are of uniform size, display horizontally, and wrap responsively.

### Usage

| Class                                                                          | Applied to      | Outcome                                                                                                                                                                                                |
| ------------------------------------------------------------------------------ | --------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| `.pf-l-gallery`                                                                | `<div>`         | Initializes a Gallery layout                                                                                                                                                                           |
| `.pf-l-gallery__item`                                                          | `<div>`         | Explicitly sets the child for the gallery. This class isn't necessary, but it is included to keep inline with BEM convention, and to provide an entity that will later be used for applying modifiers. |
| `.pf-m-gutter`                                                                 | `.pf-l-gallery` | Adds space between children by using the globally defined gutter value.                                                                                                                                |
| `--pf-l-gallery--GridTemplateColumns--min{-on-[breakpoint]}: {width}px,rem,em` | `.pf-l-gallery` | Modifies the min value of `grid-template-columns` declaration.                                                                                                                                         |
