[//]: # ( )
[//]: # (This file is automatically generated by a `metapak`)
[//]: # (module. Do not change it  except between the)
[//]: # (`content:start/end` flags, your changes would)
[//]: # (be overridden.)
[//]: # ( )
# streamfilter
> Filtering streams.

[![Build status](https://secure.travis-ci.org/nfroidure/streamfilter.svg)](https://travis-ci.org/nfroidure/streamfilter)
[![Coverage Status](https://coveralls.io/repos/nfroidure/streamfilter/badge.svg?branch=master)](https://coveralls.io/r/nfroidure/streamfilter?branch=master)
[![NPM version](https://badge.fury.io/js/streamfilter.svg)](https://npmjs.org/package/streamfilter)
[![Dependency Status](https://david-dm.org/nfroidure/streamfilter.svg)](https://david-dm.org/nfroidure/streamfilter)
[![devDependency Status](https://david-dm.org/nfroidure/streamfilter/dev-status.svg)](https://david-dm.org/nfroidure/streamfilter#info=devDependencies)
[![Dependency Status](https://dependencyci.com/github/nfroidure/streamfilter/badge)](https://dependencyci.com/github/nfroidure/streamfilter)
[![Package Quality](http://npm.packagequality.com/shield/streamfilter.svg)](http://packagequality.com/#?package=streamfilter)
[![Code Climate](https://codeclimate.com/github/nfroidure/streamfilter.svg)](https://codeclimate.com/github/nfroidure/streamfilter)


[//]: # (::contents:start)

`streamfilter` is a function based filter for streams inspired per gulp-filter
 but no limited to Gulp nor to objectMode streams.

## Installation

First, install `streamfilter` in your project:
```sh
npm install --save streamfilter
```

## Getting started

There are 3 common usages:

### Simple filter

```js
import FilterStream from 'streamfilter';

const filter = new FilterStream((chunk, encoding, cb) => {
  const mustBeFiltered = chunk.length() > 128;
  if(mustBeFiltered) {
    cb(true);
    return;
  }
  cb(false);
});

// Print to stdout a filtered stdin
process.stdin
  .pipe(filter)
  .pipe(process.stdout);
```

### Filter and restore

```js
import FilterStream from 'streamfilter';

const filter = new FilterStream((chunk, encoding, cb) => {
  const mustBeFiltered = chunk.length() > 128;
  if(mustBeFiltered) {
    cb(true);
    return;
  }
  cb(false);
}, {
  restore: true
});

// Print accepted chunks in stdout
filter.pipe(process.stdout);

// Print filtered one to stderr
filter.restore.pipe(process.stderr);
```

### Filter and restore as a passthrough stream
Let's reach total hype!

```js
import FilterStream from 'streamfilter';
import { Transform } from 'stream';

// Filter values
const filter = new FilterStream((chunk, encoding, cb) => {
  const mustBeFiltered = chunk.length() > 128;
  if(mustBeFiltered) {
    cb(true);
    return;
  }
  cb(false);
}, {
  restore: true,
  passthrough: true
});

// Uppercase strings
const mySuperTransformStream = new Transform({
  transform: (chunk, encoding, cb) => cb(
    null,
    Buffer.from(
      chunk.toString(encoding).toUpperCase(),
      encoding,
    ),
  ),
});

// Pipe stdin
process.stdin.pipe(filter)
  // Edit kept chunks
  .pipe(mySuperTransformStream)
  // Restore filtered chunks
  .pipe(filter.restore)
  // and output!
  .pipe(process.stdout)
```

Note that in this case, this is *your* responsibility to end the restore stream
 by piping in another stream or ending him manually.

[//]: # (::contents:end)

# API
<a name="StreamFilter"></a>

## StreamFilter(filterCallback, options) ⇒ <code>Stream</code>
Filter piped in streams according to the given `filterCallback` that takes the
 following arguments: `chunk` the actual chunk, `encoding` the chunk encoding,
 filterResultCallback` the function to call as the result of the filtering
process with `true` in argument to filter her or `false` otherwise.

Options are passed in as is in the various stream instances spawned by this
 module. So, to use the objectMode, simply pass in the `options.objectMode`
 value set to `true`.

**Kind**: global function  
**Returns**: <code>Stream</code> - The filtering stream  

| Param | Type | Description |
| --- | --- | --- |
| filterCallback | <code>function</code> | Callback applying the filters |
| options | <code>Object</code> | Filtering options |
| options.passthrough | <code>boolean</code> | Set to `true`, this option change the restore stream nature from a readable  stream to a passthrough one, allowing you to reuse the filtered chunks in an  existing pipeline. |
| options.restore | <code>boolean</code> | Set to `true`, this option create a readable stream allowing you to use the  filtered chunks elsewhere. The restore stream is exposed in the `FilterStream`  instance as a `restore` named property. |


# Authors
- [Nicolas Froidure](http://insertafter.com/en/index.html)

# License
[MIT](https://github.com/nfroidure/streamfilter/blob/master/LICENSE)
