// Copyright (c) 2016, 2018, 2019, Oracle and/or its affiliates. All rights reserved.
// Code generated. DO NOT EDIT.

package core

import (
	"github.com/oracle/oci-go-sdk/common"
	"net/http"
)

// ListDedicatedVmHostInstancesRequest wrapper for the ListDedicatedVmHostInstances operation
type ListDedicatedVmHostInstancesRequest struct {

	// The OCID (https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm) of the compartment.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The OCID of the dedicated VM host.
	DedicatedVmHostId *string `mandatory:"true" contributesTo:"path" name:"dedicatedVmHostId"`

	// The name of the availability domain.
	// Example: `Uocm:PHX-AD-1`
	AvailabilityDomain *string `mandatory:"false" contributesTo:"query" name:"availabilityDomain"`

	// For list pagination. The maximum number of results per page, or items to return in a paginated
	// "List" call. For important details about how pagination works, see
	// List Pagination (https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	// Example: `50`
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// For list pagination. The value of the `opc-next-page` response header from the previous "List"
	// call. For important details about how pagination works, see
	// List Pagination (https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// Unique identifier for the request.
	// If you need to contact Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// The field to sort by. You can provide one sort order (`sortOrder`). Default order for
	// TIMECREATED is descending. Default order for DISPLAYNAME is ascending. The DISPLAYNAME
	// sort order is case sensitive.
	// **Note:** In general, some "List" operations (for example, `ListInstances`) let you
	// optionally filter by availability domain if the scope of the resource type is within a
	// single availability domain. If you call one of these "List" operations without specifying
	// an availability domain, the resources are grouped by availability domain, then sorted.
	SortBy ListDedicatedVmHostInstancesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The sort order to use, either ascending (`ASC`) or descending (`DESC`). The DISPLAYNAME sort order
	// is case sensitive.
	SortOrder ListDedicatedVmHostInstancesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListDedicatedVmHostInstancesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListDedicatedVmHostInstancesRequest) HTTPRequest(method, path string) (http.Request, error) {
	return common.MakeDefaultHTTPRequestWithTaggedStruct(method, path, request)
}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListDedicatedVmHostInstancesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ListDedicatedVmHostInstancesResponse wrapper for the ListDedicatedVmHostInstances operation
type ListDedicatedVmHostInstancesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of []DedicatedVmHostInstanceSummary instances
	Items []DedicatedVmHostInstanceSummary `presentIn:"body"`

	// For list pagination. When this header appears in the response, additional pages
	// of results remain. For important details about how pagination works, see
	// List Pagination (https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`
}

func (response ListDedicatedVmHostInstancesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListDedicatedVmHostInstancesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListDedicatedVmHostInstancesSortByEnum Enum with underlying type: string
type ListDedicatedVmHostInstancesSortByEnum string

// Set of constants representing the allowable values for ListDedicatedVmHostInstancesSortByEnum
const (
	ListDedicatedVmHostInstancesSortByTimecreated ListDedicatedVmHostInstancesSortByEnum = "TIMECREATED"
	ListDedicatedVmHostInstancesSortByDisplayname ListDedicatedVmHostInstancesSortByEnum = "DISPLAYNAME"
)

var mappingListDedicatedVmHostInstancesSortBy = map[string]ListDedicatedVmHostInstancesSortByEnum{
	"TIMECREATED": ListDedicatedVmHostInstancesSortByTimecreated,
	"DISPLAYNAME": ListDedicatedVmHostInstancesSortByDisplayname,
}

// GetListDedicatedVmHostInstancesSortByEnumValues Enumerates the set of values for ListDedicatedVmHostInstancesSortByEnum
func GetListDedicatedVmHostInstancesSortByEnumValues() []ListDedicatedVmHostInstancesSortByEnum {
	values := make([]ListDedicatedVmHostInstancesSortByEnum, 0)
	for _, v := range mappingListDedicatedVmHostInstancesSortBy {
		values = append(values, v)
	}
	return values
}

// ListDedicatedVmHostInstancesSortOrderEnum Enum with underlying type: string
type ListDedicatedVmHostInstancesSortOrderEnum string

// Set of constants representing the allowable values for ListDedicatedVmHostInstancesSortOrderEnum
const (
	ListDedicatedVmHostInstancesSortOrderAsc  ListDedicatedVmHostInstancesSortOrderEnum = "ASC"
	ListDedicatedVmHostInstancesSortOrderDesc ListDedicatedVmHostInstancesSortOrderEnum = "DESC"
)

var mappingListDedicatedVmHostInstancesSortOrder = map[string]ListDedicatedVmHostInstancesSortOrderEnum{
	"ASC":  ListDedicatedVmHostInstancesSortOrderAsc,
	"DESC": ListDedicatedVmHostInstancesSortOrderDesc,
}

// GetListDedicatedVmHostInstancesSortOrderEnumValues Enumerates the set of values for ListDedicatedVmHostInstancesSortOrderEnum
func GetListDedicatedVmHostInstancesSortOrderEnumValues() []ListDedicatedVmHostInstancesSortOrderEnum {
	values := make([]ListDedicatedVmHostInstancesSortOrderEnum, 0)
	for _, v := range mappingListDedicatedVmHostInstancesSortOrder {
		values = append(values, v)
	}
	return values
}
