package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFlowControl invokes the edas.DeleteFlowControl API synchronously
// api document: https://help.aliyun.com/api/edas/deleteflowcontrol.html
func (client *Client) DeleteFlowControl(request *DeleteFlowControlRequest) (response *DeleteFlowControlResponse, err error) {
	response = CreateDeleteFlowControlResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFlowControlWithChan invokes the edas.DeleteFlowControl API asynchronously
// api document: https://help.aliyun.com/api/edas/deleteflowcontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFlowControlWithChan(request *DeleteFlowControlRequest) (<-chan *DeleteFlowControlResponse, <-chan error) {
	responseChan := make(chan *DeleteFlowControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFlowControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFlowControlWithCallback invokes the edas.DeleteFlowControl API asynchronously
// api document: https://help.aliyun.com/api/edas/deleteflowcontrol.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFlowControlWithCallback(request *DeleteFlowControlRequest, callback func(response *DeleteFlowControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFlowControlResponse
		var err error
		defer close(result)
		response, err = client.DeleteFlowControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFlowControlRequest is the request struct for api DeleteFlowControl
type DeleteFlowControlRequest struct {
	*requests.RoaRequest
	AppId  string `position:"Query" name:"AppId"`
	RuleId string `position:"Query" name:"RuleId"`
}

// DeleteFlowControlResponse is the response struct for api DeleteFlowControl
type DeleteFlowControlResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteFlowControlRequest creates a request to invoke DeleteFlowControl API
func CreateDeleteFlowControlRequest() (request *DeleteFlowControlRequest) {
	request = &DeleteFlowControlRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteFlowControl", "/pop/v5/flowControl", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteFlowControlResponse creates a response to parse from DeleteFlowControl response
func CreateDeleteFlowControlResponse() (response *DeleteFlowControlResponse) {
	response = &DeleteFlowControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
