/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// CephBlockPoolLister helps list CephBlockPools.
// All objects returned here must be treated as read-only.
type CephBlockPoolLister interface {
	// List lists all CephBlockPools in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephBlockPool, err error)
	// CephBlockPools returns an object that can list and get CephBlockPools.
	CephBlockPools(namespace string) CephBlockPoolNamespaceLister
	CephBlockPoolListerExpansion
}

// cephBlockPoolLister implements the CephBlockPoolLister interface.
type cephBlockPoolLister struct {
	indexer cache.Indexer
}

// NewCephBlockPoolLister returns a new CephBlockPoolLister.
func NewCephBlockPoolLister(indexer cache.Indexer) CephBlockPoolLister {
	return &cephBlockPoolLister{indexer: indexer}
}

// List lists all CephBlockPools in the indexer.
func (s *cephBlockPoolLister) List(selector labels.Selector) (ret []*v1.CephBlockPool, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephBlockPool))
	})
	return ret, err
}

// CephBlockPools returns an object that can list and get CephBlockPools.
func (s *cephBlockPoolLister) CephBlockPools(namespace string) CephBlockPoolNamespaceLister {
	return cephBlockPoolNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// CephBlockPoolNamespaceLister helps list and get CephBlockPools.
// All objects returned here must be treated as read-only.
type CephBlockPoolNamespaceLister interface {
	// List lists all CephBlockPools in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephBlockPool, err error)
	// Get retrieves the CephBlockPool from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephBlockPool, error)
	CephBlockPoolNamespaceListerExpansion
}

// cephBlockPoolNamespaceLister implements the CephBlockPoolNamespaceLister
// interface.
type cephBlockPoolNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all CephBlockPools in the indexer for a given namespace.
func (s cephBlockPoolNamespaceLister) List(selector labels.Selector) (ret []*v1.CephBlockPool, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephBlockPool))
	})
	return ret, err
}

// Get retrieves the CephBlockPool from the indexer for a given namespace and name.
func (s cephBlockPoolNamespaceLister) Get(name string) (*v1.CephBlockPool, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("cephblockpool"), name)
	}
	return obj.(*v1.CephBlockPool), nil
}
