// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTargetsForPolicyInput struct {
	_ struct{} `type:"structure"`

	// (Optional) Use this to limit the number of results you want included per
	// page in the response. If you do not include this parameter, it defaults to
	// a value that is specific to the operation. If additional items exist beyond
	// the maximum you specify, the NextToken response element is present and has
	// a value (is not null). Include that value as the NextToken request parameter
	// in the next call to the operation to get the next part of the results. Note
	// that Organizations might return fewer results than the maximum even when
	// there are more results available. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) of the policy whose attachments you want to know.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a policy ID string
	// requires "p-" followed by from 8 to 128 lowercase letters or digits.
	//
	// PolicyId is a required field
	PolicyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTargetsForPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsForPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTargetsForPolicyInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.PolicyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTargetsForPolicyOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`

	// A list of structures, each of which contains details about one of the entities
	// to which the specified policy is attached.
	Targets []PolicyTargetSummary `type:"list"`
}

// String returns the string representation
func (s ListTargetsForPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTargetsForPolicy = "ListTargetsForPolicy"

// ListTargetsForPolicyRequest returns a request value for making API operation for
// AWS Organizations.
//
// Lists all the roots, organizational units (OUs), and accounts that the specified
// policy is attached to.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account.
//
//    // Example sending a request using ListTargetsForPolicyRequest.
//    req := client.ListTargetsForPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListTargetsForPolicy
func (c *Client) ListTargetsForPolicyRequest(input *ListTargetsForPolicyInput) ListTargetsForPolicyRequest {
	op := &aws.Operation{
		Name:       opListTargetsForPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTargetsForPolicyInput{}
	}

	req := c.newRequest(op, input, &ListTargetsForPolicyOutput{})
	return ListTargetsForPolicyRequest{Request: req, Input: input, Copy: c.ListTargetsForPolicyRequest}
}

// ListTargetsForPolicyRequest is the request type for the
// ListTargetsForPolicy API operation.
type ListTargetsForPolicyRequest struct {
	*aws.Request
	Input *ListTargetsForPolicyInput
	Copy  func(*ListTargetsForPolicyInput) ListTargetsForPolicyRequest
}

// Send marshals and sends the ListTargetsForPolicy API request.
func (r ListTargetsForPolicyRequest) Send(ctx context.Context) (*ListTargetsForPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTargetsForPolicyResponse{
		ListTargetsForPolicyOutput: r.Request.Data.(*ListTargetsForPolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTargetsForPolicyRequestPaginator returns a paginator for ListTargetsForPolicy.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTargetsForPolicyRequest(input)
//   p := organizations.NewListTargetsForPolicyRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTargetsForPolicyPaginator(req ListTargetsForPolicyRequest) ListTargetsForPolicyPaginator {
	return ListTargetsForPolicyPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTargetsForPolicyInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTargetsForPolicyPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTargetsForPolicyPaginator struct {
	aws.Pager
}

func (p *ListTargetsForPolicyPaginator) CurrentPage() *ListTargetsForPolicyOutput {
	return p.Pager.CurrentPage().(*ListTargetsForPolicyOutput)
}

// ListTargetsForPolicyResponse is the response type for the
// ListTargetsForPolicy API operation.
type ListTargetsForPolicyResponse struct {
	*ListTargetsForPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTargetsForPolicy request.
func (r *ListTargetsForPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
