package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFaceSearchGroupUsers invokes the imm.ListFaceSearchGroupUsers API synchronously
// api document: https://help.aliyun.com/api/imm/listfacesearchgroupusers.html
func (client *Client) ListFaceSearchGroupUsers(request *ListFaceSearchGroupUsersRequest) (response *ListFaceSearchGroupUsersResponse, err error) {
	response = CreateListFaceSearchGroupUsersResponse()
	err = client.DoAction(request, response)
	return
}

// ListFaceSearchGroupUsersWithChan invokes the imm.ListFaceSearchGroupUsers API asynchronously
// api document: https://help.aliyun.com/api/imm/listfacesearchgroupusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFaceSearchGroupUsersWithChan(request *ListFaceSearchGroupUsersRequest) (<-chan *ListFaceSearchGroupUsersResponse, <-chan error) {
	responseChan := make(chan *ListFaceSearchGroupUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFaceSearchGroupUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFaceSearchGroupUsersWithCallback invokes the imm.ListFaceSearchGroupUsers API asynchronously
// api document: https://help.aliyun.com/api/imm/listfacesearchgroupusers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListFaceSearchGroupUsersWithCallback(request *ListFaceSearchGroupUsersRequest, callback func(response *ListFaceSearchGroupUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFaceSearchGroupUsersResponse
		var err error
		defer close(result)
		response, err = client.ListFaceSearchGroupUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFaceSearchGroupUsersRequest is the request struct for api ListFaceSearchGroupUsers
type ListFaceSearchGroupUsersRequest struct {
	*requests.RpcRequest
	MaxKeys   requests.Integer `position:"Query" name:"MaxKeys"`
	Marker    string           `position:"Query" name:"Marker"`
	Project   string           `position:"Query" name:"Project"`
	GroupName string           `position:"Query" name:"GroupName"`
}

// ListFaceSearchGroupUsersResponse is the response struct for api ListFaceSearchGroupUsers
type ListFaceSearchGroupUsersResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	NextMarker string      `json:"NextMarker" xml:"NextMarker"`
	GroupName  string      `json:"GroupName" xml:"GroupName"`
	GroupId    string      `json:"GroupId" xml:"GroupId"`
	Users      []UsersItem `json:"Users" xml:"Users"`
}

// CreateListFaceSearchGroupUsersRequest creates a request to invoke ListFaceSearchGroupUsers API
func CreateListFaceSearchGroupUsersRequest() (request *ListFaceSearchGroupUsersRequest) {
	request = &ListFaceSearchGroupUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "ListFaceSearchGroupUsers", "imm", "openAPI")
	return
}

// CreateListFaceSearchGroupUsersResponse creates a response to parse from ListFaceSearchGroupUsers response
func CreateListFaceSearchGroupUsersResponse() (response *ListFaceSearchGroupUsersResponse) {
	response = &ListFaceSearchGroupUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
