package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNetworkOptimization invokes the smartag.CreateNetworkOptimization API synchronously
// api document: https://help.aliyun.com/api/smartag/createnetworkoptimization.html
func (client *Client) CreateNetworkOptimization(request *CreateNetworkOptimizationRequest) (response *CreateNetworkOptimizationResponse, err error) {
	response = CreateCreateNetworkOptimizationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNetworkOptimizationWithChan invokes the smartag.CreateNetworkOptimization API asynchronously
// api document: https://help.aliyun.com/api/smartag/createnetworkoptimization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNetworkOptimizationWithChan(request *CreateNetworkOptimizationRequest) (<-chan *CreateNetworkOptimizationResponse, <-chan error) {
	responseChan := make(chan *CreateNetworkOptimizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNetworkOptimization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNetworkOptimizationWithCallback invokes the smartag.CreateNetworkOptimization API asynchronously
// api document: https://help.aliyun.com/api/smartag/createnetworkoptimization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNetworkOptimizationWithCallback(request *CreateNetworkOptimizationRequest, callback func(response *CreateNetworkOptimizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNetworkOptimizationResponse
		var err error
		defer close(result)
		response, err = client.CreateNetworkOptimization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNetworkOptimizationRequest is the request struct for api CreateNetworkOptimization
type CreateNetworkOptimizationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Name                 string           `position:"Query" name:"Name"`
	CcnId                string           `position:"Query" name:"CcnId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateNetworkOptimizationResponse is the response struct for api CreateNetworkOptimization
type CreateNetworkOptimizationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	NetworkOptId string `json:"NetworkOptId" xml:"NetworkOptId"`
	Name         string `json:"Name" xml:"Name"`
	State        string `json:"State" xml:"State"`
}

// CreateCreateNetworkOptimizationRequest creates a request to invoke CreateNetworkOptimization API
func CreateCreateNetworkOptimizationRequest() (request *CreateNetworkOptimizationRequest) {
	request = &CreateNetworkOptimizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "CreateNetworkOptimization", "smartag", "openAPI")
	return
}

// CreateCreateNetworkOptimizationResponse creates a response to parse from CreateNetworkOptimization response
func CreateCreateNetworkOptimizationResponse() (response *CreateNetworkOptimizationResponse) {
	response = &CreateNetworkOptimizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
