package automanage

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/automanage/mgmt/2020-06-30-preview/automanage"

// Account definition of the Automanage account.
type Account struct {
	autorest.Response `json:"-"`
	// Identity - The identity of the Automanage account.
	Identity *AccountIdentity `json:"identity,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; ARM resource id of the Automanage assignment.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Automanage assignment.
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Region where the VM is located.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// AccountIdentity identity for the Automanage account.
type AccountIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of Automanage account identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id associated with the Automanage account.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for the Automanage account. Currently, the only supported type is 'SystemAssigned', which implicitly creates an identity. Possible values include: 'SystemAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountIdentity.
func (ai AccountIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ai.Type != "" {
		objectMap["type"] = ai.Type
	}
	return json.Marshal(objectMap)
}

// AccountList the response of the list Account operation.
type AccountList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list Account operation.
	Value *[]Account `json:"value,omitempty"`
}

// ConfigurationProfileAssignment configuration profile assignment is an association between a VM and
// automanage profile configuration.
type ConfigurationProfileAssignment struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the configuration profile assignment.
	Properties *ConfigurationProfileAssignmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; ARM resource id of the Automanage assignment.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Automanage assignment.
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Region where the VM is located.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfileAssignment.
func (cpa ConfigurationProfileAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpa.Properties != nil {
		objectMap["properties"] = cpa.Properties
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfileAssignmentCompliance the compliance status for the configuration profile assignment.
type ConfigurationProfileAssignmentCompliance struct {
	// UpdateStatus - READ-ONLY; The state of compliance, which only appears in the response. Possible values include: 'UpdateStatusSucceeded', 'UpdateStatusFailed', 'UpdateStatusCreated'
	UpdateStatus UpdateStatus `json:"updateStatus,omitempty"`
}

// ConfigurationProfileAssignmentList the response of the list configuration profile assignment operation.
type ConfigurationProfileAssignmentList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list configuration profile assignment operation.
	Value *[]ConfigurationProfileAssignment `json:"value,omitempty"`
}

// ConfigurationProfileAssignmentProperties automanage configuration profile assignment properties.
type ConfigurationProfileAssignmentProperties struct {
	// ConfigurationProfile - A value indicating configuration profile. Possible values include: 'AzureBestPracticesTestDev', 'AzureBestPracticesProd'
	ConfigurationProfile ConfigurationProfile `json:"configurationProfile,omitempty"`
	// TargetID - The target VM resource URI
	TargetID *string `json:"targetId,omitempty"`
	// AccountID - The Automanage account ARM Resource URI
	AccountID *string `json:"accountId,omitempty"`
	// ConfigurationProfilePreferenceID - The configuration profile custom preferences ARM resource URI
	ConfigurationProfilePreferenceID *string `json:"configurationProfilePreferenceId,omitempty"`
	// ProvisioningStatus - READ-ONLY; The state of onboarding, which only appears in the response. Possible values include: 'Succeeded', 'Failed', 'Created'
	ProvisioningStatus ProvisioningStatus `json:"provisioningStatus,omitempty"`
	// Compliance - The configuration setting for the configuration profile.
	Compliance *ConfigurationProfileAssignmentCompliance `json:"compliance,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfileAssignmentProperties.
func (cpap ConfigurationProfileAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpap.ConfigurationProfile != "" {
		objectMap["configurationProfile"] = cpap.ConfigurationProfile
	}
	if cpap.TargetID != nil {
		objectMap["targetId"] = cpap.TargetID
	}
	if cpap.AccountID != nil {
		objectMap["accountId"] = cpap.AccountID
	}
	if cpap.ConfigurationProfilePreferenceID != nil {
		objectMap["configurationProfilePreferenceId"] = cpap.ConfigurationProfilePreferenceID
	}
	if cpap.Compliance != nil {
		objectMap["compliance"] = cpap.Compliance
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfileAssignmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ConfigurationProfileAssignmentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ConfigurationProfileAssignmentsCreateOrUpdateFuture) Result(client ConfigurationProfileAssignmentsClient) (cpa ConfigurationProfileAssignment, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "automanage.ConfigurationProfileAssignmentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("automanage.ConfigurationProfileAssignmentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cpa.Response.Response, err = future.GetResult(sender); err == nil && cpa.Response.Response.StatusCode != http.StatusNoContent {
		cpa, err = client.CreateOrUpdateResponder(cpa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "automanage.ConfigurationProfileAssignmentsCreateOrUpdateFuture", "Result", cpa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConfigurationProfilePreference definition of the configuration profile preference.
type ConfigurationProfilePreference struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the configuration profile preference.
	Properties *ConfigurationProfilePreferenceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; ARM resource id of the Automanage assignment.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Automanage assignment.
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Region where the VM is located.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfilePreference.
func (cpp ConfigurationProfilePreference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpp.Properties != nil {
		objectMap["properties"] = cpp.Properties
	}
	if cpp.Tags != nil {
		objectMap["tags"] = cpp.Tags
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfilePreferenceAntiMalware automanage configuration profile Antimalware preferences.
type ConfigurationProfilePreferenceAntiMalware struct {
	// EnableRealTimeProtection - Enables or disables Real Time Protection. Possible values include: 'True', 'False'
	EnableRealTimeProtection EnableRealTimeProtection `json:"enableRealTimeProtection,omitempty"`
	// Exclusions - Extensions, Paths and Processes that must be excluded from scan
	Exclusions interface{} `json:"exclusions,omitempty"`
	// RunScheduledScan - Enables or disables a periodic scan for antimalware. Possible values include: 'RunScheduledScanTrue', 'RunScheduledScanFalse'
	RunScheduledScan RunScheduledScan `json:"runScheduledScan,omitempty"`
	// ScanType - Type of scheduled scan. Possible values include: 'Quick', 'Full'
	ScanType ScanType `json:"scanType,omitempty"`
	// ScanDay - Schedule scan settings day
	ScanDay *string `json:"scanDay,omitempty"`
	// ScanTimeInMinutes - Schedule scan settings time
	ScanTimeInMinutes *string `json:"scanTimeInMinutes,omitempty"`
}

// ConfigurationProfilePreferenceList the response of the list ConfigurationProfilePreference operation.
type ConfigurationProfilePreferenceList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list ConfigurationProfilePreference operation.
	Value *[]ConfigurationProfilePreference `json:"value,omitempty"`
}

// ConfigurationProfilePreferenceProperties automanage configuration profile preference properties.
type ConfigurationProfilePreferenceProperties struct {
	// VMBackup - The custom preferences for Azure VM Backup.
	VMBackup *ConfigurationProfilePreferenceVMBackup `json:"vmBackup,omitempty"`
	// AntiMalware - The custom preferences for Azure Antimalware.
	AntiMalware *ConfigurationProfilePreferenceAntiMalware `json:"antiMalware,omitempty"`
}

// ConfigurationProfilePreferenceVMBackup automanage configuration profile VM Backup preferences.
type ConfigurationProfilePreferenceVMBackup struct {
	// TimeZone - TimeZone optional input as string. For example: Pacific Standard Time
	TimeZone *string `json:"timeZone,omitempty"`
	// InstantRpRetentionRangeInDays - Instant RP retention policy range in days
	InstantRpRetentionRangeInDays *int32 `json:"instantRpRetentionRangeInDays,omitempty"`
	// RetentionPolicy - Retention policy with the details on backup copy retention ranges.
	RetentionPolicy *string `json:"retentionPolicy,omitempty"`
	// SchedulePolicy - Backup schedule specified as part of backup policy.
	SchedulePolicy *string `json:"schedulePolicy,omitempty"`
}

// ErrorResponse ARM error response body.
type ErrorResponse struct {
	// Error - Details about the error.
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ErrorResponseBody an error response from the Automanage service.
type ErrorResponseBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// Operation automanage REST API operation
type Operation struct {
	// Name - Operation name: For ex. providers/Microsoft.Automanage/configurationProfileAssignments/write or read
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *string `json:"isDataAction,omitempty"`
	// Display - Provider, Resource, Operation and description values.
	Display *OperationDisplay `json:"display,omitempty"`
	// OperationProperties - Provider, Resource, Operation and description values.
	*OperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "isDataAction":
			if v != nil {
				var isDataAction string
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				o.IsDataAction = &isDataAction
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		}
	}

	return nil
}

// OperationDisplay provider, Resource, Operation and description values.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Automanage
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed:  For ex.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description about operation.
	Description *string `json:"description,omitempty"`
}

// OperationList the response model for the list of Automanage operations
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - List of Automanage operations supported by the Automanage resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// OperationProperties provider, Resource, Operation and description values.
type OperationProperties struct {
	// StatusCode - Service provider: Microsoft.Automanage
	StatusCode *string `json:"statusCode,omitempty"`
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; ARM resource id of the Automanage assignment.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Automanage assignment.
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Region where the VM is located.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - READ-ONLY; ARM resource id of the Automanage assignment.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Automanage assignment.
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Region where the VM is located.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; ARM resource id of the Automanage assignment.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Automanage assignment.
	Name *string `json:"name,omitempty"`
	// Location - READ-ONLY; Region where the VM is located.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}
