The [OLM catalog][1] is bundle of manifests including the [CSV][2], CRDs and package manifests of an operator, needed by the [OLM][3] to manage the operator.
The OCS OLM catalog is located under `deploy/olm-catalog`.

## Converged catalog

For OCS, a converged catalog is built containing a converged CSV and all the CRDs needed, to deploy ocs-operator, Rook and noobaa-operator.

The converged CSV is created by sourcing CSV manifests from each component-level operator to create a single unified CSV capable of deploying the component-level operators as well as the ocs-operator.

### Building the converged catalog

Building the unifed CSV is broken into two steps which are supported by the `make source-manifests` and `make gen-release-csv` make targets.

#### Source component manifests

Source in the component-level manifests from the component-level operator container images.

Set environment variables referencing the ROOK and NOOBAA container images to source the CSV/CRD data from. Then execute `make source-manifests`

```console
$ export ROOK_IMAGE=<add rook image url here>
$ export NOOBAA_IMAGE=<add noobaa image url here>
$ make source-manifests
```

The above example will source manifests in from the supplied container images and store those manifests in `build/_outdir/csv-templates/`

#### Generate converged catalog

The converged catalog is generated by the `tools/csv-merger` tool by merging together all the manifests sourced before.

To generate the converged catalog, set environment variables related to CSV versioning and also set environment variables representing the container images that should be used in the deployments.

> NOTE: Floating tags like 'master' and 'latest' should never be used in an official release.

```console
$ export CSV_VERSION=0.0.2
$ export REPLACES_CSV_VERSION=0.0.1
$ export ROOK_IMAGE=<add rook image url here>
$ export NOOBAA_IMAGE=<add noobaa image url here>
$ export OCS_IMAGE=<add ocs operator image url here>
$ export ROOK_CSI_CEPH_IMAGE=<add image here>
$ export ROOK_CSI_REGISTRAR_IMAGE=<add image here>
$ export ROOK_CSI_RESIZER_IMAGE=<add image here>
$ export ROOK_CSI_PROVISIONER_IMAGE=<add image here>
$ export ROOK_CSI_SNAPSHOTTER_IMAGE=<add image here>
$ export ROOK_CSI_ATTACHER_IMAGE=<add image here>

$ make gen-release-csv
```

This example results in both a unified CSV along with all the corresponding CRDs being placed in `deploy/olm-catalog/ocs-operator/0.0.2/` for release.

#### Helper script

To simplify the process of updating the catalog for a release, a helper script `hack/generate-latest-csv.sh` and a make target are provided.

To update the catalog for a release, update the images versions in the helper script and then run

```console
$ make gen-latest-csv
```

This updates a the catalog bundle for the release, and also generates a checksum in `hack/latest-csv-checksum.md5` which is used to verify that the catalog has been correctly updated in CI.

> NOTE: This script needs to be updated whenever a new release branch is created, to create and update a new release in the catalog.

## Creating a new release channel

On creation of new release branch, a new release channel needs to be generated on the master branch.
To do so,

1. bump `CSV_VERSION` in `hack/generate-latest-csv.sh` to the next OCS release version, for eg. `CSV_VERSION=4.4.0`
2. change `REPLACES_CSV_VERSION` in `hack/generate-latest-csv.sh` to the latest `CSV_VERSION` from the newly created release branch, for eg. `CSV_VERSION=4.3.99`
3. run `make gen-latest-csv`

This will create a new folder under `deploy/olm-catalog/ocs-operator`, and add the needed manifests into it.
With the above example versions, `deploy/olm-catalog/ocs-operator/4.4.0` would be created, with `deploy/olm-catalog/ocs-operator/4.4.0/ocs-operator.v4.4.0.clusterserviceversion.yaml` as the CSV manifest.
Ensure that this directory and all its contents are committed.

Edit the OLM package manifest, `deploy/olm-catalog/ocs-operator/ocs-operator.package.yaml` to add a new release channel and set it as the defaultChannel.
For eg.,

```yaml
packageName: ocs-operator
channels:
- name: 4.2.0
  currentCSV: ocs-operator.v0.0.1
- name: 4.3.0
  currentCSV: ocs-operator.v4.3.99
- name: 4.4.0
  currentCSV: ocs-operator.v4.4.0
defaultChannel: 4.4.0
```

## Creating a new version in a release channel

To create a new version in a release channel,

1. bump `CSV_VERSION` in `hack/generate-latest-csv.sh` to the new version, for eg. `CSV_VERSION=4.3.99`
2. change `REPLACES_CSV_VERSION` in `hack/generate-latest-csv.sh` to the previous version, for eg. `CSV_VERSION=4.3.98`
3. run `make gen-latest-csv`

Similar to the creation of a new channel, this also creates a new folder under `deploy/olm-catalog/ocs-operator` with the needed manifests.
For the above example versions, `deploy/olm-catalog/ocs-operator/4.3.99` would be created.
Ensure that this directory and all its contents are committed.

Edit OLM package manifest and change the `currentCSV` for the release channel to the new CSV version.
For eg.,

```yaml
packageName: ocs-operator
channels:
- name: 4.2.0
  currentCSV: ocs-operator.v0.0.1
- name: 4.3.0
  currentCSV: ocs-operator.v4.3.99
defaultChannel: 4.3.0
```


## Custom catalog registry

A catalog registry image needs to be generated, to make OCS available for the OLM in OCP.

Run `make ocs-registry` to generate the custom catalog registry container image.


[1]: https://github.com/operator-framework/operator-lifecycle-manager/blob/master/doc/design/architecture.md#catalog-registry-design
[2]: https://github.com/operator-framework/operator-lifecycle-manager/blob/master/doc/design/architecture.md#what-is-a-clusterserviceversion
[3]: https://github.com/operator-framework/operator-lifecycle-manager
