/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CephObjectRealmsGetter has a method to return a CephObjectRealmInterface.
// A group's client should implement this interface.
type CephObjectRealmsGetter interface {
	CephObjectRealms(namespace string) CephObjectRealmInterface
}

// CephObjectRealmInterface has methods to work with CephObjectRealm resources.
type CephObjectRealmInterface interface {
	Create(*v1.CephObjectRealm) (*v1.CephObjectRealm, error)
	Update(*v1.CephObjectRealm) (*v1.CephObjectRealm, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.CephObjectRealm, error)
	List(opts metav1.ListOptions) (*v1.CephObjectRealmList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephObjectRealm, err error)
	CephObjectRealmExpansion
}

// cephObjectRealms implements CephObjectRealmInterface
type cephObjectRealms struct {
	client rest.Interface
	ns     string
}

// newCephObjectRealms returns a CephObjectRealms
func newCephObjectRealms(c *CephV1Client, namespace string) *cephObjectRealms {
	return &cephObjectRealms{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the cephObjectRealm, and returns the corresponding cephObjectRealm object, and an error if there is any.
func (c *cephObjectRealms) Get(name string, options metav1.GetOptions) (result *v1.CephObjectRealm, err error) {
	result = &v1.CephObjectRealm{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectrealms").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CephObjectRealms that match those selectors.
func (c *cephObjectRealms) List(opts metav1.ListOptions) (result *v1.CephObjectRealmList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.CephObjectRealmList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectrealms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested cephObjectRealms.
func (c *cephObjectRealms) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectrealms").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a cephObjectRealm and creates it.  Returns the server's representation of the cephObjectRealm, and an error, if there is any.
func (c *cephObjectRealms) Create(cephObjectRealm *v1.CephObjectRealm) (result *v1.CephObjectRealm, err error) {
	result = &v1.CephObjectRealm{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("cephobjectrealms").
		Body(cephObjectRealm).
		Do().
		Into(result)
	return
}

// Update takes the representation of a cephObjectRealm and updates it. Returns the server's representation of the cephObjectRealm, and an error, if there is any.
func (c *cephObjectRealms) Update(cephObjectRealm *v1.CephObjectRealm) (result *v1.CephObjectRealm, err error) {
	result = &v1.CephObjectRealm{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("cephobjectrealms").
		Name(cephObjectRealm.Name).
		Body(cephObjectRealm).
		Do().
		Into(result)
	return
}

// Delete takes name of the cephObjectRealm and deletes it. Returns an error if one occurs.
func (c *cephObjectRealms) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephobjectrealms").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *cephObjectRealms) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephobjectrealms").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched cephObjectRealm.
func (c *cephObjectRealms) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephObjectRealm, err error) {
	result = &v1.CephObjectRealm{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("cephobjectrealms").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
