// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UploadSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// The SSH public key. The public key must be encoded in ssh-rsa format or PEM
	// format. The minimum bit-length of the public key is 2048 bits. For example,
	// you can generate a 2048-bit key, and the resulting PEM file is 1679 bytes
	// long.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of the following:
	//
	//    * Any printable ASCII character ranging from the space character (\u0020)
	//    through the end of the ASCII character range
	//
	//    * The printable characters in the Basic Latin and Latin-1 Supplement character
	//    set (through \u00FF)
	//
	//    * The special characters tab (\u0009), line feed (\u000A), and carriage
	//    return (\u000D)
	//
	// SSHPublicKeyBody is a required field
	SSHPublicKeyBody *string `min:"1" type:"string" required:"true"`

	// The name of the IAM user to associate the SSH public key with.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadSSHPublicKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UploadSSHPublicKeyInput"}

	if s.SSHPublicKeyBody == nil {
		invalidParams.Add(aws.NewErrParamRequired("SSHPublicKeyBody"))
	}
	if s.SSHPublicKeyBody != nil && len(*s.SSHPublicKeyBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SSHPublicKeyBody", 1))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful UploadSSHPublicKey request.
type UploadSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the SSH public key.
	SSHPublicKey *SSHPublicKey `type:"structure"`
}

// String returns the string representation
func (s UploadSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opUploadSSHPublicKey = "UploadSSHPublicKey"

// UploadSSHPublicKeyRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Uploads an SSH public key and associates it with the specified IAM user.
//
// The SSH public key uploaded by this operation can be used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
//
//    // Example sending a request using UploadSSHPublicKeyRequest.
//    req := client.UploadSSHPublicKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSSHPublicKey
func (c *Client) UploadSSHPublicKeyRequest(input *UploadSSHPublicKeyInput) UploadSSHPublicKeyRequest {
	op := &aws.Operation{
		Name:       opUploadSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadSSHPublicKeyInput{}
	}

	req := c.newRequest(op, input, &UploadSSHPublicKeyOutput{})
	return UploadSSHPublicKeyRequest{Request: req, Input: input, Copy: c.UploadSSHPublicKeyRequest}
}

// UploadSSHPublicKeyRequest is the request type for the
// UploadSSHPublicKey API operation.
type UploadSSHPublicKeyRequest struct {
	*aws.Request
	Input *UploadSSHPublicKeyInput
	Copy  func(*UploadSSHPublicKeyInput) UploadSSHPublicKeyRequest
}

// Send marshals and sends the UploadSSHPublicKey API request.
func (r UploadSSHPublicKeyRequest) Send(ctx context.Context) (*UploadSSHPublicKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UploadSSHPublicKeyResponse{
		UploadSSHPublicKeyOutput: r.Request.Data.(*UploadSSHPublicKeyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UploadSSHPublicKeyResponse is the response type for the
// UploadSSHPublicKey API operation.
type UploadSSHPublicKeyResponse struct {
	*UploadSSHPublicKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UploadSSHPublicKey request.
func (r *UploadSSHPublicKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
