package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectImageBodies invokes the imm.DetectImageBodies API synchronously
// api document: https://help.aliyun.com/api/imm/detectimagebodies.html
func (client *Client) DetectImageBodies(request *DetectImageBodiesRequest) (response *DetectImageBodiesResponse, err error) {
	response = CreateDetectImageBodiesResponse()
	err = client.DoAction(request, response)
	return
}

// DetectImageBodiesWithChan invokes the imm.DetectImageBodies API asynchronously
// api document: https://help.aliyun.com/api/imm/detectimagebodies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetectImageBodiesWithChan(request *DetectImageBodiesRequest) (<-chan *DetectImageBodiesResponse, <-chan error) {
	responseChan := make(chan *DetectImageBodiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectImageBodies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectImageBodiesWithCallback invokes the imm.DetectImageBodies API asynchronously
// api document: https://help.aliyun.com/api/imm/detectimagebodies.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DetectImageBodiesWithCallback(request *DetectImageBodiesRequest, callback func(response *DetectImageBodiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectImageBodiesResponse
		var err error
		defer close(result)
		response, err = client.DetectImageBodies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectImageBodiesRequest is the request struct for api DetectImageBodies
type DetectImageBodiesRequest struct {
	*requests.RpcRequest
	ImageUri string `position:"Query" name:"ImageUri"`
	Project  string `position:"Query" name:"Project"`
}

// DetectImageBodiesResponse is the response struct for api DetectImageBodies
type DetectImageBodiesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	ImageUri  string       `json:"ImageUri" xml:"ImageUri"`
	Bodies    []BodiesItem `json:"Bodies" xml:"Bodies"`
}

// CreateDetectImageBodiesRequest creates a request to invoke DetectImageBodies API
func CreateDetectImageBodiesRequest() (request *DetectImageBodiesRequest) {
	request = &DetectImageBodiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "DetectImageBodies", "imm", "openAPI")
	return
}

// CreateDetectImageBodiesResponse creates a response to parse from DetectImageBodies response
func CreateDetectImageBodiesResponse() (response *DetectImageBodiesResponse) {
	response = &DetectImageBodiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
